'use strict';
define(() => {
  /**
   * Fonction de reprogrammation d'une intervention simple
   */
  let gcelement = (FeatureTypeFactory, AssociationFactory, extendedNgDialog, $q, $filter, $timeout,
      $rootScope, gaJsUtils) => {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/isReprogram.html',
      restrict: 'A',
      scope: {
        isMode: '=',
        isFormData: '=',
        reprogram: '&?'
      },
      link: (scope) => {

        /**
         * Créé les données de la dualListBox permettant de sélectionner
         * les attributs du formulaire pour lesquels on copiera les valeurs entre l'objet source et l'objet créé
         * @return {Promise}
         */
        const setReprogramDualListBoxAssociations = () => {
          const defer = $q.defer();
          scope.reprogramDualListBoxAssociations = {
            leftData: [],
            leftDisplayAttribute: 'alias',
            rightData: [],
            rightDisplayAttribute: 'alias',
            leftTitle: 'tools.builder.intervention_simple.reusedAssociations',
            rightTitle: 'tools.builder.intervention_simple.availableAssociations',
            source: 'right'
          };
          if(gaJsUtils.notNullAndDefined($rootScope.xgos, 'portal.parameters.mainDB')) {
            AssociationFactory.getAll($rootScope.xgos.portal.parameters.mainDB).then(
                (res) => {
                  if (Array.isArray(res.data)) {
                    const allAss = res.data;
                    const isAsstableEqualsFtiName = (association, side) => {
                      const sideTable = side + 'table';
                      return !association.type_patrimoine && association.hasOwnProperty(sideTable)
                          && association[sideTable] === scope.isFormData.fti_info.name;
                    };

                    let availableAss = allAss
                    .filter(ass => isAsstableEqualsFtiName(ass, 'a') || isAsstableEqualsFtiName(ass, 'b'));
                    scope.reprogramDualListBoxAssociations.rightData = angular.copy(availableAss);

                    if (!scope.isFormData.reprogram.associationToLoad) {
                      scope.isFormData.reprogram.associationToLoad = [];
                    }

                    scope.reprogramDualListBoxAssociations.leftData = scope.isFormData.reprogram.associationToLoad;

                    defer.resolve();
                  } else {
                    defer.resolve();
                  }
                }
            ).catch(error => {
              console.log(error.data);
              defer.reject(error);
            });
          } else {
            require('toastr').error($filter('translate')('model.association.noMainDB'));
            defer.resolve();
          }
          return defer.promise;
        };

        /**
         * Créé les données de la dualListBox permettant de sélectionner les associations
         * du formulaire pour lesquelles on copiera les valeurs entre l'objet source et l'objet créé
         */
        const setReprogramDualListBoxAttributes = () => {
          const fti = FeatureTypeFactory.getFeatureByName(scope.isFormData.fti_info.name);
          if (fti) {
            const allFtiAttributes = fti.attributes.map(attr => Object({'name': attr.name, 'alias': attr.alias}));
            if (!scope.isFormData.reprogram) {
              scope.isFormData.reprogram = {};
            }
            if (!Array.isArray(scope.isFormData.reprogram.attributesToLoad)) {
              scope.isFormData.reprogram.attributesToLoad = [];
            }
            return {
              leftData: scope.isFormData.reprogram.attributesToLoad,
              leftDisplayAttribute: 'alias',
              rightData: allFtiAttributes,
              rightDisplayAttribute: 'alias',
              leftTitle: 'tools.builder.intervention_simple.reusedAttributes',
              rightTitle: 'tools.builder.intervention_simple.availableAttributes',
              source: 'right'
            };
          }
        };

        /**
         * Récupère les données pour alimenter les dualListBox et ouvre la popup de configuration
         * de la fonction de reprogrammation d'une intervention simple
         */
        scope.openReprogramCfg = () => {
          if (!scope.isFormData.reprogram) {
            scope.isFormData.reprogram = {};
          }
          // isCLosing palie la défaillance de extendedNgDialog qui exécute 2x preCloseCallback
          let isClosing = false;

          let toRestoreReprogram = angular.copy(scope.isFormData.reprogram);

          setReprogramDualListBoxAssociations().finally(
              () => {
                scope.reprogramDualListBoxAttributes = setReprogramDualListBoxAttributes();
                extendedNgDialog.open({
                  template: 'js/XG/widgets/utilities/form/views/cfg/reprogram.html',
                  className: 'ngdialog-theme-plain is-reprogram-config miniclose',
                  closeByDocument: false,
                  scope: scope,
                  title: $filter('translate')('tools.builder.intervention_simple.reprogramConfigTitle'),
                  draggable: true,
                  resizable: true,
                  minWidth: '650px',
                  minHeight: '610px',
                  preCloseCallback: () => {
                    if (!isClosing) {
                      if (!scope.isFormData.reprogram.save) {
                        scope.isFormData.reprogram = toRestoreReprogram;
                      } else {
                        delete scope.isFormData.reprogram.save;
                      }
                      isClosing = true;
                    }
                  }
                });
                changeReprogramPopupCloseBtnTooltip(0);
              }
          );
        };

        /**
         * Ajoute un(e) titre/tooltip au bouton close (croix) de la popup.
         * @param tryCount nombre de vérification de la présence de l'élément html de la popup
         */
        const changeReprogramPopupCloseBtnTooltip = (tryCount) => {
          const reprogramPopup = document.querySelector('.is-reprogram-popup.popupContainer');
          if (reprogramPopup) {
            const closeBtn = reprogramPopup.querySelector('.closebtn');
            if (closeBtn) {
              const closeBtnTitle = $filter('translate')('tools.builder.intervention_simple.cancelReprogramChanges');
              closeBtn.setAttribute("title", closeBtnTitle);
            }
          } else {
            if (tryCount < 3) {
              $timeout(() => {
                changeReprogramPopupCloseBtnTooltip(++tryCount);
              }, 400);
            }
          }
        };
      },
    };
  };

    gcelement.$inject = ['FeatureTypeFactory', 'AssociationFactory', 'extendedNgDialog', '$q',
      '$filter', '$timeout', '$rootScope', 'gaJsUtils'];
    return gcelement;
});