'use strict';
define(function() {
  var functionsBrowser = function(
    gcformfunction,
    ngDialog,
    $rootScope,
    $filter,
    FeatureTypeFactory,
    ImportTransferLayerFactory,
    ApplicationFactory
  ) {
    var availableFunctions = [];
    gcformfunction.getfunctions().forEach(function(func) {
      availableFunctions.push(func);
    });
    /**
     * get function description from availableFunctions list
     *
     * @param label
     * @returns {string}
     */
    var getFunctionDescription = function(label) {
      var description = '';
      for (var i in availableFunctions) {
        if (availableFunctions[i].label == label) {
          description = angular.copy(availableFunctions[i].description);
          break;
        }
      }
      return description;
    };

    /**
     * get function parameters from availableFunctions list + set correct values
     *
     * @param label
     * @param template
     * @returns {string}
     */
    var getFunctionParameters = function(label, template) {
      var parameters = [];
      for (var i in availableFunctions) {
        if (availableFunctions[i].label == label) {
          parameters = angular.copy(availableFunctions[i].parameters);
          if (angular.isArray(parameters)) {
            var pos_ouv = template.indexOf('(');
            let pos_fer = template.lastIndexOf(')');
            let argsStr = template.substring(pos_ouv + 1,pos_fer);

            argsStr.split(',').forEach(function(arg, index) {
              // object
              if (arg.indexOf('kisbuilderobj#') == 0) {
                arg = JSON.parse(
                  arg.replace(/;/g, ',').replace('kisbuilderobj#', '')
                );
                parameters[index].value = arg;
                // string
              } else {
                if (parameters[index]) parameters[index].value = arg;
              }
            });
          }
          break;
        }
      }
      return parameters;
    };

    /**
     * Format functions list for tree display
     *
     * @param functions
     * @returns {Array}
     */
    var formatFunctionsForTree = function(functions) {
      var formatted = [];
      if (angular.isArray(functions)) {
        functions.forEach(function(func) {
          var formattedFunc = {};
          formattedFunc.label = func.split('(')[0];
          formattedFunc.template = func;
          formattedFunc.description = getFunctionDescription(
            formattedFunc.label
          );
          formattedFunc.parameters = getFunctionParameters(
            formattedFunc.label,
            formattedFunc.template
          );

          formatted.push(formattedFunc);
        });
      }

      return formatted;
    };

    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/functionsBrowser.html',
      restrict: 'E',
      scope: {
        functions: '=?',
        formInfo: '=?',
        editIndex: '=?',
      },
      controller: [
        '$scope',
        function($scope) {
          $scope.currentFunctionsTree = {};
          $scope.availableFunctionsTree = {};

          $scope.availableFunctions = availableFunctions;
          $scope.currentFunctions = formatFunctionsForTree($scope.functions);
        },
      ],
      link: function(scope) {
        scope.xgos = $rootScope.xgos;

        if (!angular.isDefined(scope.functions)) {
          scope.functions = [];
        }

        // retrieve form data
        scope.currentBuilderForm = $rootScope.currentBuilderForm;


        scope.pickedFunction = {};
        scope.pickAvailableFunction = function(branch) {
          scope.pickedFunction = branch;
        };

        // init fti list
        FeatureTypeFactory.get().then(components => {
          scope.componentsList = components;
        });

        var indexator = function() {
          scope.currentFunctions.map(function(c, index) {
            c.index = index;
          });
        };

        scope.editFunction = {};
        scope.editFunctionIndex = -1;

        // -------
        // Functions related to transferLayerConfigSelector 
        // -------
        /**
         * get the names of all map applications and put it in scope.mapAppNames as list
         * @param {*} param
         */
        scope.getMapAppNames = (param) => {
          if (!scope.mapAppNames) {
            ApplicationFactory.get(true).then( res => {
              if (Array.isArray(res.data)) {
                scope.mapAppNames = res.data
                  .filter(app => app.type==='MapApp')
                  .map(app => app.name);
                // si seulement 1 element -> on le selectionne
                if (!param.app && Array.isArray(scope.mapAppNames) && scope.mapAppNames.length === 1) {
                  param.app = scope.mapAppNames[0];
                }
                scope.updateTransferLayerConfigList(param.app);
              }
            }, error => {
              scope.mapAppNames = [];
            });
          }
        };
        /**
         * get the names of the configs of TransferLayerWidget in the selected app (appName)
         * @param {*} appName 
         */
        scope.updateTransferLayerConfigList = (appName) => {
          if (typeof appName === 'string' && appName.length > 0) {
            if (!scope.transferLayerConfigsList) {
              scope.transferLayerConfigsList = [];
            }
            //init transferLayerConfigsList
            ImportTransferLayerFactory.getConfigNames(appName).then( res => {
              scope.transferLayerConfigsList[appName] = res.data;
            }, error => {
              scope.transferLayerConfigsList[appName] = [];
            });
          }
        };
        scope.setTransferLayerParam = (param) => {
          param.value = '\'' + param.app  + '|'+ param.config +  '\'';
        };
        // -------

        scope.selectEditFunction = function (index) {
          if (scope.currentFunctions.length > 0) {
            indexator();
            scope.editFunctionIndex = index;
            scope.editFunction = scope.currentFunctions[index];

            // construction du model des toggleswitch de la fonction en cours d'édition
            // le toggleswitch n'est actuellement utilisé que pour distinguer date/attribut
            if (scope.editFunction.parameters) {
              const parameters = scope.editFunction.parameters;
              for (let iPar = 0; iPar < parameters.length; iPar++) {
                if (parameters[iPar].type === 'double' || parameters[iPar].type === 'double positif') {
                  if (typeof parameters[iPar].value === 'string') {
                    parameters[iPar].value = parameters[iPar].value.replace(',', '.').replaceAll('\'', '');
                  }
                  parameters[iPar].value = parseFloat(parameters[iPar].value);
                }
              }

              // handle boolean retrocompatibility for delObject
              if (scope.editFunction.label === "delObject"
                && scope.editFunction.parameters[2].value === "'true'") {
                  scope.editFunction.parameters[2].value = "'tab-true'";
              }

              // init parameters
              for (const param of scope.editFunction.parameters) {
                if (param.type === 'transferLayerConfigSelector') {
                  scope.getMapAppNames(param);
                  if (typeof param.value ==='string' && param.value.includes('|')) {
                    let appAndConfig = param.value.replaceAll("'", '').split('|');
                    param.config = appAndConfig.pop();
                    param.app = appAndConfig.pop();
                  }
                }
              }

              for (
                let paramIndex = 0;
                paramIndex < scope.editFunction.parameters.length;
                paramIndex++
              ) {
                if (scope.editFunction.parameters[paramIndex].type === 'dateSwitch') {
                  scope.switcher = scope.switcher ? scope.switcher : {};
                  scope.switcher[index] = scope.switcher[index] ? scope.switcher[index] : {};
                  // switcher[indexFonction][indexParam] est true
                  // quand la valeur du paramètre est une date valide
                  scope.switcher[index][paramIndex] = moment(
                    scope.editFunction.parameters[paramIndex].value,
                    'DD/MM/YYYY',
                    true
                  ).isValid();
                }
              }
            }
          } else {
            scope.editFunction = null;
          }
        };

        if (scope.editIndex !== false) {
          scope.forcePristine = true;
          scope.selectEditFunction(scope.editIndex);
        }

        /**
         * Move the
         *
         * @index function in
         * @direction
         * @param index
         * @param direction
         */
        scope.moveFunction = function(index, direction) {
          if (
            (index == 0 && direction == 'up') ||
            (index == scope.currentFunctions.length - 1 && direction == 'down')
          )
            return false;
          var newIndex = direction == 'up' ? index - 1 : index + 1;
          scope.currentFunctions.splice(
            index,
            0,
            scope.currentFunctions.splice(newIndex, 1)[0]
          );
          scope.selectEditFunction(newIndex);
        };
        scope.removeFunction = function(index) {
          scope.currentFunctions.splice(index, 1);
          scope.selectEditFunction(0);
        };

        scope.addFunction = function(func) {
          var sFunc = angular.copy(func);
          if (sFunc.hasOwnProperty('template')) {
            var formattedFunc = {};
            formattedFunc.label = sFunc.label;
            formattedFunc.template = sFunc.template;
            formattedFunc.description = getFunctionDescription(
              formattedFunc.label
            );
            formattedFunc.parameters = getFunctionParameters(
              formattedFunc.label,
              formattedFunc.template
            );

            scope.currentFunctions.push(formattedFunc);

            require('toastr').success(
              $filter('translate')('functions_browser.functions_picker.added'),
              '',
              {
                positionClass: 'toast-bottom-right',
              }
            );
          }
        };

        scope.toSaveFunctions = [];
        scope.pristine = true;

        scope.getObjectValueParam = param => typeof param === 'object' ? param : {};

        scope.parseToNumber = (value) => {
          if(value == '' || isNaN(value)){
            return 0;
          }else{
            return parseInt(value);
          }
        };

        scope.$watch(
          'currentFunctions',
          function(cf) {
            scope.toSaveFunctions = [];
            if (typeof cf != 'undefined' && cf.length > 0) {
              scope.toSaveFunctions = [];
              cf.forEach(function(f) {
                // create function call template
                var call = '';
                if (angular.isDefined(f.parameters)) {
                  call = f.parameters
                    .map(function(p) {
                      if (angular.isDefined(p.value)) {
                        // teste si la valeur est une date en string
                        const paramValueIsDate = moment(p.value,'DD/MM/YYYY',true).isValid();

                        if(paramValueIsDate){
                          // transforme string en Date JS pour alimenter le datepicker
                          p.value = new Date(moment(p.value,'DD/MM/YYYY').format('YYYY-MM-DD'));

                          // retourne une string formatée pour la création du call template
                          return moment(p.value,'DD/MM/YYYY').format('DD/MM/YYYY');
                        }

                        if (typeof p.value == 'object') {

                          if (p.value instanceof Date){
                            // retourne une string formatée pour la construction du call template
                            return moment(p.value).format('DD/MM/YYYY');
                          }
                          // @TODO eviter les key : "'valeur'"
                          return (
                            'kisbuilderobj#' +
                            JSON.stringify(p.value).replace(/,/g, ';')
                          );
                        }
                        else if (p.value.trim) {
                          var returnvalue = p.value.trim(),
                            nbQuotes = (returnvalue.match(/'/g) || []).length;

                          // clean extra quotes in strings
                          if (
                            nbQuotes > 2 &&
                            returnvalue.charAt(0) == '\'' &&
                            returnvalue.charAt(returnvalue.length - 1) == '\''
                          ) {
                            let escaped = returnvalue
                              .substring(1, returnvalue.length - 1)
                              .replace(/'/g, '\\\'');
                            // disgusting but avoids multiple escaping XD
                            escaped = escaped.replace(/\\\\'/g, '\\\'');

                            returnvalue = '\'' + escaped + '\'';
                          }
                          return returnvalue;
                        }
                        else {
                          return p.value;
                        }
                      }
                    })
                    .join(',');
                }

                call = f.label + '(' + call + ')';
                f.template = call;
                scope.toSaveFunctions.push(call);
              });

              if (scope.forcePristine) {
                scope.forcePristine = false;
              } else {
                scope.pristine = false;
              }
            }
          },
          1
        );

        scope.setAttributeForParam = (param) => {
          param.value = '\'' + param.att + '\'';
        };


        scope.closeBrowser = function() {
          if (
            scope.pristine ||
            confirm('Êtes vous certain de vouloir fermer sans enregister ?')
          ) {
            var id = $('.ngdialog-overlay:last').attr('id');
            ngDialog.close(id);
          }
        };
        scope.saveFunctions = function() {
          scope.functions = scope.toSaveFunctions;
          require('toastr').success(
            $filter('translate')('functions_browser.functions_picker.saved'),
            '',
            {
              positionClass: 'toast-bottom-left',
            }
          );
          scope.pristine = true;
        };

        scope.openForm = function(openData) {
          if (openData.name.indexOf('.form') == -1) {
            openData.name += '.form';
          }

          scope.editFunction.parameters[0].value =
            '\'' + openData.type + '.' + openData.name + '\'';
        };

        /**
         * deleteKeyFromObject
         *
         * @param obj
         * @param key
         */
        scope.deleteKeyFromObject = function(obj, key) {
          if (obj && obj[key]) delete obj[key];
          // if(obj.hasOwnProperty(key)) delete obj[key];
        };

        scope.openConfigBrowser = function($index) {
          ngDialog.open({
            template:
              'js/XG/widgets/utilities/form/views/modal/builderOpen.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.tabPopupCheckboxChanged = (previousValue,index) => {
          if (previousValue === "'tab-true'") {
            scope.currentFunctions[scope.editFunctionIndex].parameters[index].value =
              "'tab-false'";
          } else {
            scope.currentFunctions[scope.editFunctionIndex].parameters[index].value =
              "'tab-true'";
          }
        };

        /**
         * build the name with quotes.
         * we can use it as 'on-change' parameter on <model-relation>
         * @param {object} relation
         * @returns the builded string
         */
        scope.buildParamWithQuotes = (relation) =>{
          return "'" + relation.name + "'";
        }

        /**
         * only for function calculInterval()
         * set parameters[4].value to 'true' when 'hour' is selected on parameter[3]
         */
        scope.handleRadioCalculInterval = () => {
          if (scope.editFunction.parameters[3].value === '\'hour\'' && scope.editFunction.parameters[4].value === 'false') {
            scope.editFunction.parameters[4].value = 'true';
          }
        }
      },
    };
  };

  functionsBrowser.$inject = [
    'gcformfunction',
    'ngDialog',
    '$rootScope',
    '$filter',
    'FeatureTypeFactory',
    'ImportTransferLayerFactory',
    'ApplicationFactory'
  ];
  return functionsBrowser;
});
