'use strict';
define(function() {
  var formBuilderFtiAttributeArray = function(FeatureTypeFactory, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/formBuilderFtiAttributeArray.html',
      restrict: 'EA',
      scope: {
        res: '=?', // res contient le resultat de la dernière sélection sous le format "uid;attribut"
        ftidst: '=?ftidst', // ftidst contient la liste des toutes les sélectoin 
                            // sous le format "uid1;attribut1/uid2;attribut2"
        functionindex: '=?' // le rang de la fonction dans le formBuilder. 
                            // c'est très utile dans le cas ou on passe d'une fonction 
                            // à une autre de même type(setData -> set data) pour rafraichir la directive
      },
      link: function(scope) {
        scope.init = () => {
          // a chaque reload on met ftid a undefined pour ne pas garder 
          // la valeur selection dans gccomponent
          scope.ftid = undefined;
          scope.myfti = {};
          scope.lines = [];
          // If we dont find the lines in res, check in ftidst
          // If default value, initialise empty ftidst
          if(scope.ftidst === 'fids' || scope.ftidst === 'Composants') {
            scope.ftidst = undefined;
          }
          else if (scope.ftidst && scope.lines.length === 0) {
            let ftidst = scope.ftidst.slice(1, scope.ftidst.length - 1);
            ftidst = ftidst.split('/');
            ftidst.forEach((uid) => {
              scope.lines.push({
                uid: uid.split(";")[0],
                alias: FeatureTypeFactory.getFeatureByUid(uid.split(";")[0]).alias,
                attribute: uid.split(";")[1],
                attributeAlias: FeatureTypeFactory.getFeatureByUid(uid.split(";")[0]).attributes.find(attribute => {
                                  return attribute.name === uid.split(";")[1];
                                }).alias
              });
            });
          }
        }
        scope.init();
        scope.$watch('functionindex', (newValue, oldValue) => {
          if (newValue !== oldValue) {
            scope.init();
          }
        }, true);

        /**
         * Add a line
         */
        scope.addLine = () => {
          if (scope.myfti.uid && scope.myAttribute.name) {
            // check if already set
            var found = scope.lines
              .map(function(l) {
                return l.uid+";"+l.attribute;
              })
              .indexOf(scope.myfti.uid+";"+scope.myAttribute.name);
            if (found === -1) {
              scope.lines.push({
                uid: scope.myfti.uid,
                alias: scope.myfti.alias,
                attribute: scope.myAttribute.name,
                attributeAlias: scope.myAttribute.alias
              });
            } else {
              require('toastr').error(
                $filter('translate')('form_builder_fti_array.already_set')
              );
            }
          }
        };

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.lines.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(innerLines) {
            scope.res = innerLines.map(function(l) {
              return l.uid+";"+l.attribute;
            });
            scope.resString = scope.res.join('/');
            if (scope.resString) {
              scope.ftidst = "'" + scope.resString + "'";
            }
          },
          1
        );
      },
    };
  };

  formBuilderFtiAttributeArray.$inject = ['FeatureTypeFactory', '$filter'];
  return formBuilderFtiAttributeArray;
});
