'use strict';
define(function() {
  const attributeRestrictions = function(QueryFactory, FeatureTypeFactory,
    UsersFactory, ngDialog, $timeout, $filter, $translate, $rootScope,
    gaJsUtils, gaDomUtils, attributeRestrictionsUtils, $q
  ) {
    /* Recuperation des labels pour les messages d'erreurs (Notification) */

    var msg_err_table_rest = '';

    $translate('rights.restriction.msgerrtablerestriction').then(function(res) {
      msg_err_table_rest = res;
    });
    /* fin Recuperation */
    return {
      templateUrl:
        'js/XG/widgets/utilities/form/views/attributeRestrictions.html',
      restrict: 'EA',
      scope: {
        res: '=?',
        attribute: '=',
        fti: '=fti',
        setAttr: '=?', // Change destination of res[attribute.name] to res[setAttr]
        fieldData: '=?',
        // values used for table restriction filter (in search tab of intervention simple)
        elasticData: '=?',
        // onChange calls the callback eveytime the value changes.
        // callback format: function(attibuteName, key)
        // only implemented for tables restriction
        onChange: '=?',
        displaySmallVersion: '<?', //only implemented for tables restrictions
        // display-as-text: (only implemented for tables and domaine restrictions)
        // affiche la donnée sous forme de text (donc readOnly)
        displayAsText: '<?',
        // Dans le cas de la table de données, contient les infos des autres filtres sur la liste de données
        // Utilisé dans le cas de la création d'un filtre dynamique
        otherFiltersInfos: '=?',
        alwaysEnable: '=?', // ne pas verifier la condition de read-only (ne pas disable le bouton)
        showCleanValueButton: '=?' // ne pas verifier la condition de read-only (ne pas disable le bouton)
      },
      link: function(scope, element, attrs, ctrl) {

        var tableRestrictionData  = {};
        let currentRestriction;
        scope.initAttributeRestrictions = function() {
          // dans l'ANC/BAC on force le tri des listes deroulantes sur ASC sauf si deja defini
          if (
            angular.isDefined($rootScope) &&
            angular.isDefined(scope.fieldData) &&
            angular.isDefined(scope.fieldData.config)
          ) {
            if (gaJsUtils.checkNestedProperty('xgos.sector', $rootScope)) {
              if (
                $rootScope.xgos.sector == 'anc' ||
                $rootScope.xgos.sector == 'bac'
              ) {
                if (
                  !gaJsUtils.checkNestedProperty(
                    'config.sort.order',
                    scope.fieldData
                  ) !== false
                ) {
                  gaJsUtils.setNestedProperty(
                    'config.sort.order',
                    scope.fieldData,
                    'ASC'
                  );
                }
              }
            }
          }
          if (scope.res == undefined) {
            scope.res = {};
          }
          if (angular.isDefined(scope.setAttr)) {
            scope.attributeToSet = scope.setAttr;
          } else {
            scope.attributeToSet = scope.attribute.name;
          }
          //handle legacy option
          if ((scope.fieldData != undefined) && (scope.fieldData.disabled == true)) {
            scope.fieldData.readonly = true;
            scope.fieldData.disabled = false;
          }
          scope.restrictions = false;
          scope.listofValues = [];
          /**
           * Handling restrictions
           */
          if (angular.isDefined(scope.setAttr)) {
            console.log(scope.setAttr);
          }

          if (
            !scope.attribute ||
            !scope.attribute.restrictions ||
            scope.attribute.restrictions.length == 0
          )
            return;
          // restriction Type
          scope.restrictions = [];

          scope.attribute.restrictions.forEach(function(r) {
            scope.restrictions.push(r.type);
          });

          // so far it only handles first restriction for the moment
          currentRestriction = scope.attribute.restrictions[0];
          if (currentRestriction.type == attributeRestrictionsUtils.INTERVAL) {
            scope.intervalmin = currentRestriction.interval.min;
            scope.intervalmax = currentRestriction.interval.max;
            if (currentRestriction.interval.mininclus == false) scope.intervalmin += 1;
            if (currentRestriction.interval.maxinclus == false) scope.intervalmax -= 1;

            // force default value for the parameter
            $timeout(function() {
              if (angular.isUndefined(scope.res[scope.attribute.name])) {
                scope.res[scope.attribute.name] = parseInt(
                  scope.intervalmin,
                  10
                );
              }
            });
          }

          scope.multiRes = [];

          if (currentRestriction.type == attributeRestrictionsUtils.INPUT_SIZE) {
            scope.pattern = '.{' + currentRestriction.minocc + ',' + currentRestriction.maxocc + '}';
            scope.patternDetail = currentRestriction.minocc + '-' + currentRestriction.maxocc;

            scope.restmin = currentRestriction.minocc;
            scope.restmax = currentRestriction.maxocc;

            scope.typeInput = 'text';
            if (scope.attribute.type == 'java.lang.Integer')
              scope.typeInput = 'number';
          }

          if (currentRestriction.type == attributeRestrictionsUtils.DOMAIN) {
            var keyAsInt =
              scope.fieldData && scope.fieldData.restrictionKeyAsInt == true;

            if (keyAsInt == undefined) {
              //this could lead to data miswritten in the database.
              // You should pass this parametre to "form-field". exemple:
              // field-data="{restrictionKeyAsInt: att.type === 'java.lang.Integer'}"
              console.warn('scope.fieldData.restrictionKeyAsInt is undefined -> no data type set');
            }

            var tmpValues = [];
            angular.forEach(currentRestriction.listofValues, function(value, key) {
              const translationKey = 'features.' + scope.fti.name +
              '.domaine.' + scope.attribute.name + '.' + key;
              let translation = $filter('translate')(translationKey);
              if (translation === translationKey) {
                //no translation available, we take th evalue instead
                translation = value;
              }
              tmpValues.push({
                val: keyAsInt ? parseInt(key) : key,
                translationKey: translationKey,
                translated: translation,
              });
            });

            if (
              scope.fieldData &&
              scope.fieldData.config &&
              scope.fieldData.config.sort
            ) {

              tmpValues.sort(function(a, b) {
                return a.translated.localeCompare(b.translated);
              });

              if (scope.fieldData.config.sort.order == 'DESC')
                tmpValues.reverse();
            }

            scope.listofValues = tmpValues;

            scope.domainRestrictionAllowDifferentValues =
              currentRestriction.domainRestrictionAllowDifferentValues;
            //scope.listofValues = currentRestriction.listofValues;
          }

          if (currentRestriction.type == attributeRestrictionsUtils.TABLE) {
            // get the id of the related table
            FeatureTypeFactory.get().then(function() {
              var fts = FeatureTypeFactory.resources.featuretypes;
              for (var i in fts) {
                if (fts[i].name == currentRestriction.table) {
                  tableRestrictionData.uid = fts[i].uid;
                }
              }
            });
            tableRestrictionData.restriction = currentRestriction;
            if (currentRestriction.allowMultipleSelection) {
              if (scope.res.hasOwnProperty(scope.attribute.name) && scope.res[scope.attribute.name]) {
                scope.multiRes[scope.attribute.name] = scope.res[scope.attribute.name].split('|');
              } else {
                scope.res[scope.attribute.name] = '';
                scope.multiRes[scope.attribute.name] = [];
              }
            }

            //update scope.labelDisplayed whenever value is changed
            if (scope.clearResAttributeWatcher) {
              scope.clearResAttributeWatcher();
            }
            // KIS-2993:
            // si le champ à mettre à jour possède une restriction
            // alors l’input de saisie est remplacé par un composant attributeRestriction
            // et res prend le type de expression.fiter => string
            if (typeof scope.res === 'string') {
              scope.clearResAttributeWatcher = scope.$watch('res', (keyOrKeys) => {
                updateLabelDisplayed(keyOrKeys);
              }, true);
            } else {
              scope.clearResAttributeWatcher = scope.$watch('res.' + scope.attribute.name, (keyOrKeys) => {
                updateLabelDisplayed(keyOrKeys);
              }, true);
            }
          }

          // If user restriction, try to autofill the field with current user
          if(currentRestriction.type === attributeRestrictionsUtils.USER) {
            // by default we store the login in DB
            if (currentRestriction.isLoginKey == undefined) {
              currentRestriction.isLoginKey = true;
            }
            //update scope.labelDisplayed whenever value is changed
            if (scope.clearResAttributeWatcher) {
              scope.clearResAttributeWatcher();
            }
            scope.clearResAttributeWatcher =
              scope.$watch('res.' + scope.attribute.name, (loginOrFullname) => {
                if (loginOrFullname) {
                  if (currentRestriction.isLoginKey) {
                    //search in ALL users because the user may not still have the role
                    UsersFactory.getLightUserByLogin(loginOrFullname)
                      .then(user => {
                          if(user && user.name && user.vorname) {
                            scope.labelDisplayed = attributeRestrictionsUtils.buildFullname(user.name, user.vorname);
                          } else {
                            console.error("Couldn't find user with login: " + scope.res[scope.attribute.name]);
                          }
                        });
                  } else {
                    scope.labelDisplayed = loginOrFullname;
                  }
                } else {
                  scope.labelDisplayed = '';
                }

              });
          }
        };

        scope.$watch('attribute', function () {
          scope.initAttributeRestrictions();
        });

        /**
         * Met à jour la valeur affichée dans l'input de la restriction d'attribut
         * @param keyOrKeys
         */
        const updateLabelDisplayed = (keyOrKeys) => {
          if (keyOrKeys != undefined && keyOrKeys != '') {
            if (currentRestriction.valueField !== currentRestriction.keyField
                && currentRestriction.keyField != undefined) {
              scope.labelDisplayed = "..."; // afficher un indicateur de chargement
              if (currentRestriction.allowMultipleSelection) {
                // multiple selection
                const promisesValues = [];
                for (let key of keyOrKeys.split('|')) {
                  if (key != undefined) {
                    promisesValues.push(QueryFactory.getValueRestrictionTable(scope.fti.uid, scope.attribute.name, key));
                  }
                }
                $q.all(promisesValues).then( values => {
                  // concat every value
                  scope.labelDisplayed = '';
                  for (let index in values) {
                    if (values[index].data && values[index].data.value) {
                      scope.labelDisplayed += values[index].data.value;
                    }
                    if (index < values.length-1) {
                      scope.labelDisplayed += ', ';
                    }
                  }
                }, () => {
                  scope.labelDisplayed = '';
                })
                // update scope.multiRes, it should always be up to date
                scope.multiRes[scope.attribute.name] = scope.res[scope.attribute.name].split('|');
              } else {
                // get value from key
                QueryFactory.getValueRestrictionTable(scope.fti.uid, scope.attribute.name, keyOrKeys)
                .then(res => {
                  if (res.data && res.data.value) {
                    scope.labelDisplayed = res.data.value;
                  } else {
                    scope.labelDisplayed = '';
                  }
                }, (err) => {
                  scope.labelDisplayed = '';
                  console.log("La clé " + keyOrKeys + " n'existe pas dans la table de restriction de l'attribut " + scope.attribute.name);
                });
              }
            } else {
              // no valueField -> no need to get the value: we display the key as is
              if (currentRestriction.allowMultipleSelection) {
                scope.labelDisplayed = keyOrKeys.replaceAll('|', ', ');
              } else {
                scope.labelDisplayed = keyOrKeys
              }
            }
          } else {
            scope.labelDisplayed = '';
            // clear the result array (for multiSelection)
            if (scope.multiRes && Array.isArray(scope.multiRes[scope.attribute.name])) {
              scope.multiRes[scope.attribute.name].splice(0, scope.multiRes[scope.attribute.name].length);
            }
          }
        };


        /**
         * Select a value from the restricted table
         * @param openPopup
         */
        scope.selectRestrictedValue = function(openPopup) {
          gaDomUtils.showGlobalLoader();
          const foreignFti = FeatureTypeFactory.getFeatureByUid(
            currentRestriction.ftid
          );
          let foreignAttribute;
          if (foreignFti && foreignFti.attributes != null) {
            foreignFti.attributes.forEach(function(attr) {
              if (
                attr.name == tableRestrictionData.restriction.valueField
              ) {
                foreignAttribute = attr;
              }
            });
          }
          if (
            angular.isDefined(tableRestrictionData.restriction) &&
            angular.isDefined(tableRestrictionData.restriction.valueField)
          ) {
            if (tableRestrictionData.restriction.applyFilter === true) {
                attributeRestrictionsUtils.prepareDynamicFilter(
                    tableRestrictionData.restriction.filterDefinition,
                    scope.fti, scope.res, scope.elasticData, scope.otherFiltersInfos)
                .then((filter) => {
                  scope.filterTranslated = filter.find(it => typeof it === 'string');
                  scope.updateTableRestriction(openPopup, foreignAttribute);
                }, error => {
                  console.error('error getting values from tables, the entire filter is removed');
                  //remove the entire where clause and don't display the dialog
                  scope.filterTranslated = '';
                  // Affectation de la valeur à undefined
                  scope.res[scope.attribute.name] = undefined;
                }).finally(() => {
                  gaDomUtils.hideGlobalLoader();
                });
            } else {
              scope.filterTranslated = '';
              scope.updateTableRestriction(openPopup, foreignAttribute);
            }
          }
        };

        scope.updateTableRestriction = (openPopup, foreignAttribute) => {
          // évalue si la table de restriction contient 1 ou 2 colonne(s)
          const hasValueAndKey = tableRestrictionData.restriction.valueField
            !== tableRestrictionData.restriction.keyField && (tableRestrictionData.restriction.keyField != undefined);
          QueryFactory.dataattributes(
            currentRestriction.ftid,
            tableRestrictionData.restriction.valueField,
            tableRestrictionData.restriction.keyField,
            scope.filterTranslated
          ).then((res) => {
            if (res && res.data) {
              scope.pickFieldValue = tableRestrictionData.restriction.valueField;
              scope.pickFieldkey = hasValueAndKey ? tableRestrictionData.restriction.keyField: undefined;
              let uniqvalues = [];
              if (res.data && res.data.features
                        && res.data.features.length
                        > 0) {
                for (let i = 0; i < res.data.features.length; i++) {
                  if (hasValueAndKey) {
                    // the table restriction contains 1 colomn
                    uniqvalues[i] = {
                      restrictedValue: res.data.features[i].properties[scope.pickFieldValue],
                      restrictedKey: res.data.features[i].properties[scope.pickFieldkey],
                      selected: true
                    };
                  } else {
                    // the table restriction contains 2 colomns -> we put the value in the key field
                    uniqvalues[i] = {
                      restrictedValue: res.data.features[i].properties[scope.pickFieldValue],
                      restrictedKey: res.data.features[i].properties[scope.pickFieldValue],
                      selected: true
                    };
                  }
                }
              }
              sortAttributesAndDefineType(openPopup,foreignAttribute,uniqvalues);
            } else {
              // si DataStoreTools#getUniqueValuesWithFilter a levé une exception et renvoyé null
              require('toastr').error(msg_err_table_rest);
              require('toastr').error($filter('translate')('rights.restriction.cant_access_layer')
                  + currentRestriction.table + ' (uid: ' + currentRestriction.ftid + ')');
            }
          }, error => {
            switch (error.status) {
              case 401:
                // Non-Autorisé
                require('toastr').error($filter('translate')('rights.restriction.cant_access_layer') 
                    + currentRestriction.table + ' (uid: ' + currentRestriction.ftid + ')');
                break;
              default:
                require('toastr').error(msg_err_table_rest);
                break;
            }
          }).finally( () => {
            gaDomUtils.hideGlobalLoader();
          });
        };

        scope.selectUserRestrictedValue = () => {
          if (currentRestriction && currentRestriction.type === attributeRestrictionsUtils.USER) {
            UsersFactory.getLightUsersByRoles(currentRestriction.roles)
              .then((res) => {
                // If no user to display, show a toast
                if (res.data.length === 0) {
                  let rolesAsString = '';
                  for (let role of currentRestriction.roles) {
                    rolesAsString += role + ' ';
                  }
                  require('toastr').warning($filter('translate')('model.featuretypes.attributes.restrictions.user.noUserWithRole') + rolesAsString);
                } else {
                  // Use this structure to reuse the table window: sortAttributesAndDefineType
                  scope.pickChoices = [];
                  for (let i = 0; i < res.data.length; i++) {
                    scope.pickChoices[i] = {
                      restrictedKey: res.data[i].login,
                      restrictedValue: attributeRestrictionsUtils.buildFullname(res.data[i].name, res.data[i].vorname),
                      selected: true
                    };
                  }
                  scope.pickFieldValue = $filter('translate')(
                    'model.featuretypes.attributes.restrictions.user.fullName');
                  scope.pickFieldkey = $filter('translate')(
                    'model.featuretypes.attributes.restrictions.user.login');

                  sortAttributesAndDefineType(true, {}, scope.pickChoices);
                }
              },
              () => {
                require('toastr').error($filter('translate')('rights.roles.retrieve_error'));
              });
          }
        };

        /**
         * Vide la valeur dans la restriction
         */
        scope.cleanRestrictedValue = () => {
          // Affectation de la valeur à undefined
          scope.res[scope.attribute.name] = null;

          // Recalcul des champs associés
          if (scope.attribute.updateField) {
            scope.$emit('callUpdateRelatedField', scope.attribute.updateField, scope.res[scope.attributeToSet]);
          }
        };

        function sortAttributesAndDefineType(openPopup, foreignAttribute, uniqvalues){
          let attrType = 'string';
          if (
            foreignAttribute.type == 'java.lang.Double' ||
              foreignAttribute.type == 'java.lang.Float' ||
              foreignAttribute.type == 'java.lang.Integer' ||
              foreignAttribute.type == 'java.math.BigDecimal'
          ) {
            attrType = 'number';
          }

          if (
            foreignAttribute.type == 'java.sql.Timestamp' ||
              foreignAttribute.type == 'java.sql.Time' ||
              foreignAttribute.type == 'java.sql.Date'
          ) {
            attrType = 'date';
          }

          //si config
          // si alpha ASC  uniqvalues.sort();
          // si alpha DESC contraire  uniqvalues.sort();
          // si num ASC  uniqvalues.sort(function(a,b) {return a - b; });
          // si num DESC
          var order = 'ASC';
          var sortType = 'alpha';
          if (attrType == 'number') sortType = 'num';
          if (attrType == 'date') sortType = 'date';

          if (
            scope.fieldData &&
              scope.fieldData.config &&
              scope.fieldData.config.sort
          ) {
            order = scope.fieldData.config.sort.order;
            if (scope.fieldData.config.sort.type == 'num')
              sortType = 'num';
            if (scope.fieldData.config.sort.type == 'date')
              sortType = 'date';
          }
          if (sortType == 'alpha')
            uniqvalues.sort(function f(a, b) {
              return a.restrictedValue.localeCompare(
                b.restrictedValue);
            });
          if (sortType == 'num')
            uniqvalues.sort(function (a, b) {
              return a.restrictedValue - b.restrictedValue;
            });
          if (sortType == 'date')
            uniqvalues.sort(function (a, b) {
              return (
                new Date(b.restrictedValue.date) -
                  new Date(a.restrictedValue.date)
              );
            });
          if (order == 'DESC') uniqvalues.reverse();
          if (attrType == 'date') {
            for (let i = 0; i < uniqvalues.length; i++) {
              uniqvalues[i].restrictedValue = $filter('date')(
                new Date(uniqvalues[i].restrictedValue),
                'dd/MM/yyyy'
              );
            }
          }

          scope.pickChoices = uniqvalues;

          // Dans le cas ou la restriction ne donne qu'une valeur possible, on l'affecte plutot que d'ouvrir la table
          if (scope.pickChoices.length === 1) {
            scope.getOnSelectionFunction(currentRestriction.type, undefined)(scope.pickChoices[0].restrictedKey);
          } else if (scope.pickChoices.length === 0) {
            scope.getOnSelectionFunction(currentRestriction.type, undefined)(undefined);
          } else if (openPopup) {
            var restrictedDialog = ngDialog.open({
              template:
                'js/XG/modules/model/views/modals/modal.pickfromtable.html',
              className: 'width800 ngdialog-theme-plain miniclose',
              closeByDocument: false,
              scope: scope,
            });

            // Assure le positionnement de la popup du choix de valeurs au-dessus de la popup parente
            // KIS-3213: la liste doit être affichée au dessus du formulaire pour pouvoir sélectionner les valeur
            displayOnForeground(restrictedDialog, null, 3);
          }
          gaDomUtils.hideGlobalLoader();


          scope.pickRestrictedValue = scope.getOnSelectionFunction(currentRestriction.type, restrictedDialog);

          scope.removeRestrictedValue = (index) => {
            scope.multiRes[scope.attributeToSet].splice(index, 1);

            scope.res[scope.attributeToSet] = scope.multiRes[scope.attributeToSet].join(
              '|');
          };
        }

        /**
         * get the right function for this restiction type
         *  the returned function will be called when an element is selected
         * @param {string} restrictionType
         * @param {descriptor} restrictedDialog the dialog handler
         * @returns the function onSelection
         */
        scope.getOnSelectionFunction = (restrictionType, restrictedDialog) => {
          switch(restrictionType) {
            case attributeRestrictionsUtils.USER:
              return (userPickedLogin) => {
                if (scope.res == undefined) {
                  scope.res = {};
                }
                if (currentRestriction.isLoginKey) {
                  scope.res[scope.attributeToSet] = userPickedLogin;
                } else {
                  const userFullName = attributeRestrictionsUtils.getValueFromKey(scope.pickChoices, userPickedLogin);
                  scope.res[scope.attributeToSet] = userFullName;
                }

                if (angular.isDefined(restrictedDialog)) {
                  restrictedDialog.close();
                }
              };
            case attributeRestrictionsUtils.TABLE:
              return (key) => {
                if (scope.res == undefined) {
                  scope.res = {};
                }
                if (currentRestriction.allowMultipleSelection) {
                  if (scope.multiRes[scope.attributeToSet].indexOf(key)
                      === -1) {
                    scope.multiRes[scope.attributeToSet].push(key);
                  }
                  // KIS-2993:
                  // si le champ à mettre à jour possède une restriction
                  // alors l’input de saisie est remplacé par un composant attributeRestriction
                  // et res prend le type de expression.fiter => string
                  if (typeof scope.res === 'string') {
                    scope.res = scope.multiRes[scope.attributeToSet].join('|');
                  } else {
                    scope.res[scope.attributeToSet] = scope.multiRes[scope.attributeToSet].join('|');
                  }
                } else {
                  // KIS-2993:
                  // si le champ à mettre à jour possède une restriction
                  // alors l’input de saisie est remplacé par un composant attributeRestriction
                  // et res prend le type de expression.fiter => string
                  if (typeof scope.res === 'string') {
                    scope.res = key;
                  } else {
                    scope.res[scope.attributeToSet] = key;
                    if (scope.onChange) {
                      scope.onChange(scope.attributeToSet, key);
                    }
                  }
                  if (angular.isDefined(restrictedDialog)) {
                    restrictedDialog.close();
                  }
                }
                // KIS-3287: annonce au formRender un changement de valeur pour passer le form en dirty
                scope.$emit('attributeRestrictionChange');

                if (scope.attribute.updateField) {
                  scope.$emit('callUpdateRelatedField', scope.attribute.updateField, scope.res[scope.attributeToSet]);
                }
              };
            default:
              return () => { console.error('not implemented'); };
          }
        };

        scope.$on('updateRelatedField', (event, fieldToUpdate) => {
          if(scope.attribute.name === fieldToUpdate) {
            scope.selectRestrictedValue(true);
          }
        });

        scope.filterRestrictedValues = () => {
          const filterRestrictedValue =
            document.getElementById('filterRestrictedValue');
          let filterValue = filterRestrictedValue.value.toUpperCase();
          const filterRestrictedKey =
            document.getElementById('filterRestrictedKey');
          let filterKey;
          if (filterRestrictedKey && filterRestrictedKey.value) {
            filterKey = filterRestrictedKey.value.toUpperCase();
          } else {
            filterKey = '';
          }
          scope.pickChoices.forEach((choice) => {
            if (
              ('' + choice.restrictedValue).toUpperCase().indexOf(filterValue) > -1 &&
              ('' + choice.restrictedKey).toUpperCase().indexOf(filterKey) > -1
            ) {
              choice.selected = true;
            } else {
              choice.selected = false;
            }
          });
        };

        //update keys using currently selected values.
        scope.updateMultiSelectionKey = function () {
          if (Array.isArray(scope.multiRes[scope.attributeToSet]) && (scope.multiRes[scope.attributeToSet].length > 0)) {
            let keys = '';
            for (let indexOfValue in scope.multiRes[scope.attributeToSet]) {
              const theKeytoAdd = scope.multiRes[scope.attributeToSet][indexOfValue];
              if (theKeytoAdd) {
                keys = keys.concat(theKeytoAdd);
                if (indexOfValue < scope.multiRes[scope.attributeToSet].length - 1) {
                  //if it's not the last we add the separator
                  keys = keys.concat('|');
                }
              }
            }
            if (scope.onChange) {
              scope.onChange(scope.attributeToSet, keys);
            }
          } else {
            if (scope.onChange) {
              scope.onChange(scope.attributeToSet, '');
            }
          }
        };

        scope.getValueFromKeyDomaineRestriction = (key) => {
          const result = scope.listofValues.find(it => it.val==key);
          return result ? result.translated : '';
        }

        /**
         * broadcast the fact that the value was changed
         * works only for domain restriction and it's ugly
         */
        scope.resValueChanged = function() {
          scope.deleteNullDefaultValues();
          scope.$emit('attributeRestrictionChange', {
            attribute: scope.attribute,
            fti: scope.fti,
          });
        };

        /**
         * Quand on efface une valeur par défaut dans un mapping de champ
         * la valeur par défaut devient null au lieu de se supprimer de l'objet scope.currentConfig.configByLayer[0].defaultValues
         */
        scope.deleteNullDefaultValues = () => {
          if (scope.res[scope.attributeToSet] === null) {
            delete scope.res[scope.attributeToSet];
          }
        };

        /**
         * Assure le positionnement de la popup du choix de valeurs au-dessus de la popup parente
         * @param {object} restrictedDialog objet retourné par la commande ngDialog.open à l'ouverture de la popup des valeurs
         * @param {HTMLDivElement} parentPopup élément HTML de la popup parente contenant le champ restreint
         * @param {number} lastingTries nombre d'exécutions possible de la méthode en attendant que la popup du choix des valeurs apparaisse.<br>
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3213">KIS-3213 | [MAP FORM] A la première ouverture la popup d'une table de restriction passe sous le formulaire</a>
         */
        const displayOnForeground = (restrictedDialog, parentPopup, lastingTries) => {
          $timeout(() => {
            if (!parentPopup) {
              // recherche l'élément html de la popup dans laquelle est située le champ avec restriction
              parentPopup = element[0].closest('.popupContainer');
            }
            if (parentPopup) {
              // évalue le z-index de la popup parente
              const parentZindex = Number.parseInt(parentPopup.style.zIndex);

              // vérifie la présence de la popup de la table de restriction
              const restrictedPopup = document.getElementById(restrictedDialog.id);
              if (restrictedPopup) {

                // applique à la popup de la table de restriction un zIndex supérieur à celui de la popup parente
                const restrictedZindex = parentZindex > 0 ? parentZindex + 1 : 10000;
                restrictedPopup.style.zIndex = String(restrictedZindex);
              } else if (lastingTries >= 0)  {

                // si la popup de la table de restriction n'est pas affichée alors on attend la prochaine frame
                displayOnForeground(restrictedDialog, parentPopup, --lastingTries);
              }
            }
          });
        };

        /**
         * Centre horizontalement le titre de la colonne "Action" lorsque le tableau des valeurs possède une barre de défilement verticale
         * @return {boolean} true si le body possède une barre de défilement vertical
         */
        scope.bodyHasVerticalScrollBar = () => {
          const popupBody = document.getElementById('pickfromtable-body');
          if (popupBody) {
            return gaJsUtils.hasVerticalScrollbar(popupBody);
          }
          return false;
        }

        // gère l'attribut "required" du select en JS
        // quand cet attribut est placé sur des champs masqués alors l'erreur suivante est levée:
        //  "invalid form control with name='' is not focusable."
        if (scope.fieldData && !scope.fieldData.inputcfg && scope.domainRestrictionAllowDifferentValues === false) {
          const listOfValuesElement = document.getElementById('listofValues');
          if (listOfValuesElement) {
            listOfValuesElement.setAttribute('required','');
          }
        }
        if (scope.fieldData && scope.fieldData.inputcfg === 'default' && scope.domainRestrictionAllowDifferentValues === false) {
          const listOfValuesElement = document.getElementById('listofValues-default');
          if (listOfValuesElement) {
            listOfValuesElement.setAttribute('required','');
          }
        }
      },
    };
  };

  attributeRestrictions.$inject = ['QueryFactory', 'FeatureTypeFactory',
    'UsersFactory', 'ngDialog', '$timeout', '$filter', '$translate',
    '$rootScope', 'gaJsUtils', 'gaDomUtils', 'attributeRestrictionsUtils', '$q'
  ];
  return attributeRestrictions;
});
