'use strict';
define(function() {
  var gcelement = function(
    RecursionHelper,
    $filter,
    $rootScope,
    AncAppFactory,
    $http,
    FeatureTypeFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/elastic/views/elasticJointure.html',
      restrict: 'A',

      scope: {
        el: '=',
      },
      compile: function(element) {
        return RecursionHelper.compile(element, function(scope) {
          scope.param = Math.floor(Math.random() * 10000000000000);

          scope.selectallattributes = function(e) {
            e.fti.attributes.map(function(x) {
              x.selected = true;
            });
          };

          var ar = scope.el.fti.attributes
            .map(function(res) {
              if (res.selected) return res;
            })
            .filter(function(res) {
              if (res) return res;
            });
          if (ar.length === 0) scope.selectallattributes(scope.el);

          scope.removeallattributes = function(e) {
            e.fti.attributes.map(function(x) {
              x.selected = false;
            });
          };

          scope.defaultUpdate = function(filter) {
            if (filter.nmjointure && angular.isUndefined(filter.jointurenmtype))
              filter.jointurenmtype = 'getOnlyFirstline';
          };

          scope.defaultUpdateANC = function(filter) {
            if (
              filter.ancjointure &&
              angular.isUndefined(filter.jointurenmtype)
            )
              filter.jointurenmtype = 'getOnlyFirstline';
          };
        });
      },
    };
  };

  gcelement.$inject = [
    'RecursionHelper',
    '$filter',
    '$rootScope',
    'AncAppFactory',
    '$http',
    'FeatureTypeFactory',
  ];
  return gcelement;
});
