'use strict';
define(function() {
  var elasticFilterAttributeCfg = function() {
    return {
      scope: {
        feat: '=',
        // fakeJsonFti : "="
      },
      templateUrl:
        'js/XG/widgets/utilities/elastic/views/elastic_filter_attribute_cfg.html',
      restrict: 'EA',
      link: function(scope, element, attrs, ctrl) {
        // si sur le composant controle on doit proposer de choisir parmi les attributs du json disponibles
        // var estControleAncBac = ["kis_anc_dossier_controle","kis_bac_dossier_controle"].indexOf(scope.feat.fti.name)!==-1;
        // if(estControleAncBac){
        //     // remplace le feature par le fake json fti
        //     scope.feat.fti = scope.fakeJsonFti;
        //     scope.$watch('feat', function(feat){
        //         console.log(feat);

        //     })
        // }

        scope.isAncBacCtrl =
          scope.feat.fti.name == 'kis_anc_dossier_controle' ||
          scope.feat.fti.name == 'kis_bac_dossier_controle' ||
          scope.feat.fti.name == 'kis_anc_dossier_controle_reponse' ||
          scope.feat.fti.name == 'kis_bac_dossier_controle_reponse';

        if (scope.isAncBacCtrl) {
          scope.$watch('feat', function() {
            setAncCtrlReponseCategories(scope.feat.fti.attributes);
          });
        }

        // cfg
        scope.cfg = {
          reset: false,
        };

        // copied from elasticjointures
        scope.innerDefaultUpdateANC = function(filter) {
          if (filter.ancjointure && angular.isUndefined(filter.jointurenmtype))
            filter.jointurenmtype = 'getOnlyFirstline';
        };

        /** resetAll checkboxes */
        scope.resetAll = function() {
          scope.feat.fti.attributes.map(function(y) {
            y.selected = scope.cfg.reset;
          });
        };

        scope.ancCtrlReponseCategories = {};
        /**
         * setAncCtrlReponseCategories
         * creation d'un tableau categorise des attributs pour kis_anc_controle_reponse
         */
        function setAncCtrlReponseCategories(attr) {
          var tmp = {},
            idx = 0,
            savedCategories = [];
          for (var i in attr) {
            if (savedCategories.indexOf(attr[i].category) == -1) {
              idx += 1;
              tmp[idx + '. ' + attr[i].category] = [];
              savedCategories.push(attr[i].category);
            }

            // FINIR ICI
            if (angular.isDefined(tmp[idx + '. ' + attr[i].category])) {
              tmp[idx + '. ' + attr[i].category].push(attr[i]);
            }
          }
          scope.ancCtrlReponseCategories = tmp;
        }
      },
    };
  };

  elasticFilterAttributeCfg.$inject = [];
  return elasticFilterAttributeCfg;
});
