'use strict';
define(function() {
  /**
   * List of the edit utilities directives
   */
  var editDirectivesProvider = function() {
    this.$get = function($filter) {
      var gceditline = {
        name: 'line',
        label: 'tools.builder.fields.edit.line.title',
      };
      var gceditpoint = {
        name: 'point',
        label: 'tools.builder.fields.edit.point.title',
      };
      var gceditpolygon = {
        name: 'polygon',
        label: 'tools.builder.fields.edit.polygon.title',
      };
      var gceditmultiple = {
        name: 'multiple',
        label: 'Saisie multiple',
      };
      var gclocaliseandupdate = {
        name: 'update',
        label: 'tools.builder.fields.edit.update.title',
      };
      var gclocalisation = {
        name: 'localisation',
        label: 'tools.builder.fields.edit.localise.title',
      };
      var gceditsave = {
        name: 'add',
        label: 'tools.builder.fields.edit.save.title',
      };

      return {
        /**
         * Retrieve list of available directives
         * @returns {*[]}
         */
        getDirectives: function() {
          return [
            gceditline,
            gceditpoint,
            gceditpolygon,
            gceditmultiple,
            gclocaliseandupdate,
            gclocalisation,
            gceditsave,
          ];
        },
      };
    };
    this.$get.$inject = ['$filter'];
  };
  return editDirectivesProvider;
});
