'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    EditFactory,
    gcWFS,
    gcStyleFactory,
    $http,
    gcPopup,
    FeatureTypeFactory,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/edit/views/gcremoveFeatures.html',
      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=fti',
        ftid: '=ftid',
        toolbarwidget: '=?toolbarwidget',
        onfinish: '=onfinish',
      },
      link: function(scope, element, attrs, ctrl) {
        if (angular.isUndefined(scope.fti)) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }
        scope.selectfeatures = function() {
          console.log('modeselection');
          var map = scope.map;
          scope.isActive = true;
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.isActive
              ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });
          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'editionoutil');
          map.addInteraction(scope.dragBox);

          scope.dragBox.on('boxend', function(evt) {
            // URL de rcup des objets

            var filter = scope.fti.name;

            var catchments_url =
              '/services/' +
              PortalsFactory.getPortalId() +
              '/geoserver/ows?service=WFS&version=1.0.0' +
              '&request=GetFeature&typeName=' +
              filter +
              '&outputformat=json&srsName=' +
              map
                .getView()
                .getProjection()
                .getCode() +
              '&bbox=' +
              scope.dragBox.getGeometry().getExtent() +
              ',' +
              map
                .getView()
                .getProjection()
                .getCode();

            var promise = $http.get(catchments_url);
            promise.then(function(res) {
              scope.result = res.data;
              var p = gcPopup.open({
                scope: scope,
                title: 'Suppression des objets',

                template: 'js/XG/widgets/utilities/edit/views/pop_remove.html',
                showClose: true,
              });
            });

            map.removeInteraction(scope.dragBox);
          });
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'EditFactory',
    'gcWFS',
    'gcStyleFactory',
    '$http',
    'gcPopup',
    'FeatureTypeFactory',
    'PortalsFactory',
  ];
  return gcelement;
});
