'use strict';
define(function() {
  var gcelement = function(
    gcStyleFactory,
    $http,
    gcPopup,
    FeatureTypeFactory,
    gcInteractions,
    bizeditProvider
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/edit/views/gcmodifyattributefeature.html',
      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=fti',
        ftid: '=ftid',
        onclick: '&onclick',
        onfinish: '=onfinish',
        editedfeatures: '=editedfeatures',
        uploadfile: '=?',
        toolbarwidget: '=?toolbarwidget',
        isActive: '=?isactive',
        updatesToSave: '&updatestosave',
      },
      link: function(scope) {
        if (angular.isUndefined(scope.fti)) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }

        scope.selectfeatures = function() {
          scope.onclick();
          console.log('modeselection');
          var map = scope.map;
          scope.isActive = true;
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.isActive
              ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });
          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'editionoutil');

          scope.dragBox.setActive(scope.isActive);
          gcInteractions.setCurrentToolBar(scope.toolbarwidget);

          map.addInteraction(scope.dragBox);

          scope.dragBox.on('boxend', function(evt) {
            // URL de rcup des objets

            scope.multipleEditValues = {};
            var filter = scope.fti.name;
            var catchments_url =
              '/services/' +
              localStorage.portal +
              '/geoserver/ows' +
              '?service=WFS&version=1.0.0' +
              '&request=GetFeature&typeName=' +
              filter +
              '&outputformat=json&srsName=' +
              map
                .getView()
                .getProjection()
                .getCode() +
              '&bbox=' +
              scope.dragBox.getGeometry().getExtent() +
              ',' +
              map
                .getView()
                .getProjection()
                .getCode();
            console.log(catchments_url);
            var promise = $http.get(catchments_url);
            promise.then(function(res) {
              scope.result = res.data.features;

              for (var i = 0; i < scope.result.length; i++) {
                var f = scope.result[i];
                f.currentProperties = f.properties;
              }

              scope.p = gcPopup.open({
                scope: scope,
                title: 'Edition attributaire',
                template:
                  'js/XG/widgets/utilities/edit/views/pop_attribute.html',
                showClose: false,
              });
            });
            scope.isActive = false;
            if (
              scope.dragBox &&
              scope.dragBox instanceof ol.interaction.DragBox
            )
              scope.dragBox.setActive(scope.isActive);
            map.removeInteraction(scope.dragBox);
          });
        };

        scope.resetMultipleEditComponent = function() {
          scope.multipleEditValues = {};
        };

        scope.updateAllSelectedFeatures = function() {
          if (
            !bizeditProvider.checkMandatory(
              scope,
              scope.fti.attributes,
              1,
              undefined,
              scope.multipleEditValues
            )
          ) {
            return;
          }
          angular.forEach(scope.multipleEditValues, function(value, key) {
            //Affectation des valeurs attributaires à chaque feature à partir des attributs temporaires.
            for (var i = 0; i < scope.result.length; i++) {
              var f = scope.result[i];
              f.currentProperties[key] = value;
            }
          });
        };

        scope.validFeatures = function() {
          angular.forEach(scope.result, function() {
            for (var i = 0; i < scope.result.length; i++) {
              var f = scope.result[i];
              if (!angular.isUndefined(f.currentProperties)) {
                f.properties = f.currentProperties;
                delete f.properties['fid'];
                delete f.currentProperties;
              }
            }
          });

          scope.editedfeatures.result = scope.result;
          scope.p.destroy();
          scope.updatesToSave({ newValue: true });
        };

        scope.closeThisDialog = function() {
          //Fermeture de la popup
          scope.p.destroy();
        };
      },
    };
  };

  gcelement.$inject = [
    'gcStyleFactory',
    '$http',
    'gcPopup',
    'FeatureTypeFactory',
    'gcInteractions',
    'bizeditProvider',
  ];
  return gcelement;
});
