'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    EditFactory,
    gcWFS,
    gcStyleFactory,
    $http,
    gcPopup,
    FeatureTypeFactory,
    gcInteractions,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/edit/views/gcmodifyfeatures.html',
      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=fti',
        ftid: '=ftid',
        editedfeatures: '=editedfeatures',
        onclick: '&onclick',
        onfinish: '&onfinish',
        modifyInteraction: '=?modifyInteraction',
        dragBox: '=?dragBox',
        isActive: '=?isactive',
        toolbarwidget: '=?toolbarwidget',
      },
      link: function(scope, element, attrs, ctrl) {
        if (angular.isUndefined(scope.fti)) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }
        scope.dirty = {};
        scope.modifyInteraction = {};

        scope.result = [];
        scope.finish = function(fture) {
          scope.onfinish(fture);

          // clean array
          // doing scope.result = [] breaks the binding so we use splice instead
          scope.result.splice(0);

          try {
            scope.$apply(function() {
              for (var i in fture) {
                if (fture[i].properties === null) {
                  fture[i].properties = {};
                }
  
                angular.forEach(fture[i].properties, function(value, key) {
                  if (value === '' || value === null) {
                    delete fture[i].properties[key];
                  }
                  delete fture[i].properties['fid'];
                  delete fture[i].properties['gid'];
                });
                scope.result.push(fture[i]);
                scope.ocoll = new ol.Collection();
              }
              scope.editedfeatures.result = scope.result;
            });
          } catch(err) {}
        };

        scope.selectfeatures = function() {
          var map = scope.map;
          scope.dirty = [];

          map.removeInteraction(scope.drawinteraction);
          var btnElt = $(element.children()[0]);
          //scope.onclick();
          if (
            scope.isActive &&
            scope.drawinteraction &&
            scope.drawinteraction.getActive()
          ) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
            if (
              scope.modifyInteraction &&
              scope.modifyInteraction instanceof ol.interaction.Modify
            )
              scope.modifyInteraction.setActive(false);
            if (
              scope.dragBox &&
              scope.dragBox instanceof ol.interaction.DragBox
            )
              scope.dragBox.setActive(scope.isActive);
            map.removeInteraction(scope.modifyInteraction);
            map.removeInteraction(scope.dragBox);
            scope.removefeatures();
          } else {
            scope.isActive = true;
            if (
              scope.dragBox &&
              scope.dragBox instanceof ol.interaction.DragBox
            )
              scope.dragBox.setActive(scope.isActive);
          }

          if (scope.isActive) {
            console.log('modeselection');
            var map = scope.map;

            scope.isActive = true;
            scope.dragBox = new ol.interaction.DragBox({
              condition: function(evt) {
                //MacEnvironments don't get here because the event is not
                //recognized as mouseEvent on Mac by the google closure.
                //We have to use the apple key on those devices
                return (
                  evt.originalEvent.altKey || scope.isActive
                ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
              },
              style: gcStyleFactory.getStyle('selectrectangle'),
            });

            scope.dragBox.set('gctype', 'kis');
            scope.dragBox.set('interaction', 'Select');
            scope.dragBox.set('widget', 'editionoutil');
            scope.dragBox.setActive(scope.isActive);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);

            map.addInteraction(scope.dragBox);

            scope.dragBox.on('boxend', function(evt) {
              // URL de rcup des objets

              var res = '';

              res = scope.fti.uid;

              // var filter = gclayers.getSelectFilterasStringuid(map);
              var geometryExtent = scope.dragBox.getGeometry().getExtent();

              var leftX = geometryExtent[0];
              var bottomY = geometryExtent[1];

              var rightX = geometryExtent[2];
              var topY = geometryExtent[3];

              var catchments_url =
                '/services/' +
                PortalsFactory.getPortalId() +
                '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
                res +
                '&outputformat=json&srsName=' +
                map
                  .getView()
                  .getProjection()
                  .getCode() +
                '&cql_filter=INTERSECTS(geom, POLYGON((' +
                leftX +
                ' ' +
                bottomY +
                ',' +
                rightX +
                ' ' +
                bottomY +
                ',' +
                rightX +
                ' ' +
                topY +
                ',' +
                leftX +
                ' ' +
                topY +
                ',' +
                leftX +
                ' ' +
                bottomY +
                ')))';

              var promise = $http.get(catchments_url);
              promise.then(function(res) {
                //scope.result=res.data;

                var geojson = new ol.format.GeoJSON();

                gclayers
                  .getDrawLayer()
                  .getSource()
                  .addFeatures(geojson.readFeatures(res.data));
                //var feats gclayers.getDrawLayer().getSource().getFeatures();
                scope.ocoll = new ol.Collection();

                scope.ocoll.on('add', function(evt) {
                  var feature = evt.element;
                  var fid = feature.getId();

                  feature.on('change', function(evt) {
                    scope.dirty[evt.target.getId()] = true;
                    var feats = [];
                    var format = new ol.format.GeoJSON();
                    for (var id in scope.dirty) {
                      feats.push(
                        format.writeFeatureObject(
                          gclayers
                            .getDrawLayer()
                            .getSource()
                            .getFeatureById(id)
                        )
                      );
                    }
                    scope.finish(feats);
                  });
                });
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .forEachFeature(function(feature) {
                    if (feature.properties == null) {
                      console.log(feature.properties);
                      feature.properties = [];
                    }
                    scope.ocoll.push(feature);
                  });
                scope.modifyInteraction = new ol.interaction.Modify({
                  features: scope.ocoll,
                  // the SHIFT key must be pressed to delete vertices, so
                  // that new vertices can be drawn at the same position
                  // of existing vertices
                  deleteCondition: function(event) {
                    return (
                      ol.events.condition.shiftKeyOnly(event) &&
                      ol.events.condition.singleClick(event)
                    );
                  },
                });
                //scope.isActive = false;
                scope.modifyInteraction.set('gctype', 'kis');
                scope.modifyInteraction.set('interaction', 'Modify');
                scope.modifyInteraction.set('widget', 'editionoutil');
                scope.modifyInteraction.setActive(true);
                gcInteractions.setCurrentToolBar(scope.toolbarwidget);
                map.addInteraction(scope.modifyInteraction);
              });
              scope.isActive = false;
              if (
                scope.dragBox &&
                scope.dragBox instanceof ol.interaction.DragBox
              )
                scope.dragBox.setActive(scope.isActive);
              map.removeInteraction(scope.dragBox);
            });
          }
          try {
            scope.$apply();
          } catch (e) {}
          scope.onclick();
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'EditFactory',
    'gcWFS',
    'gcStyleFactory',
    '$http',
    'gcPopup',
    'FeatureTypeFactory',
    'gcInteractions',
    'PortalsFactory',
  ];
  return gcelement;
});
