'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    EditFactory,
    FeatureTypeFactory,
    FeatureAttachmentFactory,
    $filter,
    SelectManager,
    $q,
    gcWFS
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/edit/views/gclocaliseandupdate.html',
      restrict: 'A',
      scope: {
        map: '=map',
        ftid: '=ftid',
        snaptolerance: '=snaptolerance',
        feature: '=feats',
        res: '=res',
        onfinish: '&?onfinish',
      },
      link: function(scope, element, attrs, ctrl) {
        console.log(scope.fti);
        scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        scope.dirty = [];
        if (angular.isUndefined(scope.curfti)) {
          scope.curfti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        } else {
          scope.curfti = scope.fti;
        }

        scope.coll = new ol.Collection();
        var format = new ol.format.GeoJSON();

        scope.modifyInteraction = new ol.interaction.Modify({
          features: scope.coll,
          // the SHIFT key must be pressed to delete vertices, so
          // that new vertices can be drawn at the same position
          // of existing vertices
          deleteCondition: function(event) {
            return (
              ol.events.condition.shiftKeyOnly(event) &&
              ol.events.condition.singleClick(event)
            );
          },
        });
        scope.modifyInteraction.setActive(false);
        // Functions snap interaction

        function getSnapRule() {
          var rules = scope.fti.rules;
          var ruleSnap = undefined;
          for (var i = 0; i < rules.length; i++) {
            if (rules[i].name == 'SnapOn') {
              ruleSnap = rules[i];
            }
          }
          return ruleSnap;
        }
        function snapOn(ruleConf) {
          //var ruleConf = getSnapRule();
          var layersToLoad = [];
          var layers = gclayers.getOperationalLayer();
          var layerNames = ruleConf.parameters['layers'];
          //Pour chaque nom de layer en config de cette règle
          for (var j = 0; j < layerNames.length; j++) {
            var name = layerNames[j].name;
            //Pour chaque layer opérationelle
            for (var i = 0; i < layers.length; i++) {
              var l = layers[i];
              if (l.name == undefined) continue;
              if (name == l.name) {
                var fti = l.fti;
                layersToLoad.push(fti);
                break;
              }
            }
          }
          //Chargement des objets des couches sur lesquelles s'accrocher
          var wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,scope.map);
          //map.addLayer(wfsLayer);
          gclayers.addSnapLayer(wfsLayer);
          var srcDrawedDXF = gclayers.getImportLayer().getSource();
          wfsLayer.getSource().addFeatures(srcDrawedDXF.getFeatures());
          if (scope.snaptolerance == undefined) {
            scope.snaptolerance = 20;
          }
          scope.snap = new ol.interaction.Snap({
            source: wfsLayer.getSource(),
            edge: true,
            vertex: true,
            pixelTolerance: scope.snaptolerance,
          });
        }

        function removeWfsLayers() {
          var layersToRemove = [];
          var layers = scope.map.getLayers().getArray();
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.type == 'wfs') {
              layersToRemove.push(l);
            }
          }
          for (var j = 0; j < layersToRemove.length; j++) {
            scope.map.removeLayer(layersToRemove[j]);
          }
        }

        scope.isActive = false;

        /**
         * [localiseandupdate description]
         * @return {[type]} [description]
         */
        scope.localiseandupdate = function() {
          if (scope.isActive) {
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            scope.modifyInteraction.setActive(false);
            scope.isActive = false;
            scope.map.removeInteraction(scope.modifyInteraction);
            var ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              scope.map.removeInteraction(scope.snap);
              scope.map.dispatchEvent({
                type: 'snapRemovedEvent',
              });
              removeWfsLayers();
            }
          } else {
            scope.isActive = true;
            var srid = scope.map
              ? scope.map
                  .getView()
                  .getProjection()
                  .getCode()
              : '';
            // 1- localisation
            if (scope.feature) {
              scope.feature['type'] = 'Feature';

              var f = format.readFeature(scope.feature);
              var extent = f.getGeometry().getExtent();
              scope.map.getView().fit(extent, scope.map.getSize());
              gclayers
                .getDrawLayer()
                .getSource()
                .addFeature(f);
              scope.coll.push(
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .getFeatures()[0]
              );
              scope.map.addInteraction(scope.modifyInteraction);
              scope.modifyInteraction.set('gctype', 'kis');
              scope.modifyInteraction.set('interaction', 'Modify');
              scope.modifyInteraction.set('widget', 'editionoutil');
              scope.modifyInteraction.setActive(true);
              var ruleConf = getSnapRule();
              if (ruleConf != undefined) {
                snapOn(ruleConf);
                scope.map.addInteraction(scope.snap);
                if (
                  scope.map
                    .getInteractions()
                    .getArray()
                    .indexOf(scope.snap) !== -1
                ) {
                  //Envoi de l'information de l'interaction ajoutée.
                  scope.map.dispatchEvent({
                    type: 'snapAddedEvent',
                  });
                }
              }
              scope.map.on('singleclick', scope.onModifyEnd);
            }
          }
        };

        scope.onModifyEnd = function() {
          scope.feature = format.writeFeatureObject(
            gclayers
              .getDrawLayer()
              .getSource()
              .getFeatures()[0]
          );
          scope.res = scope.feature.geometry;
          scope.onfinish();
          scope.modifyInteraction.setActive(false);
          scope.isActive = false;
          scope.map.removeInteraction(scope.modifyInteraction);
          var ruleConf = getSnapRule();
          if (ruleConf != undefined) {
            scope.map.removeInteraction(scope.snap);
            scope.map.dispatchEvent({ type: 'snapRemovedEvent' });
            removeWfsLayers();
          }
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'EditFactory',
    'FeatureTypeFactory',
    'FeatureAttachmentFactory',
    '$filter',
    'SelectManager',
    '$q',
    'gcWFS',
  ];
  return gcelement;
});
