'use strict';
define(function() {
  const ActionFeatureFactory = function(
    $q,
    extendedNgDialog,
    ConfigFactory,
    ngDialog,
    $filter,
    $timeout,
    FilesFactory,
    ngTableParams,
    DocumentFactory,
    itvSoumFactory2,
    SelectManager,
    gaDomUtils,
    ReportIndicatorFactory,
    GeometryFactory, ArcGisJob
  ) {
    const popoverActionsGlobalParameters
      = 'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html';

    /**
     * [executeHtml description]
     * @param  {[type]} action [description]
     * @param  {[type]} scope  [description]
     * @return {[type]}        [description]
     */
    function executeHtml(action, scope) {
      var deferred = $q.defer();
      scope.newobj = {};
      scope.newobj.current = scope.results;
      //scope.fti = scope.currentselectfti;
      if (scope.openHTMLDialog) scope.openHTMLDialog.close();
      scope.openHTMLDialog = extendedNgDialog.open({
        template: 'fichemetiers/' + action.url,
        className: 'ngdialog-theme-plain width800 nopadding miniclose',
        closeByDocument: false,
        scope: scope,
        title: scope.fti.name,
        draggable: true,
      });

      deferred.resolve('terminé !');
      return deferred.promise;
    }

    function executeForm(action, scope) {
      var deferred = $q.defer();
      var selectedCurrentFeature = scope.results;
      ConfigFactory.get(action.type, action.form).then(
        function(res) {
          scope.currentTemplate = res.data;
          const newScope = scope.$new();
          newScope.newobj = {};
          newScope.newobj.current = selectedCurrentFeature;
          if (scope.openFormulaireDialog) {
            scope.openFormulaireDialog.close();
          }
          scope.openFormulaireDialog = extendedNgDialog.open({
            template:
                  'js/XG/widgets/mapapp/selectFeatureTree/views/panel/formulaire.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: newScope,
            title: '',
            minimizeMaximize: true,
            scrollable: true,
            resizable: true,
            draggable: true,
            minWidth: '570px',
            minHeight: '400px',
            formOptions: scope.currentTemplate.options,
          });
          newScope.dlgPopup = scope.openFormulaireDialog;
        },
        function() {
          console.log('form does not exist');
        }
      );

      deferred.resolve('terminé !');
      return deferred.promise;
    }

    // CD93
    function executeDetailIntervention(action, scope) {
      var deferred = $q.defer();

      scope.actionData = angular.copy(action);
      scope.actionData.currentFeature = scope.results;

      if (scope.openIsDialog) scope.openIsDialog.close();

      scope.openIsDialog = extendedNgDialog.openOld({
        template:
            'js/XG/modules/model/views/directives/featuretypeactionsIsDetailRenderWrapper.html',
        className: 'ngdialog-theme-plain width800 nopadding miniclose',
        closeByDocument: false,
        scope: scope,
        title: action.name,
        draggable: true,
      });

      deferred.resolve('terminé !');
      return deferred.promise;
    }

    function executeUrl(action, properties, scope) {
      scope.parametersRapportUtilisateur = [];
      var param = [];
      for (var j = 0; j < action.parameters.length; j++) {
        if (
          action.parameters[j].saisieMode ===
            $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ) ||
            action.parameters[j].typeInfo === 'saisieUtilisateur'
        ) {
          //action.parameters[j].rapportName = action.name;
          //.parametersRapportUtilisateur.push(action.parameters[j]);
          param.push(action.parameters[j]);
        }
      }
      if (param.length > 0)
        scope.parametersRapportUtilisateur.push({
          name: action.name,
          parameters: param,
        });
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template: popoverActionsGlobalParameters,
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          function() {
            var url = parseUrl(action, properties);
            window.open(url);
          },
          function() {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        var url = parseUrl(action, properties);
        window.open(url);
      }
    }

    function parseUrl(action, properties) {
      var url = action.url;
      var params = action.parameters;
      if (params.length > 0) {
        url += '?';
        var value;
        for (var i = 0; i < params.length; i++) {
          switch (params[i].saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              properties[params[i].value] &&
              properties[params[i].value] !== null
                ? (value = properties[params[i].value])
                : (value = '');
              if (i > 0) url += '&';
              url += params[i].name + '=' + value;
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieStatic'
            ):
              if (i > 0) url += '&';
              url += params[i].name + '=' + params[i].attribute;
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ):
              if (i > 0) url += '&';
              url += params[i].name + '=' + params[i].value;
              break;
            default:
              switch (params[i].typeInfo) {
                case 'saisieAttribut':
                  properties[params[i].value] &&
                  properties[params[i].value] !== null
                    ? (value = properties[params[i].value])
                    : (value = '');
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + value;
                  break;
                case 'saisieStatic':
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].attribute;
                  break;
                case 'saisieUtilisateur':
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].value;
                  break;
              }
              break;
          }
        }
      }
      return url;
    }

    // Execution d'un esrigeoprocess: requete POST
    // Désolé pour la qualité du code, reprise d'existant... (executeUrl())
    const executeEsriGeoprocess = (action, properties, scope, geometry, srid) => {
      // On cherche une saisie manuelle
      const param = [];
      for(const parameter of action.parameters) {
        if (parameter.saisieMode ===
          $filter('translate')('model.featuretypes.actions.saisieUtilisateur')
            || parameter.typeInfo === 'saisieUtilisateur') {
          param.push(parameter);
        }
      }
      // Liste des paramètres à saisir manuellement
      scope.parametersRapportUtilisateur = [];
      if (param.length > 0) {
        scope.parametersRapportUtilisateur.push({
          name: action.name,
          parameters: param,
        });
      }

      // Si on a des paramètres à remplir manuellement
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: ($defer, params) => {
              let displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );
              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        ngDialog.openConfirm({
          template: popoverActionsGlobalParameters,
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        }).then(
          () => {
            executeEsriPostRequest(action, properties, geometry, srid,
              scope.objectres ? scope.objectres.objets_cible: undefined, scope);
          },
          () => {
            require('toastr').info($filter('translate')('selectfeaturetree.saisirtocontinue'));
          }
        );
      // Si aucun paramètre à remplir manuellement
      } else {
        executeEsriPostRequest(action, properties, geometry, srid,
          scope.objectres ? scope.objectres.objets_cible: undefined, scope);
      }
    };


    /**
     * Définit les données du paramétre défini par "property" du POST
     * pour l'appel du géotraitement ArcGIServer
     * avec la géométrie "path" et l'ID de référence spatiale spécifiés.
     *
     * @param {object} postData - Les données à modifier.
     * @param {string} property - La propriété à définir dans l'objet postData.
     * @param {array} path - Le chemin à inclure dans la géométrie.
     * @param {string|number} srid - L'ID de référence spatiale pour la géométrie.
     */
    const setPostData = (postData, property, path, srid) => {
      postData[property] = JSON.stringify({
        geometryType: 'esriGeometryPolyline',
        features: [{
          attributes: { FID: 0 },
          geometry: {
            paths: [path],
            spatialReference: { wkid: typeof srid === 'string' && srid.includes(':')
              ? srid.split(':')[1] : srid },
          },
        },
        ],
      });
    };


    // Creation des paramètres et execution du POST
    const executeEsriPostRequest = (action, properties, geometry, srid, objets_cible, scope) => {

      // Creation du postData avec les paramètres
      const paramsPromisses = [];
      const postData = {};
      for (let param of action.parameters) {
        const deferred = $q.defer();
        paramsPromisses.push(deferred.promise);
        switch (param.saisieMode) {
          case $filter('translate')('model.featuretypes.actions.saisieAttribut'):
            properties[param.value] && properties[param.value] !== null ?
              postData[param.name] = properties[param.value] :
              postData[param.name] = '';
            deferred.resolve();
            break;
          case $filter('translate')('model.featuretypes.actions.saisieStatic'):
            postData[param.name] = param.attribute;
            deferred.resolve();
            break;
          case $filter('translate')('model.featuretypes.actions.saisieUtilisateur'):
            postData[param.name] = param.value;
            deferred.resolve();
            break;
          case $filter('translate')('model.featuretypes.actions.linearAtlasGeometry'):
            if (angular.isDefined(geometry)) {

              // Dans le cas ou la géométrie n'est pas une ligne,
              // on veut peut-être faire le traitement sur les objets_cible
              if (geometry.type !== 'MultiLineString') {
                if (objets_cible) {
                  const linearFeatures
                    = objets_cible.features.filter(
                      objet => objet.geometry.type === 'MultiLineString');
                  const linearOlFeatures
                    = linearFeatures.map(feature => new ol.Feature(
                      {geometry: new ol.geom.MultiLineString(feature.geometry.coordinates)}));
                  const geometries = [];
                  const format = new ol.format.GeoJSON();
                  for (let linearTargetObject of linearOlFeatures) {
                    try {
                      geometries.push(JSON.parse(
                        format.writeGeometry(
                          linearTargetObject.getGeometry())));
                    } catch (error) {
                      console.error('Failed to parse geometry:', error);
                    }
                  }
                  GeometryFactory.union(geometries).then(res => {
                    setPostData(postData, param.name, res.data.coordinates, srid);
                    deferred.resolve();
                  });
                } else {
                  deferred.resolve();
                }
              } else {
                setPostData(postData, param.name, geometry.coordinates[0], srid);
                deferred.resolve();
              }
            } else {
              require('toastr').warning($filter('translate')(
                'model.featuretypes.actions.noGeometryForCurrentObject'));
              deferred.reject();
            }
            break;
          case $filter('translate')('model.featuretypes.actions.surfaceAtlasGeometry'):
            if (angular.isDefined(geometry)) {
              postData[param.name] = JSON.stringify({
                geometryType: 'esriGeometryPolygon',
                features: [{
                  attributes: { OBJECTID: 0 },
                  geometry: {
                    spatialReference: { wkid: typeof srid === 'string' && srid.includes(':')
                      ? srid.split(':')[1] : srid },
                    rings: geometry.coordinates[0]
                  }
                }
                ]
              });
            } else {
              require('toastr').warning(
                $filter('translate')('model.featuretypes.actions.noGeometryForCurrentObject'));
            }
            deferred.resolve();
            break;
        }
      }

      // Soumission du job ESRI
      $q.all(paramsPromisses).then(() => {
        $.post(action.url + '/submitJob/execute?f=json', postData).then((res) => {
          gaDomUtils.showGlobalLoader();
          scope.jobId = res.jobId;
          // Traitement de la réponse
          $timeout(() => {
            // -- Nom du géotraitement pour afficher dans la popup "détail"
            scope.arcgisJobName = action.name;
            // -- Pour ouvrir le fichier résultat du géotraitement
            const params = {
              actionForFile: 'window.open',
              actionName: action.name
            };
            ArcGisJob.runEsriJob(scope, action.url, res, params).finally(() => {
              gaDomUtils.hideGlobalLoader();
            });
          }, 500);
        });
      });
    };


    const executeJasper = (action, currentselect, which, scope) => {
      scope.parametersRapportUtilisateur = [];
      for (var i = 0; i < action.rapports.length; i++) {
        if (
          (action.rapports[i].type ===
                $filter('translate')('model.featuretypes.actions.JasperModel') ||
                action.rapports[i].typeInfo === 'JasperModel') &&
            action.rapports[i].parameters &&
            action.rapports[i].parameters.length > 0
        ) {
          var param = [];
          for (var j = 0; j < action.rapports[i].parameters.length; j++) {
            if (
              action.rapports[i].parameters[j].saisieMode ===
                $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ) ||
                action.rapports[i].parameters[j].typeInfo === 'saisieUtilisateur'
            ) {
              param.push(action.rapports[i].parameters[j]);
            }
          }
          if (param.length > 0)
            scope.parametersRapportUtilisateur.push({
              name: action.rapports[i].name,
              parameters: param,
            });
        }
      }
      if (scope.parametersRapportUtilisateur.length > 0) {
        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.parametersRapportUtilisateur.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.parametersRapportUtilisateur.length);
              $defer.resolve(displayedTab);
            },
          }
        );
        scope.ngdiaParameters = ngDialog.openConfirm({
          template: popoverActionsGlobalParameters,
          scope: scope,
          className: 'ngdialog-theme-plain width800 nopadding miniclose',
        });
        scope.ngdiaParameters.then(
          function() {
            switch (which) {
              case 'oncomponent':
                JasperOnComponent(action, currentselect, scope);
                break;
              case 'onobject':
                Jasper(action, currentselect, scope);
                break;
            }
          },
          function() {
            require('toastr').info(
              $filter('translate')('selectfeaturetree.saisirtocontinue')
            );
          }
        );
      } else {
        switch (which) {
          case 'oncomponent':
            JasperOnComponent(action, currentselect, scope);
            break;
          case 'onobject':
            Jasper(action, currentselect, scope);
            break;
        }
      }
    };


    /**
     * Génère un rapport DOCX basé sur les données fournies et
     * ajoute la promesse au tableau donné.
     *
     * @param {Array} promises - Liste des promesses
     * @param {Object} senddata - Donnée à communiquer fabriqué par "getPortalDoc"
     * @param {Object} rapport - Objet rapport
     * @param {Object} currentselect - Objet courant
     * @param {Object} currentselectfti - FTI de l'objet courant
     * @param {Array} FullDataGenerate - Liste des résultats
     * @return {void}
     */
    const generateDocx = (scope, promises, senddata, rapport, currentselect, FullDataGenerate) => {
      const projCode = scope ? scope.map.getView().getProjection().getCode() : undefined;
      const promisePortalModel = DocumentFactory.generatedocx(
        senddata, rapport.file, currentselect.id, false, projCode).then((res) => {
        FullDataGenerate.push({
          type: 'PortalModel',
          file: res.data.name,
        });
      },
      () => {
        require('toastr').error('error');
      }
      );
      promises.push(promisePortalModel);
    };


    /**
     * Génère un rapport Jasper basé sur les données fournies et
     * ajoute la promesse au tableau donné.
     *
     * @param {Object} rapport - Objet rapport
     * @param {Object} currentselect - Objet courant
     * @param {Object} currentselectfti - FTI de l'objet courant
     * @param {Array} promises - Liste des promesses
     * @param {Array} FullDataGenerate - Liste des résultats
     * @return {void}
     */
    const generateJasper = (rapport,currentselect, currentselectfti, promises,
      FullDataGenerate) => {
      const promiseJasperModel = generateJasperDocWhithoutDownload(rapport, currentselect,
        currentselectfti).then((res) => {
        if (res.data.pdfdone)
          FullDataGenerate.push({
            type: 'JasperModel',
            file: res.data.fileNameGenerated,
            appname: angular.module('gcMain').app,
          });
      });
      promises.push(promiseJasperModel);
    };


    const Jasper = (action, currentselect, scope) => {
      const sendata = getPortalDoc(currentselect, scope);
      if (action.rapports.length === 1) {
        let rapport = action.rapports[0];
        switch (rapport.type) {
          case $filter('translate')('model.featuretypes.actions.PortalModel'):
            DocumentFactory.generatedocx(
              sendata,
              rapport.file,
              currentselect.id
            ).then(function (res) {
              window.open(
                '/services/' +
                angular.module('gcMain').portalid +
                '/documents/downloaddocx?' +
                '&name=' +
                res.data.name
              );
              //gaDomUtils.hideGlobalLoader();
            });
            break;
          case $filter('translate')('model.featuretypes.actions.StaticModel'):
            window.open(
              '/services/{portalid}/files/getfilestatic?ftiname=' +
              scope.fti.name +
              '&filename=' +
              rapport.file
            );
            break;
          case $filter('translate')('model.featuretypes.actions.JasperModel'):
            generateJasperDoc(rapport, currentselect, scope);
            break;
          default:
            switch (rapport.typeInfo) {
              case 'PortalModel':
                DocumentFactory.generatedocx(
                  sendata,
                  rapport.file,
                  currentselect.id
                ).then((res) => {
                  window.open(
                    '/services/' +
                    angular.module('gcMain').portalid +
                    '/documents/downloaddocx?' +
                    '&name=' +
                    res.data.name
                  );
                });
                break;
              case 'StaticModel':
                window.open(
                  '/services/{portalid}/files/getfilestatic?ftiname=' +
                  scope.fti.name +
                  '&filename=' +
                  rapport.file
                );
                break;
              case 'JasperModel':
                generateJasperDoc(rapport, currentselect, scope);
                break;
            }
            break;
        }
      } else {
        const promisses = [];
        const FullDataGenerate = [];
        for (let i = 0; i < action.rapports.length; i++) {
          const rapport = action.rapports[i];
          switch (rapport.type) {
            case $filter('translate')('model.featuretypes.actions.PortalModel'):
              generateDocx(scope, promisses, sendata, rapport, currentselect, FullDataGenerate);
              break;
            case $filter('translate')('model.featuretypes.actions.StaticModel'):
              FullDataGenerate.push({
                type: 'StaticModel',
                file: rapport.file,
                ftiname: scope.fti.name,
              });
              break;

            case $filter('translate')('model.featuretypes.actions.JasperModel'):
              generateJasper(rapport, currentselect, scope.fti, promisses, FullDataGenerate);
              break;

            default:
              switch (rapport.typeInfo) {
                case 'PortalModel':
                  generateDocx(scope, promisses, sendata, rapport, currentselect, FullDataGenerate);
                  break;
                case 'StaticModel':
                  FullDataGenerate.push({
                    type: 'StaticModel',
                    file: rapport.file,
                    ftiname: scope.fti.name,
                  });
                  break;

                case 'JasperModel':
                  generateJasper(rapport, currentselect, scope.fti, promisses, FullDataGenerate);
                  break;
              }
              break;
          }
        }
        $q.all(promisses).then(() => {
          FilesFactory.getActionsGeneratedZip(FullDataGenerate).then(
            (res) => {
              window.open(
                '/services/' +
                angular.module('gcMain').portalid +
                '/files/getgeneratedzip?filename=' +
                res.data.filename
              );
            },
            () => {
              require('toastr').error('error');
            }
          );
        });
      }
    };


    const JasperOnComponent = (action, geoj, scope) => {
      const rapport = action.rapports[0];
      //generateJasperDoc(rapport , geoj);
      const features = geoj.features;
      const sendata = [];
      angular.forEach(features, function (feature) {
        sendata.push(generateSendata(rapport, feature, scope));
      });
      const execStoreName
        = scope.fti.type === 'esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
      if (!rapport.format || rapport.format.length === 0) {
        rapport.format = 'pdf';
      }
      ReportIndicatorFactory.generateMultipleReportExtended(
        rapport.file,
        execStoreName,
        sendata,
        true // true => le rapport est dans "/rapports_action"
      ).then(
        (res) => {
          if (res.data.etat === 'fini') {
            window.open(
              '/services/' +
              angular.module('gcMain').portalid +
              '/indicator/' +
              angular.module('gcMain').app +
              '/getgeneratedzip?filename=' +
              res.data.file
            );
          } else {
            require('toastr').error('error');
          }
        },
        () => {
          require('toastr').error('error');
        }
      );
    };


    const getPortalDoc = (currentselect, scope) => {
      if (!scope.result) {
        return {current: currentselect};
      }
      else {
        let selectedCurrentFeature;
        for (let i = 0; i < scope.result.features.length; i++) {
          if (scope.result.features[i].id === currentselect.id) {
            selectedCurrentFeature = scope.result.features[i];
            break;
          }
        }
        const idsNames = getNamesIds(scope);
        const res = {
          current: selectedCurrentFeature,
        };
        return createSendMessage(res, idsNames);
      }
    };

    /**
     * Affichage du message d'erreur pour le cas où le rapport n'a pas pu être généré.
     *
     * @param {type} rapport - Objet rapport contenant le nom du fichier rapport.
     */
    const toastrUnableToGenerateJasper = (rapport) => {
      require('toastr').error(
        $filter('translate')('model.featuretypes.actions.unabletogeneratepdf')
        + ' ' + rapport.file);
    };


    /**
     *
     * @param rapport
     * @param currentselect
     * @param scope
     * @returns {Promise}
     */
    const generateJasperDocWhithoutDownload = (rapport, currentselect, fti) => {
      let promise;
      if (!fti || !rapport || !currentselect) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.ftiorreportorselectabsent'
          ));
      }
      else {
        if (!rapport.format || rapport.format.length === 0) {
          rapport.format = 'pdf';
        }
        const sendata = generateSendata(rapport, currentselect, fti);
        const storeName = fti.type === 'esri'
          && rapport.storeName ? rapport.storeName : fti.storeName;
        ReportIndicatorFactory.checkActionReportExists(rapport.file).then(
          (result)=> {
            if (result && result.data) {
              if (!rapport.format || rapport.format.length === 0){
                rapport.format = 'pdf';
              }
              promise = ReportIndicatorFactory.generateReportExtended(
                rapport.file, storeName, sendata, rapport.format, true);
              promise.then(
                (res) => {
                  if (!res.data || !res.data.pdfdone)
                    toastrUnableToGenerateJasper(rapport);
                },
                () => {
                  toastrUnableToGenerateJasper(rapport);
                }
              );
            }
            else {
              swal({
                title: $filter('translate')('model.featuretypes.actions.deletedFile'),
                text: $filter('translate')(
                  'model.featuretypes.actions.deletedReport') + '\n' + rapport.file,
                type: 'error',
                showCancelButton: false,
                confirmButtonColor: '#CCC',
                confirmButtonText: $filter('translate')('common.ok'),
                closeOnConfirm: true,
              });
            }
          },
          ()=>{
            require('toastr').error(
              $filter('translate')('model.featuretypes.actions.unabletocheckFileExist')
              + ' ' + rapport.file);
          }
        );
        return promise;
      }
    };


    const generateJasperDoc = (rapport, currentselect, scope) => {
      const sendata = generateSendata(rapport, currentselect, scope);
      const execStoreName
        = scope.fti.type === 'esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
      if (!rapport.format || rapport.format.length === 0) {
        rapport.format = 'pdf';
      }
      ReportIndicatorFactory.generateReportExtended(
        rapport.file,
        execStoreName,
        sendata,
        rapport.format,
        true // true => le rapport est dans "/rapports_action"
      ).then(
        (res) => {
          if (res.data.pdfdone) {
            ReportIndicatorFactory.getPdf(res.data.fileNameGenerated, rapport.format).then(
              (data) => {
                const resultObject = data.data;
                let blob;
                switch (rapport.format) {
                  case 'pdf':
                    blob = new Blob([resultObject], {
                      type: 'application/pdf',
                    });
                    break;
                  case 'xls':
                    blob = new Blob([resultObject], {
                      type: 'application/vnd.ms-excel',
                    });
                    break;
                  case 'rtf':
                    blob = new Blob([resultObject], {
                      type: 'application/x-rtf',
                    });
                    break;
                }
                if (rapport.format === 'rtf') {
                  const a = document.createElement('a');
                  document.body.appendChild(a);
                  a.style = 'display: none';
                  blob = new Blob([resultObject], { type: 'application/rtf' });
                  const url = window.URL.createObjectURL(blob);
                  a.href = url;
                  a.download = res.data.fileNameGenerated + '.rtf';
                  a.click();
                  window.URL.revokeObjectURL(url);
                } else {
                  const objectUrl = URL.createObjectURL(blob);
                  window.open(objectUrl);
                }
              },
              () => {
                require('toastr').error(
                  $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                  + rapport.format);
              }
            );
          } else {
            let mess = '', cnt;
            if (res.data.etat && res.data.etat === 'erreur') {
              for (let ind = 0; ind < res.data.errorList.length; ind++) {
                cnt = res.data.errorList[ind].message_kis.split(';');
                mess +=
                  $filter('translate')('model.featuretypes.actions.' + cnt[0]);
                for (let ind = 1; ind < cnt.length; ind++) {
                  //-- Remplace '$1', '$2', ... par la valeur correspondante
                  //-- lue dans message_kis.
                  mess = mess.replace('$' + ind, cnt[ind]);
                }
              }
            }
            require('toastr').error(
              $filter('translate')(
                'model.featuretypes.actions.unabletogeneratepdf'
              ) +
              ' ' +
              rapport.file + '  -  ' + mess
            );
          }
        },
        () => {
          require('toastr').error(
            $filter('translate')(
              'model.featuretypes.actions.unabletogeneratepdf'
            ) +
            ' ' +
            rapport.file
          );
        }
      );
    };


    const setParamFromAttribute = (param,scope,currentselect,res) => {
      if (param.attribut === 'id' && scope.fti.type !== 'esri') {
        res[param.name] = Number(
          currentselect.id.replace(scope.fti.name + '.', '')
        );
      } else {
        res[param.name] = currentselect.properties[param.attribut];
      }
    };


    /**
     * Défini la valeur du paramétre de type variable à passer au rapport.
     * Si le paramétre n'existe poas dans scope.objectres.miscResult
     * un message en informe l'opérateur.
     *
     * @param {*} param
     * @param {*} objectres
     * @param {*} res
     */
    const setParamFromVariable = (param, objectres, res) => {
      if (!objectres.miscResult
        || !objectres.miscResult[param.value]) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.actions.missingVariable').replace('$1',param.value)
        );
        return false;
      }
      else {
        res[param.name] = objectres.miscResult[param.value];
        return true;
      }
    };


    const generateSendata = (rapport, currentselect, scope) => {
      const res = {};
      for (let iParam = 0; iParam < rapport.parameters.length; iParam++) {
        const param = rapport.parameters[iParam];
        switch (param.saisieMode) {
          case $filter('translate')(
            'model.featuretypes.actions.saisieAttribut'
          ):
            setParamFromAttribute(param, scope, currentselect, res);
            break;
          default:
            switch (param.typeInfo) {
              case 'saisieAttribut':
                setParamFromAttribute(param, scope, currentselect, res);
                break;
              case 'saisieVariable':
                if (!setParamFromVariable(param, scope.objectres, res)) {
                  return false;
                }
                break;
              default:
                res[param.name] = param.value;
                break;
            }
            break;
        }
      }
      return res;
    };


    const getNamesIds = (scope) => {
      const ids = [];
      const names = [];
      const relationN = [];
      const features = [];
      const relations = scope.fti.relations;
      const relationsComponentsEnd = [];
      const relationsNames = [];
      relations.map((x) => {
        if (x.componentEnd) {
          relationsComponentsEnd.push(x.componentEnd);
          relationsNames.push(x.name);
        }
      });
      for (let i = 0; i < scope.relatedfeature.features.length; i++) {
        const feature = scope.relatedfeature.features[i];
        const id = feature.id;
        const name = id.substring(0, id.lastIndexOf('.'));
        if (relationsComponentsEnd.indexOf(name) !== -1) {
          ids.push(id);
          names.push(name);
          features.push(feature);
          relationN.push(relationsNames[relationsComponentsEnd.indexOf(name)]);
        }
      }

      return [ids, names, relationN, features];
    };


    const createSendMessage = (res, idsNames) => {
      const relationN = idsNames[2];
      const features = idsNames[3];
      let uniqueRelationNames = angular.copy(relationN);
      uniqueRelationNames = $.unique(uniqueRelationNames);
      for (let i = 0; i < uniqueRelationNames.length; i++) {
        const arr = [];
        for (let j = 0; j < relationN.length; j++) {
          if (relationN[j] === uniqueRelationNames[i]) arr.push(features[j]);
        }
        res[uniqueRelationNames[i]] = arr;
      }

      return res;
    };

    /**
     * Action d'ouverture de widget
     * @param action configuration de l'action à effectuer
     * @param scope scope de l'appelant
     * @param featureCollection collection contenant la feature avec laquelle
     *        on va ouvrir le widget dans certains cas
     */
    const openWidget = (action, scope, featureCollection) => {
      // Récupération de la configuration
      scope.ConfigName = action.widgetConfigName;
      scope.featureToOpenWith = featureCollection;
      switch (action.widgetToOpen) {
        // Fenêtre de visualisation ITV
        case $filter('translate')('itv.view'):
          // Ouverture de l'écran de visualisation
          scope.mode = 'visualisation';
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/LITV/views/visualisation/visualisation.html',
            className:
                'ngdialog-theme-plain max-heigth550 nopadding miniclose itvvisua',
            closeByDocument: false,
            scope: scope,
            minimizeMaximize: true,
            title: $filter('translate')('itv.view'),
            draggable: true,
            preCloseCallback: function () {
              itvSoumFactory2.getitvoperationalLayers().forEach(function (featureLayer) {
                scope.map.getLayers().forEach(function (Layer) {
                  if (Layer.getProperties().name ==
                      featureLayer.getProperties().name
                  ) {
                    scope.map.removeLayer(Layer);
                  }
                });
              });
              SelectManager.clear();
              itvSoumFactory2.clearoriginsourcecanal();
              itvSoumFactory2.clearitvoperationalLayers();
              scope.map.removeInteraction(scope.$$childHead.pointer);
              scope.map.removeInteraction(scope.$$childHead.dragBox);
            },
          });
          break;
        // Fenêtre d'import ITV
        case $filter('translate')('itv.create'):
          extendedNgDialog.open({
            template:
                'js/XG/widgets/mapapp/LITV/views/soumission/soumission.html',
            className:
                'ngdialog-theme-plain nopadding miniclose width500 itvsoum displayAsTable',
            closeByDocument: false,
            resizable: true,
            scope: scope,
            minimizeMaximize: true,
            title: $filter('translate')('itv.create'),
            draggable: true,
            preCloseCallback: function () {
              d3.select('.svgitv').selectAll('*').remove();
              angular.element('#details').empty();
              angular.element('.detailtablesec .ng-table-pager').remove();
              const layers = itvSoumFactory2.getitvoperationalLayers();
              for (let iLyr = 0; iLyr < layers.length; iLyr++) {
                const featureLayerName = layers[iLyr].getProperties().name;
                scope.map.getLayers().forEach(function (Layer) {
                  if (Layer.getProperties().name == featureLayerName) {
                    try {
                      scope.map.removeLayer(Layer);
                    }
                    catch (e) {
                      console.log('Erreur capturée: '+e);
                    }
                  }
                });
              }
              itvSoumFactory2.clearoriginsourcecanal();
              itvSoumFactory2.clearitvoperationalLayers();
              $('#closePanel').click();
              scope.map.removeInteraction(scope.$$childHead.pointer);
            },
          });
          break;
        default:
          require('toastr').warning(
            $filter('translate')('model.featuretypes.actions.incorrectWidgetName'));
          break;

      }
    };

    return {
      executeHtml: executeHtml,
      executeForm: executeForm,
      executeDetailIntervention: executeDetailIntervention,
      executeUrl: executeUrl,
      executeEsriGeoprocess: executeEsriGeoprocess,
      parseUrl: parseUrl,
      executeJasper: executeJasper,
      Jasper: Jasper,
      JasperOnComponent: JasperOnComponent,
      getPortalDoc: getPortalDoc,
      generateJasperDoc: generateJasperDoc,
      generateSendata: generateSendata,
      getNamesIds: getNamesIds,
      createSendMessage: createSendMessage,
      openWidget: openWidget,
      generateDocx,
      generateJasper
    };
  };
  ActionFeatureFactory.$inject = [
    '$q',
    'extendedNgDialog',
    'ConfigFactory',
    'ngDialog',
    '$filter',
    '$timeout',
    'FilesFactory',
    'ngTableParams',
    'DocumentFactory',
    'itvSoumFactory2',
    'SelectManager',
    'gaDomUtils',
    'ReportIndicatorFactory',
    'GeometryFactory', 'ArcGisJob'
  ];
  return ActionFeatureFactory;
});
