'use strict';
define([
  'angular',
  'widgets/utilities/data/directives/gcdatatable',
  'widgets/utilities/data/directives/gcdatatablecfg',
  'widgets/utilities/data/directives/gcdatatable_geojson',
  'widgets/utilities/data/directives/gcdatasearch',
  'widgets/utilities/data/directives/featureattachment',
  'widgets/utilities/data/directives/actionfeature',
  'widgets/utilities/data/directives/gcexport',
  'widgets/utilities/data/directives/gcspatialcqlfilter',
  'widgets/utilities/data/services/dataDirectivesProvider',
  'widgets/utilities/data/services/datatableIsHelper',
  'widgets/utilities/data/services/ActionFeatureFactory',
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'toastr',
  'ol3js',
  'ng-table',
], function(
  angular,
  gcdatatable,
  gcdatatablecfg,
  gcdatatable_geojson,
  gcdatasearch,
  featureattachment,
  actionfeature,
  gcexport,
  gcspatialcqlfilter,
  dataDirectivesProvider,
  datatableIsHelper,
  ActionFeatureFactory
) {
  var datautilities = angular.module('datautilities', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
  ]);

  datautilities.directive('gcdataDatatable', gcdatatable);
  datautilities.directive('gcdataDatatableCfg', gcdatatablecfg);
  datautilities.directive('gcdataDatatablegj', gcdatatable_geojson);
  datautilities.directive('gcDataSearch', gcdatasearch);
  datautilities.directive('gcFeatureattachment', featureattachment);
  datautilities.directive('gcActionfeature', actionfeature);
  datautilities.directive('gcExport', gcexport);
  datautilities.directive('gcSpatialCqlFilter', gcspatialcqlfilter);
  datautilities.provider('dataDirectivesProvider', dataDirectivesProvider);
  datautilities.factory('datatableIsHelper', datatableIsHelper);
  datautilities.factory('ActionFeatureFactory', ActionFeatureFactory);

  return datautilities;
});
