'use strict';
define(function() {
  var gcspatialcqlfilter = function(gclayers, SelectManager, GeometryFactory, $filter) {
    return {
      templateUrl: 'js/XG/widgets/utilities/data/views/gcspatialcqlfilter.html',
      restrict: 'AE',
      scope: {
        cqlClause: '=',
        map: '=',
        isActive: '=?',
        toolBarWidget: '=?toolbarwidget',
        isApplyBufferDisabled: '=?',
        geomTag: '=?'
      },
      link: function(scope) {
        scope.geometricoperand = [
          'EQUALS',
          'DISJOINT',
          'INTERSECTS',
          'TOUCHES',
          'CROSSES',
          'WITHIN',
          'CONTAINS',
          'OVERLAPS',
          'RELATE',
          'DWITHIN',
          'BEYOND',
        ];

        scope.selections = {
          selectedGeomOperand: 'INTERSECTS',
        };

        scope.currentWktGeometry = '';

        if (!scope.geomTag) {
          scope.geomTag = 'geom';
        }

        scope.limitZoneGeometry = {};

        /**
         * Au clic sur le bouton pour démarrer le dessin d'un polygone de sélection (crayon)
         */
        scope.buildDrawPolygonClick = function() {
          if (scope.useCurrent) {
            scope.useCurrent = false;
            gclayers.getDrawLayer().getSource().clear();
            scope.limitZoneGeometry = null;
          }
          // nettoie la couche temporaire de dessin
          // dans le cas où l'utilisateur a déjà dessiné un premier polygone de sélection
          // vérifie l'absence d'une intéraction de dessin de polygone existante
          finishAndResetBuildPolygon(true);
          scope.isActive = true;
        };

        /**
         * Après dessin du polygone de sélection,
         * construit une clause where en concaténant l'opérateur spatial et les coordonnées du polygone de sélection
         */
        scope.buildDrawPolygonClause = () => {
          if (scope.limitZoneGeometry && Object.keys(scope.limitZoneGeometry).length > 0) {
            const coords = scope.limitZoneGeometry.coordinates;
            if (Array.isArray(coords)) {
              const polyCoords = new ol.geom.Polygon(coords, 'XY');
              // construit la clause à partir de l'opérateur spatial et des coordonnées du polygone dessiné
              scope.cqlClause = buildClauseWithOperator(polyCoords);
              try {
                scope.$apply(scope);
              } catch(err) {}
              console.log(scope.cqlClause);
            }
          }
        };

        scope.useCurrent = false;

        scope.useCurrentSelection = () => {

          if (scope.isActive) {
            scope.isActive = false;
          }

          // vérifie l'absence d'une intéraction de dessin de polygone existante
          finishAndResetBuildPolygon(true);
          scope.useCurrent = !scope.useCurrent;

          if (scope.useCurrent) {
            const selectedFeaturesObj = SelectManager.getfeatures();
            const selectedFeatures = selectedFeaturesObj.features;

            if (Array.isArray(selectedFeatures) && selectedFeatures.length > 0) {
              const selectedGeoms = selectedFeatures.map(feature => feature.geometry);

		
              if(selectedFeaturesObj.totalFeatures > 5000) {
                require('toastr').warning($filter('translate')('layermanager.selection_tres_importante'));
                scope.isApplyBufferDisabled = true;
              } else {
                scope.isApplyBufferDisabled = false;
                GeometryFactory.unionandbuffer(selectedGeoms, 'ROUND', 1).then(
                    function(res) {
                      const resultGeometry = res.data;

                      if (typeof resultGeometry.type === 'string' && resultGeometry.type === 'Polygon'
                          || resultGeometry.type === 'MultiPolygon') {
                        scope.currentSelectionClause = '';
                        const coords = resultGeometry.coordinates;

                        let polygonGeometry;
                        if (resultGeometry.type === 'Polygon') {
                          polygonGeometry = new ol.geom.Polygon(coords, 'XY');
                        } else if (resultGeometry.type === 'MultiPolygon') {
                          polygonGeometry = new ol.geom.MultiPolygon(coords, 'XY');
                        }

                        // ajoute le polygone de sélection à la couche de dessin temporaire
                        addFeatureToDrawLayer(polygonGeometry);

                        // créé la clause à partir de l'opérateur spatial et des coordonnées du polygone dessiné
                        scope.cqlClause = buildClauseWithOperator(polygonGeometry);
                        console.log(scope.cqlClause);
                      }
                    }
                );
              }
            }
          }
        };

        scope.geometricOperandChange = function() {
          scope.cqlClause =
            scope.selections.selectedGeomOperand + scope.currentWktGeometry;

          console.log(scope.cqlClause);
        };

        /**
         * Supprime l'intéraction de dessin de polygone rectangulaire
         * Permet aussi de nettoyer la couche temporaire (polygone jaune dessiné)
         * @param {boolean} reset est true si on souhaite également effacer le polygone jaune existant
         */
        const finishAndResetBuildPolygon = (reset) => {
          if (scope.isActive) {
            scope.isActive = false;
            scope.map.getInteractions().forEach(function(interaction) {
              if (interaction.T === 'Polygon')
                scope.map.removeInteraction(interaction);
            });
          }
          if (reset) {
            //clear drawed limit zones
            gclayers.getDrawLayer().getSource().clear();
            scope.limitZoneGeometry = null;
          }

        };

        /**
         * Construit une clause cql en string à partir d'un polygone de sélection, du nom du type de géométrie et d'un opérateur spatial
         * @param {ol.geom.Polygon|ol.geom.MultiPolygon} polygonGeometry géométrie du polygone de sélection
         * @return {string} clause spatiale d'une requête utilisable pour un appel API afin de récupérer des données selon une emprise
         */
        const buildClauseWithOperator = (polygonGeometry) => {
          if (polygonGeometry) {
            const wktFormatter = new ol.format.WKT();
            const wktStr = wktFormatter.writeGeometry(polygonGeometry);
            scope.currentWktGeometry = '(' + scope.geomTag + ', ' + wktStr + ')';
            return scope.selections.selectedGeomOperand + scope.currentWktGeometry;
          }
        };

        /**
         * Créé un polygone Openlayers et ajoute ce feature en surbrillance à la couche de dessin
         * @param {ol.geom.Polygon|ol.geom.MultiPolygon} polygonGeometry géométrie d'un polygone ou multi-polygone
         */
        const addFeatureToDrawLayer = (polygonGeometry) => {
          if (polygonGeometry) {
            const highLightFeature = new ol.Feature({
              geometry: polygonGeometry,
            });
            highLightFeature.setStyle(
                new ol.style.Style({
                  stroke: new ol.style.Stroke({
                    color: 'rgba(240, 240, 174, 1)',
                    width: 5,
                  }),
                  fill: new ol.style.Fill({
                    color: 'rgba(0, 0, 255, 0.1)',
                  }),
                })
            );
            gclayers.getDrawLayer().getSource().addFeatures([highLightFeature]);
          }
        };

        scope.validBufferSize = () => {
          if( scope.buffersize > 500 ) {
            require('toastr').warning($filter('translate')('layermanager.limite_taille_buffer'));
            scope.buffersize = 0;
          }else{
            if(scope.buffersize < 0) {
              require('toastr').warning($filter('translate')('layermanager.taille_buffer_neg'));
              scope.buffersize = 0;
            }
          }
        };

        /**
         * Au clic sur le bouton "Appliquer" du buffer de la sélection courante
         */
        scope.applyBuffer = () => {
          gclayers.getDrawLayer().getSource().clear();

          // vérifie l'absence d'une intéraction de dessin de polygone existante
          finishAndResetBuildPolygon(true);

          scope.limitZoneGeometry = null;
          const selectedFeaturesObj = SelectManager.getfeatures();
          const selectedFeatures = selectedFeaturesObj.features;

          if (Array.isArray(selectedFeatures) && selectedFeatures.length > 0) {
            const selectedGeoms = selectedFeatures.map(feature => feature.geometry);
            const bufferSize = scope.buffersize > 0 ? scope.buffersize : 0.1;
            if(selectedFeaturesObj.totalFeatures > 5000) {
              require('toastr').warning($filter('translate')('layermanager.selection_tres_importante'));
              scope.isApplyBufferDisabled = true;
            } else {
              GeometryFactory.unionandbuffer(selectedGeoms, 'ROUND', bufferSize).then(
                  function (res) {
                    const resultGeometry = res.data;

                    if (typeof resultGeometry.type === 'string' && resultGeometry.type === 'Polygon'
                        || resultGeometry.type === 'MultiPolygon') {
                      scope.currentSelectionClause = '';
                      const coords = resultGeometry.coordinates;

                      let polygonGeometry;
                      if (resultGeometry.type === 'Polygon') {
                        polygonGeometry = new ol.geom.Polygon(coords, 'XY');
                      } else {
                        polygonGeometry = new ol.geom.MultiPolygon(coords, 'XY');
                      }

                      // ajoute le polygone de sélection à la couche de dessin temporaire
                      addFeatureToDrawLayer(polygonGeometry);

                      // créé la clause à partir de l'opérateur spatial et des coordonnées du polygone dessiné
                      scope.cqlClause = buildClauseWithOperator(polygonGeometry);
                      console.log(scope.cqlClause);
                    }
                  });
            }
          }
        };
      },
    };
  };

  gcspatialcqlfilter.$inject = ['gclayers', 'SelectManager', 'GeometryFactory', '$filter'];
  return gcspatialcqlfilter;
});
