'use strict';
define(function() {
  var gcactionfeature = function (FeatureTypeFactory, $filter,
    ActionFeatureFactory, gcformfunction, RolesFactory,
    $rootScope, gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/data/views/actionfeature.html',
      restrict: 'A',
      scope: {
        res: '=res',
        ftid: '=ftid',
        editable: '=',
        interventionSimple: '=?',
        disabled: '=?',
        templateform: '=?',
        objectres: '=?',
        dlgPopupContainer: '=?'
      },
      link: function(scope) {
        scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        scope.actionTypeEsriGeoprocess = $filter('translate')('model.featuretypes.actions.esrigeoprocess');

        // dans le cas ou on envoie une liste d'elements on doit recupérer seulement la première
        scope.$watch('res', () => {
          if(scope.res && Array.isArray(scope.res) && scope.res.length>0){
            scope.results = scope.res[0];
          }else{
            scope.results = scope.res;
          }
        });

        // filtre les actions suivant le rôle de l'utilisateur
        RolesFactory.filterActionsByRoles($rootScope.xgos.user.login, scope.fti.actions).then(
          res => {
            scope.objectActions = res;
          }
        );

        // @RB @CD
        // on ne permet pas l'utilisation des details d'interventions ici, c'est uniquement depuis les is
        if (scope.objectActions && scope.objectActions.length) {
          scope.objectActions = scope.objectActions.filter(x => {
            return x.typeInfo !== 'IS_DETAIL' || scope.interventionSimple;
          });
        }

        /*
         * Add Action OUS
         */
        scope.executeAction = function() {
          const selectedAction = scope.currentselectedActionOnObject;
          if (!selectedAction) {
            require('toastr').error(
              $filter('translate')('selectfeaturetree.selectActionFirst')
            );
            return;
          }
          const actionEventsBefore
            = scope.templateform && scope.templateform.events ?
              scope.templateform.events.filter(
                event => event.origin.target.name == selectedAction.name
                  && event.origin.type == 'before'):[];
          const actionEventsAfter
            = scope.templateform && scope.templateform.events ?
              scope.templateform.events.filter(
                event => event.origin.target.name == selectedAction.name
                  && event.origin.type == 'after') : [];
          if (!scope.objectres) {
            scope.objectres = {};
          }
          scope.objectres.current = scope.results;
          scope.map = gaJsUtils.getMap(scope);
          var objects = {
            res: scope.objectres,
            map: scope.map,
            dlgPopupContainer: scope.dlgPopupContainer
          };

          // sur une action widget, reduire la popup
          if (scope.dlgPopupContainer && selectedAction.actionType === 'WIDGET') {
            scope.dlgPopupContainer.features.makeItTab();
          }

          let promiseArr = actionEventsBefore.map(function (event) {
            return gcformfunction.evaluateExpression(
              event.actions,
              objects
            ).then((res) => { return res; });
          });
          Promise.all(promiseArr).then(function (resultsArray) {
            switch (selectedAction.actionType) {
              case $filter('translate')('model.featuretypes.actions.form'):
                resultsArray.push(ActionFeatureFactory.executeForm(selectedAction, scope)
                  .then((res) => { return res; }));
                break;
              case $filter('translate')('model.featuretypes.actions.jasper'):
              // cette fonction ne renvoie pas une promise
                ActionFeatureFactory.executeJasper(
                  selectedAction,
                  scope.results,
                  'onobject',
                  scope
                );
                break;
              case $filter('translate')('model.featuretypes.actions.url'):
                resultsArray.push(ActionFeatureFactory.executeUrl(
                  selectedAction,
                  scope.results.properties,
                  scope
                ));
                break;
              case scope.actionTypeEsriGeoprocess:
                resultsArray.push(ActionFeatureFactory.executeEsriGeoprocess(
                  selectedAction, scope.results.properties, scope, scope.res.geometry,
                  scope.fti.srid));
                break;
              case $filter('translate')('model.featuretypes.actions.html'):
                resultsArray.push(ActionFeatureFactory.executeHtml(selectedAction, scope).then((res) => { return res; }));
                break;

              case $filter('translate')('model.featuretypes.actions.is_detail'):
              // minimify
              // var ngDialogWrapper = $(element).closest('.ngdialog');
              // ngDialogWrapper.addClass('ngdialog-minimified');

                // var modalTitle = $(element)
                //   .closest('.ngdialog-content')
                //   .find('.modalTitle');
                // modalTitle.on('dblclick', function() {
                //   ngDialogWrapper.removeClass('ngdialog-minimified');
                // });

                resultsArray.push(ActionFeatureFactory.executeDetailIntervention(
                  selectedAction,
                  scope
                ).then((res) => { return res; }));
                break;
              case $filter('translate')('model.featuretypes.actions.widget'):
              // Certains widget attendent une featureCollection, on la créé donc contenant une feature
                ActionFeatureFactory.openWidget(selectedAction, scope,
                  {
                    features: [scope.results],
                    realTotalFeatures: { Inspections: 1 },
                    totalFeatures: 1,
                    type: 'FeatureCollection'
                  });
                break;
              default:
                switch (selectedAction.typeInfo) {
                  case 'FORMULAIRE':
                    resultsArray.push(ActionFeatureFactory.executeForm(selectedAction, scope).then((res) => { return res; }));
                    break;
                  case 'JASPER':
                    // cette fonction ne renvoie pas une promise
                    ActionFeatureFactory.executeJasper(
                      selectedAction,
                      scope.results,
                      'onobject',
                      scope
                    );
                    break;
                  case 'URL':
                    resultsArray.push(ActionFeatureFactory.executeUrl(
                      selectedAction,
                      scope.results.properties,
                      scope
                    ).then((res) => { return res; }));
                    break;
                  case 'GEOPROCESS_ESRI':
                    resultsArray.push(ActionFeatureFactory.executeEsriGeoprocess(
                      selectedAction,
                      scope.results.properties,
                      scope
                    ).then((res) => { return res; }));
                    break;
                  case 'HTML':
                    resultsArray.push(ActionFeatureFactory.executeHtml(selectedAction, scope).then((res) => { return res; }));
                    break;
                }
                break;
            }
            Promise.all(resultsArray).then(() => {
              actionEventsAfter.map(function (event) {
                return gcformfunction.evaluateExpression(
                  event.actions,
                  objects);
              });
            });
          });
        };
      },
    };
  };

  gcactionfeature.$inject = ['FeatureTypeFactory', '$filter',
    'ActionFeatureFactory', 'gcformfunction', 'RolesFactory',
    '$rootScope', 'gaJsUtils'
  ];
  return gcactionfeature;
});
