'use strict';
define(function() {
  var gcconfigbrowser = function(ApplicationFactory, ConfigFactory, $timeout, gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/utilities/config/views/gcconfigbrowser.html',
      restrict: 'E',
      scope: {
        selected: '=?',
        allowSave: '=?',
        validateSelection: '&',
        applicationSwitch: '=?applicationSwitch',
        title: '=?',
        suffix: '@',
      },
      controller: [
        '$scope',
        function($scope) {
          $scope.featApplicationsTree = {};
          $scope.featTypesTree = {};

          $scope.applications = [];
          $scope.types = [];
          $scope.names = [];
        },
      ],
      link: function(scope, element, attrs, ctrl) {
        if (!angular.isDefined(scope.selected)) scope.selected = {};
        console.log(scope.selected);

        /**
         * Get Names List
         */
        scope.getNames = function() {
          ConfigFactory.getbytype(
            scope.selected.type,
            scope.selected.application_name
          ).then(function(r) {
            delete scope.selected.name;

            if (!angular.isArray(r.data)) return;

            var names = [];
            r.data.forEach(function(n) {
              if (!scope.suffix || n.indexOf(scope.suffix) != -1) {
                names.push(n);
              }
            });
            scope.names = names;

            // used only when the selected object is already provided
            if (angular.isDefined(scope.selected.svgname)) {
              scope.selected.name = scope.selected.svgname;
              delete scope.selected.svgname;
            }
          });
        };

        /**
         * getTypes
         */
        scope.getTypes = function() {
          scope.names = [];
          ConfigFactory.gettype(scope.selected.application_name).then(function(
            r
          ) {
            scope.types = [];
            if (!angular.isArray(r.data)) return;

            var selectedTypeIndex = null;

            const types = r.data.sort((a, b) => {
              return a.toLocaleLowerCase().localeCompare(b.toLocaleLowerCase());
            });

            types.forEach(function(type, index) {
              scope.types.push({
                label: type,
              });
              if (type == scope.selected.type) selectedTypeIndex = index;
            });

            // if a selected object was passed
            if (selectedTypeIndex != null) {
              $timeout(function() {
                var branch = scope.featTypesTree.get_first_branch();
                for (var i = 0; i < selectedTypeIndex; i++) {
                  branch = scope.featTypesTree.get_next_sibling(branch);
                }
                scope.featTypesTree.select_branch(branch);

                // save the name cause selected.name is deleted on every branch switch
                // but we dont want that to happen when the selected object was passed to the browser
                if (scope.selected.name)
                  scope.selected.svgname = scope.selected.name.replace(
                    '.form',
                    ''
                  );
              }, 0);
            }
          });
        };

        scope.switchApplication = function(branch) {
          scope.selected.application_name = branch.label;
          scope.getTypes();
        };
        scope.switchType = function(branch) {
          scope.selected.type = branch.label;
          scope.getNames();
        };

        /**
         * Check if type already exists
         * @returns {boolean}
         */
        scope.checkTypeExist = function() {
          return (
            scope.types
              .map(function(t) {
                return t.label;
              })
              .indexOf(scope.newtype.label) != -1 || scope.newtype.label == ''
          );
        };

        /**
         * Check if type already exists
         * @returns {boolean}
         */
        scope.addType = function() {
          scope.types.unshift({
            label: scope.newtype.label,
          });
          scope.selected.type = scope.newtype.label;
          scope.newtype.label = '';
          scope.types.select_first_branch();
          scope.getNames();
        };

        scope.newConfig = {};
        scope.newtype = { label: '' };

        // Load appliactions
        ApplicationFactory.get().then(function(app) {
          var applications = ApplicationFactory.resources.applications;
          if (applications.length == 0) return;

          // Create applications treeview
          scope.applications = [];
          var selectedApplicationIndex = null;
          applications = gaJsUtils.sortByKey(applications, 'name');
          applications.forEach(function(app, index) {
            scope.applications.push({
              label: app.name,
            });
            if (scope.selected.application_name == app.name) {
              selectedApplicationIndex = index;
            }
          });


          // if a selected object was passed
          if (selectedApplicationIndex != null) {
            $timeout(function() {
              var branch = scope.featApplicationsTree.get_first_branch();
              for (var i = 0; i < selectedApplicationIndex; i++) {
                branch = scope.featApplicationsTree.get_next_sibling(branch);
              }
              scope.featApplicationsTree.select_branch(branch);
            }, 0);
          }
        });
      },
    };
  };

  gcconfigbrowser.$inject = ['ApplicationFactory', 'ConfigFactory', '$timeout', 'gaJsUtils'];
  return gcconfigbrowser;
});
