'use strict';
define(function() {
  var gcButtonCfg = function() {
    return {
      templateUrl: 'js/XG/widgets/utilities/component/views/gcButtonCfg.html',
      restrict: 'A',
      scope: {
        field: '=',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.cfg = scope.field.cfg;
        if (!angular.isDefined(scope.cfg.icon)) scope.cfg.icon = {};

        console.log('test');

        /**
         * Toggle the possibility to set a color
         */
        scope.toggleColorSelection = function() {
          if (!angular.isDefined(scope.cfg.color)) {
            if (
              !angular.isDefined(scope.cfg.style) ||
              scope.cfg.style == 'btn-default'
            ) {
              scope.cfg.color = '#333333';
            } else {
              scope.cfg.color = '#ffffff';
            }
          } else {
            delete scope.cfg.color;
          }
        };

        var svgLabel = scope.cfg.label;
        scope.$watch('cfg.iconOrLabel', function(iol, iolOld) {
          if (iol == 'icon' && iolOld == 'label') {
            svgLabel = scope.cfg.label;

            scope.cfg.label = '';
          } else {
            scope.cfg.icon.spinning = false;
            scope.cfg.label = svgLabel;
          }
        });
      },
    };
  };

  gcButtonCfg.$inject = [];
  return gcButtonCfg;
});
