'use strict';

define(function() {
  var chartFactory = function($filter, gaBrowserSniffer) {
    var chartFactory = {};

    /**
     * Function: setXYfunctions
     * @param {object} obj options du chart
     * @param {x} x fonction de calcul de l'abcisse dans le chart
     * @param {y} y fonction de calcul de l'ordonnée dans le chart
     * @return les options x et y du chart // lecture des données
     */
    function setXYfunctions(obj, x, y) {
      obj.chart.x = x;
      obj.chart.y = y;
      return obj;
    }

    function getOptionsByType(str, dateattributes, name) {
      var w = 100;
      var h = 100;
      if (str === 'pieChart') {
        return getPieOption(w, h, dateattributes, name);
      } else if (str === 'lineChart') {
        return getLineOption(w, h, dateattributes, name);
      } else if (str === 'multiBarChart') {
        return getmultiBarOption(w, h, dateattributes, name);
      } else if (str === 'discreteBarChart') {
        return getDiscreteBarOption(w, h, dateattributes, name);
      } else if (str === 'stackedAreaChart') {
        return getstackedAreaOption(w, h, dateattributes, name);
      } else if (str === 'scatterChart') {
        return getscatterChartOption(w, h, dateattributes, name);
      }
    }

    /**
     * Function: getPieOption
     * @param {w} w width du svg
     * @param {h} h heigth du svg
     * @return {object} les options du pie chart
     */
    function getPieOption(w, h, dateattributes, name) {
      return {
        chart: {
          type: 'pieChart',
          width: w,
          showLabels: true,
          height: h,
          labelThreshold: 0.02,
          labelSunbeamLayout: true,
          useInteractiveGuideline: true,
          interactive: true,
          showLegend: false,
          x: null,
          y: null,
          legend: {
            margin: {
              top: 5,
              right: 35,
              bottom: 5,
              left: 0,
            },
          },
          donut: false,
          tooltip: {
            duration: 0,
            gravity: 'w',
            distance: 25,
            snapDistance: 0,
            classes: null,
            chartContainer: null,
            fixedTop: null,
            enabled: true,
            hideDelay: 400,
            headerEnabled: false,
            valueFormatter: null,
            contentGenerator: function(d) {
              var html =
                "<table><tbody><tr><td class='legend-color-guide'><div style='background-color: " +
                d.color +
                ";'>";
              //html += "<td class='key'>"+d.data.label+"</div></td>";
              if (dateattributes.indexOf(name) !== -1) {
                html +=
                  "<td class='key'>" +
                  gaBrowserSniffer
                    .parseDateSpecIEchart(d.data.label)
                    .toDateString() +
                  '</div></td>';
              } else {
                html += "<td class='key'>" + d.series[0].key + '</div></td>';
              }
              html +=
                "<td class='value'> " +
                $filter('translate')('chart.count') +
                ':' +
                d3.format('.i')(d.data.count) +
                '</td>';
              html +=
                "<td class='value'> " +
                $filter('translate')('chart.percentage') +
                ':' +
                d3.format('.2f')(d.data.value) +
                '%</td></tr>';
              html += '</table></tbody>';
              return html;
            },
            position: {
              left: null,
              top: null,
            },
            offset: {
              left: h / 2,
              top: 0,
            },
            hidden: true,
            data: null,
            tooltipElem: null,
          },
          labelsOutside: true,
        },
        title: {
          enable: false,
          text: '',
          className: 'h4',
          css: {
            width: 'auto',
            textAlign: 'center',
          },
        },
      };
    }

    /**
		/**
		* Function: getLineOption
	        * @param {w} w width du svg
	        * @param {h} h heigth du svg
	        * @return {object} les options du line chart
		**/
    function getLineOption(w, h, dateattributes, name) {
      return {
        chart: {
          type: 'lineChart',
          width: w,
          height: h,
          margin: {
            top: 20,
            right: 20,
            bottom: 45,
            left: 50,
          },
          axisType: 'percent',
          showLegend: false,
          clipEdge: true,
          duration: 500,
          stacked: true,
          xAxis: {
            showMaxMin: true,
            axisLabelDistance: 0,
            opacity: 1,
          },
          yAxis: {
            showMaxMin: true,
            axisLabelDistance: -20,
          },
          reduceXTicks: true,
          interactive: true,
          tooltip: {
            duration: 0,
            gravity: 'w',
            distance: 25,
            snapDistance: 0,
            classes: null,
            chartContainer: null,
            fixedTop: null,
            enabled: true,
            hideDelay: 400,
            headerEnabled: false,
            valueFormatter: null,
            contentGenerator: function(d) {
              var html =
                "<table><tbody><tr><td class='legend-color-guide'><div style='background-color: " +
                d.point.color +
                ";'>";
              if (dateattributes.indexOf(name) !== -1) {
                html +=
                  "<td class='x'>" +
                  gaBrowserSniffer
                    .parseDateSpecIEchart(d.point.x)
                    .toDateString() +
                  '</div></td>';
              } else {
                html += "<td class='x'> x:" + d.point.x + '</div></td>';
              }
              html += "<td class='y'>y:" + d.point.y + '</td></tr>';

              html += '</table></tbody>';
              return html;
            },
          },
        },
        title: {
          enable: false,
          text: '',
          className: 'h4',
          css: {
            width: 'auto',
            textAlign: 'center',
          },
        },
      };
    }

    /**
     * Function: getmultiBarOption
     * @param {w} w width du svg
     * @param {h} h heigth du svg
     * @return {object} les options du multi barre chart
     */
    function getmultiBarOption(w, h, dateattributes, name) {
      return {
        chart: {
          type: 'multiBarChart',
          width: w,
          height: h,
          margin: {
            top: 20,
            right: 20,
            bottom: 45,
            left: 50,
          },
          axisType: 'percent',
          showLegend: false,
          clipEdge: true,
          duration: 500,
          stacked: false,
          xAxis: {
            showMaxMin: true,
            axisLabelDistance: 0,
            orient: 'center',
            ticks: 1,
            width: 75,
          },
          yAxis: {
            showMaxMin: true,
            axisLabelDistance: -20,
            ticks: null,
            width: 75,
          },
          tooltip: {
            duration: 0,
            gravity: 'w',
            distance: 25,
            snapDistance: 0,
            classes: null,
            chartContainer: null,
            fixedTop: null,
            enabled: true,
            hideDelay: 400,
            headerEnabled: false,
            valueFormatter: null,
            contentGenerator: function(d) {
              var html =
                "<table><tbody><tr><td class='legend-color-guide'><div style='background-color: " +
                d.color +
                ";'>";
              /*if ( dateattributes.indexOf(name) !== -1 ) {
                                                //html += "<td class='value'>"+$filter('translate')('chart.percentage')+":"+gaBrowserSniffer.parseDateSpecIEchart(d.data.key).toDateString()+"%</td></tr>";
                                                html += "<td class='key'>"+gaBrowserSniffer.parseDateSpecIEchart(d.data.key).toDateString()+"</div></td>";
                                            } else {*/
              html += "<td class='key'>" + d.value + '</div></td>';
              //}
              html +=
                "<td class='value'> " +
                $filter('translate')('chart.count') +
                ':' +
                d3.format('.i')(d.data.count) +
                '</td>';
              html +=
                "<td class='value'>" +
                $filter('translate')('chart.percentage') +
                ':' +
                d3.format('.2f')(d.data.y) +
                '%</td></tr>';

              html += '</table></tbody>';
              return html;
            },
          },
          reduceXTicks: true,
        },
        title: {
          enable: false,
          text: '',
          className: 'h4',
          css: {
            width: 'auto',
            textAlign: 'center',
          },
        },
      };
    }

    /**
     * Function: getDiscreteBarOption
     * @param {w} w width du svg
     * @param {h} h heigth du svg
     * @return {object} les options du discrete bar chart
     */
    function getDiscreteBarOption(w, h, dateattributes, name) {
      return {
        chart: {
          type: 'discreteBarChart',
          width: w,
          height: h,
          margin: {
            top: 20,
            right: 20,
            bottom: 60,
            left: 50,
          },
          showLegend: false,
          clipEdge: true,
          duration: 500,
          stacked: true,
          showValues: false,

          showXAxis: null,
          xAxis: {
            showMaxMin: true,
            axisLabelDistance: 0,
            rotateLabels: 70,

            ticks: 15,
            width: 75,
            staggerLabels: false,
          },
          yAxis: {
            showMaxMin: true,
            axisLabelDistance: -20,
            ticks: null,
            width: 75,
          },
          axisType: 'percent',
          showLabels: false,
          tooltip: {
            duration: 0,
            gravity: 'w',
            distance: 25,
            snapDistance: 0,
            classes: null,
            chartContainer: null,
            fixedTop: null,
            enabled: true,
            hideDelay: 400,
            headerEnabled: false,
            valueFormatter: null,
            contentGenerator: function(d) {
              var html =
                "<table><tbody><tr><td class='legend-color-guide'><div style='background-color: " +
                d.color +
                ";'>";
              //html += "<td class='key'>"+d.data.label+"</div></td>";
              if (dateattributes.indexOf(name) !== -1) {
                html +=
                  "<td class='key'>" +
                  gaBrowserSniffer
                    .parseDateSpecIEchart(d.data.label)
                    .toDateString() +
                  '</div></td>';
              } else {
                html += "<td class='key'>" + d.series[0].key + '</div></td>';
              }
              html +=
                "<td class='value'>" +
                $filter('translate')('chart.count') +
                ':' +
                d3.format('.i')(d.data.count) +
                '</td>';
              html +=
                "<td class='value'>" +
                $filter('translate')('chart.percentage') +
                ':' +
                d3.format('.2f')(d.data.value) +
                '%</td></tr>';
              html += '</table></tbody>';
              return html;
            },
            position: {
              left: null,
              top: null,
            },
            offset: {
              left: 0,
              top: 0,
            },
            hidden: true,
            data: null,
            tooltipElem: null,
          },
          reduceXTicks: true,
        },
        title: {
          enable: false,
          text: '',
          className: 'h4',
          css: {
            width: 'auto',
            textAlign: 'center',
          },
        },
      };
    }

    /**
     * Function: getstackedAreaOption
     * @param {w} w width du svg
     * @param {h} h heigth du svg
     * @return {object} les options du stacked area chart
     */
    function getstackedAreaOption(w, h, dateattributes, name) {
      return {
        chart: {
          type: 'stackedAreaChart',
          width: w,
          height: h,
          margin: {
            top: 20,
            right: 20,
            bottom: 45,
            left: 50,
          },
          axisType: 'percent',
          showLegend: false,
          clipEdge: true,
          duration: 500,
          useInteractiveGuideline: false,
          stacked: {
            interactive: false,
          },
          xAxis: {
            showMaxMin: true,
            axisLabelDistance: 0,
          },
          yAxis: {
            showMaxMin: true,
            axisLabelDistance: -20,
          },
          tooltip: {
            duration: 0,
            gravity: 'w',
            distance: 25,
            snapDistance: 0,
            classes: null,
            chartContainer: null,
            fixedTop: null,
            enabled: true,
            hideDelay: 400,
            headerEnabled: false,
            valueFormatter: null,
            contentGenerator: function(d) {
              var html =
                "<table><tbody><tr><td class='legend-color-guide'><div style='background-color: " +
                d.point.color +
                ";'>";
              if (dateattributes.indexOf(name) !== -1) {
                html +=
                  "<td class='x'>" +
                  gaBrowserSniffer
                    .parseDateSpecIEchart(d.point.x)
                    .toDateString() +
                  '</div></td>';
              } else {
                html += "<td class='x'> x:" + d.point.x + '</div></td>';
              }
              html += "<td class='y'>y:" + d.point.y + '</td></tr>';

              html += '</table></tbody>';
              return html;
            },
          },
        },
        title: {
          enable: false,
          text: '',
          className: 'h4',
          css: {
            width: 'auto',
            textAlign: 'center',
          },
        },
      };
    }

    function getscatterChartOption(w, h, dateattributes, name) {
      return {
        chart: {
          type: 'scatterChart',
          width: w,
          height: h,
          margin: {
            top: 20,
            right: 20,
            bottom: 45,
            left: 50,
          },
          showDistX: true,
          showDistY: true,
          duration: 350,
          legend: false,
          xAxis: {
            axisLabel: 'X Axis',
          },
          yAxis: {
            axisLabel: 'Y Axis',
            axisLabelDistance: -15,
          },
          axisType: 'percent',
          zoom: {
            enabled: true,
            scaleExtent: [1, 10],
            useFixedDomain: false,
            useNiceScale: false,
            horizontalOff: false,
            verticalOff: false,
            unzoomEventType: 'dblclick.zoom',
          },
          title: {
            enable: false,
            text: '',
            className: 'h4',
            css: {
              width: 'auto',
              textAlign: 'center',
            },
          },
        },
      };
    }

    return {
      chartFactory: chartFactory,
      setXYfunctions: setXYfunctions,
      getPieOption: getPieOption,
      getLineOption: getLineOption,
      getmultiBarOption: getmultiBarOption,
      getDiscreteBarOption: getDiscreteBarOption,
      getstackedAreaOption: getstackedAreaOption,
      getscatterChartOption: getscatterChartOption,
      getOptionsByType: getOptionsByType,
    };
  };

  chartFactory.$inject = ['$filter', 'gaBrowserSniffer'];

  return chartFactory;
});
