'use strict';
define(function() {
  var calendarEventType = function(CalendarFactory, $rootScope) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/calendar/views/calendar_event_type.html',
      restrict: 'EA',
      scope: {
        idEventType: '=',
      },
      link: function(scope, element, attrs, ctrl) {
        // get eventTypes
        scope.eventTypes = [];
        var getEventTypes = function() {
          CalendarFactory.geteventtypes().then(function() {
            scope.eventTypes = CalendarFactory.resources.event_types;
            scope.eventTypes.unshift('');
          });
        };
        getEventTypes();

        // whenever the list event types list is modified
        $rootScope.$on('editCalendarEventTypes', function() {
          getEventTypes();
        });
      },
    };
  };

  calendarEventType.$inject = ['CalendarFactory', '$rootScope'];
  return calendarEventType;
});
