'use strict';
define(function() {
  var calendarColor = function($rootScope, $timeout) {
    return {
      templateUrl: 'js/XG/widgets/utilities/calendar/views/calendar_color.html',
      restrict: 'EA',
      scope: {
        res: '=',
        hasColor: '=?',
        calendarFilter: '@?',
        cannotModify: '=?',
        noTitle: '=?', // no title...
        mandatoryColor: '=?',
        changeColor: '&',
      },
      link: function(scope, element, attrs, ctrl) {
        // init
        scope.eventColors = [
          {
            label: 'red',
            color: 'e74c3c',
          },
          {
            label: 'green',
            color: '3dd37c',
          },
          {
            label: 'purple',
            color: '8e44ad',
          },
          {
            label: 'darkblue',
            color: '2c3e50',
          },
          {
            label: 'indigo',
            color: '2980b9',
          },
        ];

        scope.setEventColor = function(c) {
          if (scope.cannotModify) return false;
          if (scope.res == c.color && !scope.mandatoryColor) {
            scope.res = false;
            if (scope.calendarFilter) {
              $rootScope.$broadcast('calendarFilterColorReturnFalse');
            }
            $timeout(() => {
              scope.changeColor();
            }, 100);
            return false;
          }
          scope.res = c.color;
          $timeout(() => {
            scope.changeColor();
          }, 100);
        };
      },
    };
  };

  calendarColor.$inject = ['$rootScope', '$timeout'];
  return calendarColor;
});
