'use strict';
define(() => {
  var gcelement = (
    $rootScope,
    AssociationFactory,
    FeatureTypeFactory,
    QueryFactory,
    ngDialog,
    $filter,
    attributeRestrictionsUtils,
    gaJsUtils
  ) => {
    return {
      templateUrl:
        'js/XG/widgets/utilities/associations/views/gcselectassociation.html',

      restrict: 'A',
      scope: {
        result: '=res',
        field:'=field'
      },
      link: (scope, element, attrs, ctrl) => {
        scope.$on('refreshAssociation', () => {
            updateAssociation();
        });
        let updateAssociation = () =>{
          //set default value as 'current
          if (!scope.field.config.sourceVariable) {
            scope.field.config.sourceVariable = 'current';
          }
          if (scope.result && scope.result[scope.field.config.sourceVariable] && scope.result[scope.field.config.sourceVariable].id
            && $rootScope.xgos.portal && $rootScope.xgos.portal.parameters && $rootScope.xgos.portal.parameters.mainDB){
            AssociationFactory.getAssociatedValues(
              $rootScope.xgos.portal.parameters.mainDB, scope.field.config.name,
              scope.result[scope.field.config.sourceVariable].id)
              .then((res) => {
                if(!scope.result.associations){
                  scope.result.associations = {};
                }
                if(res && res.data && res.data.features && res.data.features.length>0){
                  scope.result.associations[scope.field.config.name] = res.data.features;
                }else{
                  scope.result.associations[scope.field.config.name] = [];
                }
            },(err) =>{
              if(!scope.result.associations){
                scope.result.associations = {};
                scope.result.associations[scope.field.config.name] = [];
              }else{
                scope.result.associations[scope.field.config.name] = [];
              }
              require('toastr').error(scope.field.config.name + ': ' + $filter('translate')(err.data));
            });
          }
        }

        updateAssociation();

        scope.selectAssociatedValues = () => {
          if($rootScope.xgos.portal && $rootScope.xgos.portal.parameters && 
            $rootScope.xgos.portal.parameters.mainDB){
              if(angular.equals(scope.result.associations, {})){
                updateAssociation();
              }
              AssociationFactory.getAll($rootScope.xgos.portal.parameters.mainDB).then((res) => {
                scope.associations = res.data;
                scope.selectedAssociation = res.data.filter(ass=>  ass.name == scope.field.config.name)[0];
                if(!scope.selectedAssociation){
                  require('toastr').error(scope.field.config.name + ': ' + $filter('translate')('model.association.associationNotFound'));
                  return;
                }
                scope.nameOtherAssociationTable = scope.selectedAssociation.atable === scope.field.config.ftiname?
                                                      scope.selectedAssociation.btable:scope.selectedAssociation.atable;
                scope.uidOtherAssociationTable = FeatureTypeFactory.getFeatureUidByName(scope.nameOtherAssociationTable);
                scope.ftiOtherAssociationTable = FeatureTypeFactory.getFeatureByName(scope.nameOtherAssociationTable);
                const ftiOfSourceComponent = FeatureTypeFactory.getFeatureByName(scope.field.config.ftiname);
                let filterTranslated;
                let promise;
                if (!scope.field.config.sourceVariable) {
                  scope.field.config.sourceVariable = 'current';
                }
                if(scope.field.config.applyFilter){
                  let variableProperties;
                  if (scope.result && scope.result[scope.field.config.sourceVariable]) {
                    variableProperties = scope.result[scope.field.config.sourceVariable].properties
                  } else {
                    variableProperties = undefined;
                  }
                  promise = attributeRestrictionsUtils.prepareDynamicFilter(scope.field.config.filterDefinition,
                    ftiOfSourceComponent, variableProperties, undefined)
                } else {
                  //empty promise
                  promise = Promise.resolve();
                }
                promise.then((filters) => {
                    // only keeps complete filter
                    filterTranslated = filters.find(it => typeof it === 'string');
                  })
                  .catch ((error) => {
                    console.error("error getting values from tables, the entire filter is removed");
                  })
                  .then(() => {
                    return QueryFactory.data(scope.uidOtherAssociationTable, filterTranslated)
                  })
                  .then(scope.displayDialog)
                  .catch((err) => {
                      require('toastr').error('Cant reach the table');
                    }
                  );
              });
          }
        };

        scope.displayDialog = (res) => {
          let pickChoicesStatique = angular.copy(res.data.features);
          scope.pickChoices = res.data.features;
          scope.pickKeys = [scope.ftiOtherAssociationTable.type =='esri'?scope.ftiOtherAssociationTable.esriIdField:'fid',
                            scope.field.config.champLibelle];
          ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.pickfromtablemultiplekeys.html',
            className: 'width800 ngdialog-theme-plain miniclose',
            closeByDocument: false,
            scope: scope,
          });
          scope.pickRestrictedValue = (value) => {
            if(!scope.result.associations){
              scope.result.associations = {};
            }
            if(!scope.result.associations[scope.selectedAssociation.name]){
              scope.result.associations[scope.selectedAssociation.name] = [];
            }
            scope.result.associations[scope.selectedAssociation.name].push(value);
          };

          scope.removeRestrictedValue = (index) => {
            scope.result.associations[scope.selectedAssociation.name].splice(index, 1);
          }

          scope.filterRestrictedValues = () => {
            scope.pickChoices = angular.copy(pickChoicesStatique);
            scope.pickKeys.forEach(pickKey => {
              let filterRestrictedValue = document.getElementById('filterRestrictedValue_'+pickKey).value;
              scope.pickChoices = scope.pickChoices.filter(
                pickchoice => pickchoice.properties[pickKey].toString().toUpperCase().includes(filterRestrictedValue.toUpperCase())
              );
            });
          };

          scope.itemExitInSelection = (id) => {
            if(scope.result && scope.result.associations && scope.result.associations[scope.selectedAssociation.name])
            {
              return scope.result.associations[scope.selectedAssociation.name].findIndex(item => item.id === id);
            } else {
              return -1;
            }
          }
        }

        /**
         * Centre horizontalement le titre de la colonne "Action" lorsque le tableau des valeurs possède une barre de défilement verticale
         * @return {boolean} true si le body possède une barre de défilement vertical
         */
        scope.bodyHasVerticalScrollBar = () => {
          const popupBody = document.getElementById('pickfrommultitable-body');
          if (popupBody) {
            return gaJsUtils.hasVerticalScrollbar(popupBody);
          }
          return false;
        }
      },
    };
  };

  gcelement.$inject = [
    '$rootScope',
    'AssociationFactory',
    'FeatureTypeFactory',
    'QueryFactory',
    'ngDialog',
    '$filter',
    'attributeRestrictionsUtils',
    'gaJsUtils'
  ];
  return gcelement;
});
