'use strict';
define(function() {
  var PonderationCtrl = function(
    $scope,
    ParametersFactory,
    ngDialog,
    $location,
    $filter
  ) {
    $scope.currentPonderation = false;
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
    /**
     * load the list of cfg
     */
    var refresh = function() {
      $scope.currentPonderation = false;
      $scope.cfgList = [];
      ParametersFactory.getbytype('siroco_ponderation').then(function(res) {
        if (res.data.length > 0) {
          res.data.forEach(function(cfg) {
            if (cfg.data.app == sirocoCfg.appuid) {
              $scope.cfgList.push(cfg);
            }
          });
        }
      });
    };
    refresh();

    /**
     * newPonderationModal
     */
    $scope.newPonderationModal = function() {
      $scope.newPonderationData = {};
      ngDialog.open({
        template:
          'js/XG/widgets/sirocoapp/init/views/modals/modal.newponderation.html',
        className: 'ngdialog-theme-plain nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };
    /**
     * newPonderation
     */
    $scope.newPonderation = function() {
      var saveData = {
        app: sirocoCfg.appuid,
      };
      ParametersFactory.add(
        saveData,
        'siroco_ponderation',
        $scope.newPonderationData.name
      ).then(function(res) {
        $scope.cfgList.push(res.data);
      });
    };

    /**
     * save Ponderation
     */
    $scope.savePonderation = function() {
      ParametersFactory.update(
        $scope.currentPonderation,
        $scope.currentPonderation.id
      ).then(function(res) {
        require('toastr').success($filter('translate')('common.saved'));
      });
    };

    $scope.$watch('currentPonderation.data', function(cP) {
      if (cP) {
        if (angular.isUndefined(cP.ilch)) cP.ilch = 0;
        if (angular.isUndefined(cP.ilp)) cP.ilp = 0;
        if (angular.isUndefined(cP.cvm)) cP.cvm = 0;
        if (angular.isUndefined(cP.crep)) cP.crep = 0;
        if (angular.isUndefined(cP.ptr)) cP.ptr = 0;
      }
    });

    /**
     * delete Ponderation
     */
    $scope.deletePonderation = function() {
      var ans = confirm(
        'Êtes-vous certain de vouloir supprimer cette pondération ?'
      );
      if (ans) {
        ParametersFactory.remove($scope.currentPonderation.id).then(function() {
          refresh();
        });
      }
    };
  };

  PonderationCtrl.$inject = [
    '$scope',
    'ParametersFactory',
    'ngDialog',
    '$location',
    '$filter',
  ];
  return PonderationCtrl;
});
