'use strict';
define(function() {
  var MapCtrl = function(
    $scope,
    FeatureTypeFactory,
    gcWMS,
    ConfigFactory,
    gclayers,
    $rootScope,
    SirocoFactory,
    panelsManager
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

    $scope.map = new ol.Map({
      layers: [
        new ol.layer.Tile({
          source: new ol.source.OSM(),
        }),
      ],
      controls: ol.control.defaults({
        attribution: false,
      }),
      target: 'map_base',
      view: new ol.View({
        zoom: 14,
      }),
      ol3Logo: false,
    });

    panelsManager.init();
    $scope.panelsManager = panelsManager;

    gclayers.clearOperationalLayerg2c();
    console.log(gclayers.getOperationalLayer());
    var layersToDisplay = [
      sirocoCfg.layersNames.cana_aep,
      sirocoCfg.layersNames.fuite,
      sirocoCfg.layersNames.noeud_1,
    ];

    FeatureTypeFactory.get().then(function() {
      FeatureTypeFactory.resources.featuretypes.forEach(function(fType) {
        var ind = 0;
        if (fType.storeName == sirocoCfg.mainConfig.datastore) {
          if (fType.geographic && fType.published) {
            if (layersToDisplay.indexOf(fType.name) != -1) {
              var l = gcWMS.getOlLayerFromFeaturetypeInfo(fType, ind);
              l.visible = true;
              l.selected = true;

              ind++;
              gclayers.addOperationalLayerg2c(l);

              // zoom on extent of cana
              if (fType.name == sirocoCfg.layersNames.cana_aep) {
                FeatureTypeFactory.getExtent(
                  fType.uid,
                  $scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(function(res) {
                  var bbox = res.data;
                  $scope.map.getView().fit(bbox, $scope.map.getSize());
                });
              }
            }
          }
        }
        //
      });
      $rootScope.$broadcast('gcOperationalLayerOnInit');
    });

    /*$scope.map.on('singleclick', function(evt) {
         console.log(evt.coordinate);
         });*/

    /*$scope.saveExtent = function(){
         var size = $scope.map.getSize();
         var mapExtent = $scope.map.getView().calculateExtent(size);
         console.log(mapExtent);
         }*/
  };

  MapCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'gcWMS',
    'ConfigFactory',
    'gclayers',
    '$rootScope',
    'SirocoFactory',
    'panelsManager',
  ];
  return MapCtrl;
});
