'use strict';
define(function() {
  var CassesCtrl = function(
    $scope,
    SirocoFactory,
    $window,
    gaDomUtils,
    ngDialog,
    FilesFactory,
    FeatureTypeFactory
  ) {
    // console.log('CassesCtrl');

    $scope.waitImport = true;
    $scope.showExpDetails = false;
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

    // récupération de casses et criticité
    $scope.getFichiersCfg = function(type) {
      SirocoFactory.getCasseCriticite(type).then(function(res) {
        if (res.data.length > 0) {
          if (type == 'casse') {
            $scope.fichierCasse = res.data[0];
          } else {
            $scope.fichierCriticite = res.data[0];
          }
        }
      });
    };
    $scope.getFichiersCfg('casse');
    $scope.getFichiersCfg('criticite');

    $scope.getFieldsToExport = function() {
      var ii,
        jj,
        layer,
        liste = '';

      for (ii = 0; ii < $scope.expLayers.length; ii++) {
        layer = $scope.expLayers[ii];
        for (jj = 0; jj < layer.fields.length; jj++) {
          if (layer.fields[jj].a_exporter) {
            if (liste.length != 0) liste += 'xxSEPxx';
            liste += layer.layerid + '.' + layer.fields[jj].name;
          }
        }
      }
      return liste;
    };

    $scope.exportCasses = function() {
      gaDomUtils.showGlobalLoader();

      var fieldsTe = $scope.getFieldsToExport();

      SirocoFactory.handleexport(
        sirocoCfg.appname,
        'AvecTelechargement',
        '',
        fieldsTe
      ).then(
        function(res) {
          if (res.data.ok) {
            $window.open(res.data.strValeur);
            gaDomUtils.hideGlobalLoader();
          } else {
            gaDomUtils.hideGlobalLoader();

            //require('toastr').clear();
            require('toastr').error(
              res.data.errorMessage,
              'Erreur lors du télechargement du fichier casses',
              {
                closeButton: true,
                timeOut: '0',
                extendedTimeOut: '0',
                positionClass: 'toast-bottom-full-width',
              }
            );
          }

          // error
        },
        function() {
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    $scope.importCasses = function() {
      // gaDomUtils.showGlobalLoader();
      $scope.sirocoFT = {
        id: 'casse',
        featuretype: 'siroco',
      };

      var cassesDialog = ngDialog.open({
        template:
          'js/XG/widgets/sirocoapp/init/views/modals/modal.importcasses.html',
        className: 'ngdialog-theme-plain nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });

      cassesDialog.closePromise.then(function(data) {
        $scope.getFichiersCfg('casse');
      });
    };

    $scope.importCriticite = function() {
      // gaDomUtils.showGlobalLoader();
      $scope.descFT = {
        id: 'criticite',
        featuretype: 'siroco',
      };

      var criticiteDialog = ngDialog.open({
        template:
          'js/XG/widgets/sirocoapp/init/views/modals/modal.importcriticite.html',
        className: 'ngdialog-theme-plain nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
      criticiteDialog.closePromise.then(function(data) {
        $scope.getFichiersCfg('criticite');
      });
    };

    $scope.fichierType = function(typeDonnees) {
      var downloadurl = 'WEB-INF/siroco/fileSamples/' + typeDonnees + '.csv';
      FilesFactory.getfileFromPath(downloadurl).then(function(res) {
        var fileContent = res.data;
        if (res.data.startsWith('Error:')) {
          require('toastr').error(
            res.data,
            'Erreur lors du télechargement du fichier type',
            {
              closeButton: true,
              timeOut: '3000',
              extendedTimeOut: '0',
              positionClass: 'toast-bottom-full-width',
            }
          );
        } else window.open(res.data);
      });
    };

    $scope.setLayerAlias1 = function(layer) {
      var ind;
      var fts;

      fts = FeatureTypeFactory.resources.featuretypes;
      for (ind = 0; ind < fts.length; ind++) {
        if (fts[ind].name == layer.name) {
          layer.alias = fts[ind].alias;
          break;
        }
      }
    };
    $scope.setLayerAlias = function(layer) {
      if (
        FeatureTypeFactory.resources.featuretypes == undefined ||
        FeatureTypeFactory.resources.featuretypes.length == 0
      )
        FeatureTypeFactory.get().then(function() {
          $scope.setLayerAlias1(layer);
        });
      else $scope.setLayerAlias1(layer);
    };

    $scope.exportIsPossible = function() {
      var fields;

      if ($scope.expLayers == undefined) return false;

      for (var ii = 0; ii < $scope.expLayers.length; ii++) {
        fields = $scope.expLayers[ii].fields;
        for (var jj = 0; jj < fields.length; jj++) {
          if (fields[jj].mandatory && fields[jj].nullValueExists) return false;
        }
      }
      return true;
    };

    $scope.checkExportCasseData = function() {
      SirocoFactory.checkExportData().then(function(res) {
        var fields;
        $scope.expLayers = res.data.objValeur.layers;
        for (var ii = 0; ii < $scope.expLayers.length; ii++) {
          $scope.setLayerAlias($scope.expLayers[ii]);
          fields = $scope.expLayers[ii].fields;
          for (var jj = 0; jj < fields.length; jj++) {
            if (fields[jj].name.startsWith('###'))
              fields[jj].name = fields[jj].name.substr(4);
            if (fields[jj].mandatory) fields[jj].disabled = true;
            if (fields[jj].nullValueExists) fields[jj].a_exporter = false;
            else fields[jj].a_exporter = true;
            if (fields[jj].notNullValueExists) {
              if (fields[jj].nullValueExists)
                fields[jj].infoExiste =
                  'Valeurs renseignées et non renseignées';
              else
                fields[jj].infoExiste = 'Toutes les valeurs sont renseignées';
            } else {
              fields[jj].infoExiste = 'Aucune valeur renseignée';
              fields[jj].disabled = true;
            }
          }
        }
      });
    };
    $scope.checkExportCasseData();
    FeatureTypeFactory.get();
  };

  CassesCtrl.$inject = [
    '$scope',
    'SirocoFactory',
    '$window',
    'gaDomUtils',
    'ngDialog',
    'FilesFactory',
    'FeatureTypeFactory',
  ];
  return CassesCtrl;
});
