'use strict';
define(function() {
  var sldsimplepointsymbolizer = function(sldUtils, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/symbolizer/sldsimplepointsymbolizer.html',
      restrict: 'EA',
      scope: {
        graphic: '=graphic',
        distance: '=',
        fti: '=fti',
      },
      link: function(scope) {
        // define stroke type
        scope.strokeType = 'none';
        // used to retrieve the stroke type when user toggles between different point symboilizers
        scope.$watch(
          'graphic.Mark',
          function(mark) {
            if (angular.isDefined(mark) && angular.isDefined(mark.Stroke)) {
              var dashArray = $filter('cssParam')(
                scope.graphic.Mark.Stroke,
                'stroke-dasharray'
              )['__text'];
              if (dashArray && dashArray != '') {
                scope.strokeType = 'dash';
                if (dashArray == '1 2') scope.strokeType = 'dots';
              } else {
                scope.strokeType = 'continuous';
              }
            } else {
              scope.strokeType = 'none';
            }
          },
          1
        );

        scope.strokeTypes = [
          {
            key: 'none',
            label: 'model.styles.editor.symbolizers.common.stroke.types.none',
          },
          {
            key: 'continuous',
            label:
              'model.styles.editor.symbolizers.common.stroke.types.continuous',
          },
          {
            key: 'dash',
            label: 'model.styles.editor.symbolizers.common.stroke.types.dash',
          },
          {
            key: 'dots',
            label: 'model.styles.editor.symbolizers.common.stroke.types.dots',
          },
        ];
        scope.changeStrokeType = function() {
          if (scope.strokeType == 'none') {
            delete scope.graphic.Mark.Stroke;
          } else {
            if (!angular.isDefined(scope.graphic.Mark.Stroke)) {
              scope.graphic.Mark.Stroke = {
                CssParameter: [
                  {
                    _name: 'stroke',
                    __text: '#000000',
                  },
                ],
              };
            }

            if (scope.strokeType == 'dash') {
              $filter('cssParam')(
                scope.graphic.Mark.Stroke,
                'stroke-dasharray'
              )['__text'] = '5 6';
            } else if (scope.strokeType == 'dots') {
              $filter('cssParam')(
                scope.graphic.Mark.Stroke,
                'stroke-dasharray'
              )['__text'] = '0.25 2';
            } else if (scope.strokeType == 'continuous') {
              for (
                var ind = scope.graphic.Mark.Stroke.CssParameter.length - 1;
                ind >= 0;
                ind--
              ) {
                if (
                  scope.graphic.Mark.Stroke.CssParameter[ind] != undefined &&
                  scope.graphic.Mark.Stroke.CssParameter[ind]._name ==
                    'stroke-dasharray'
                )
                  delete scope.graphic.Mark.Stroke.CssParameter[ind];
              }
            }
          }
        };

        scope.$watch('graphic.noColorFill', function(cf) {
          scope.changeFillType();
        });

        //scope.component.noColorFill = false ;
        scope.changeFillType = function() {
          if (scope.graphic.noColorFill == 'true') {
            scope.graphic.noColorFill = true;
          }
          if (
            scope.graphic.noColorFill == true ||
            scope.graphic.noColorFill == 'true'
          ) {
            delete scope.graphic.Mark.Fill;
          } else {
            if (
              angular.isDefined(scope.graphic.Mark) &&
              !angular.isDefined(scope.graphic.Mark.Fill)
            ) {
              scope.graphic.Mark.Fill = {
                CssParameter: [
                  {
                    _name: 'fill',
                    __text: '#000000',
                  },
                ],
              };
            }
          }
        };

        /*scope.wellKnownNames = [
                    { key : 'circle',   label : 'circle'},
                    { key : 'square',   label : 'square'},
                    { key : 'triangle', label : 'triangle'},
                    { key : 'star',     label : 'star'},
                    { key : 'cross',    label : 'cross'},
                    { key : 'x',        label : 'x'},
                ];*/

        scope.availableSymbols = [
          {
            key: 'square',
            sld: sldUtils.getSimplePointSymbol('square'),
          },
          {
            key: 'circle',
            sld: sldUtils.getSimplePointSymbol('circle'),
          },
          {
            key: 'triangle',
            sld: sldUtils.getSimplePointSymbol('triangle'),
          },
          { key: 'star', sld: sldUtils.getSimplePointSymbol('star') },
          {
            key: 'cross',
            sld: sldUtils.getSimplePointSymbol('cross'),
          },
          { key: 'x', sld: sldUtils.getSimplePointSymbol('x') },
          {
            key: 'shape://oarrow',
            sld: sldUtils.getSimplePointSymbol('shape://oarrow'),
          },
          {
            key: 'shape://carrow',
            sld: sldUtils.getSimplePointSymbol('shape://carrow'),
          },
        ];

        if (scope.distance) {
          console.log('distance');
          // distance
          //var distance = scope.distance.CssParameter.__text.split(' ');
          var distance = scope.distance.CssParameter[0].__text.split(' ');
          distance = distance.length == 2 ? parseInt(distance[1], 10) : 0;
          scope.position = {
            size: parseInt(scope.graphic.Size, 10),
            distance: distance,
          };

          scope.$watch('position.distance', function(distance) {
            if (angular.isNumber(distance)) {
              // wont work if multiple css parameters, careful
              scope.distance.CssParameter[0].__text =
                scope.position.size + ' ' + distance;
            }
          });
        }
      },
    };
  };

  sldsimplepointsymbolizer.$inject = ['sldUtils', '$filter'];
  return sldsimplepointsymbolizer;
});
