'use strict';
define(function() {
  var sldpointsymbolizer = function(sldUtils, StyleFactory, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/symbolizer/sldpointsymbolizer.html',
      restrict: 'A',
      scope: {
        component: '=component',
        fti: '=fti',
      },
      link: function(scope, elt, attrs, ctrl) {
        // Simple point or image/font ?
        scope.pointType = sldUtils.getSubTypeOfSymbolizer(
          'POINT',
          scope.component
        );

        if (scope.pointType == 'point-simple') {
          // sldsimplepointsymbolizer.js
        }

        if (scope.pointType == 'point-image') {
          // sldimagesymbolizer
        }

        // font
        if (scope.pointType == 'point-font') {
          var tmpFontInfo = scope.component.Graphic.Mark.WellKnownName.split(
            '#'
          );

          scope.currentFont = {
            font: tmpFontInfo[0].replace('ttf://', ''),
            char: tmpFontInfo[1],
          };

          scope.picked = {};
          scope.fontdata = {};
          scope.$watch(
            'picked',
            function(pickedFont) {
              if (scope.picked.value) {
                scope.setFontChar(scope.picked.value);
              }
            },
            1
          );

          scope.setFontWellKnownName = function() {
            /*if(scope.fontdata.name!=null){
                            var correct_font_name = scope.fontdata.name;
                        }else{*/
            //var correct_font_name = scope.currentFont.font.charAt(0).toUpperCase() + scope.currentFont.font.slice(1);
            /*}*/

            scope.component.Graphic.Mark.WellKnownName =
              'ttf://' + scope.currentFont.font + '#' + scope.currentFont.char;
          };

          scope.setFontChar = function(char) {
            scope.currentFont.char = char;
            scope.setFontWellKnownName();
          };

          // retrieve the fonts from the server
          scope.fontsList = [];

          StyleFactory.gettf().then(
            function(res) {
              if (res.data == 'no_font')
                require('toastr').error(
                  $filter('translate')('model.styles.no_font_available')
                );
              else
                for (var na in res.data) {
                  var fontname = res.data[na];
                  scope.fontsList.push({
                    key: fontname,
                    label: fontname,
                  });
                }
            },
            function(res) {
              if (res.status == 500) {
                var mess;
                mess = $filter('translate')('model.styles.server_error');
                mess += res.data;
                require('toastr').error(mess);
              }
            }
          );
        }
      },
    };
  };

  sldpointsymbolizer.$inject = ['sldUtils', 'StyleFactory', '$filter'];
  return sldpointsymbolizer;
});
