/*global define */
define(['angular'], function(angular) {
  'use strict';

  var sldlegend = function($interval, sldUtils, DataStoreFactory) {
    var x2js = sldUtils.x2js;

    return {
      templateUrl: 'js/XG/widgets/mapapp/style/views/sldlegend.html',
      restrict: 'E',
      replace: true,
      scope: {
        height: '@',
        width: '@',
        data: '=',
        update: '=',
        dataissld: '@',
        symbolizerName: '='
      },
      link: function(scope, elt) {
        var changed = true;

        // console.log(scope.data);
        scope.height = scope.height || '20px';
        scope.width = scope.width || '20px';
        scope.dataissld = !!scope.dataissld;

        /**
         *     Vérifie qu'il y a au moins un symbole dans
         * la symbologie définie par le paramètre data.
         *
         * @param {[[type]]} data [[Description]]
         * @param {[[type]]} symbs [[Description]]
         * @return {[[type]]} [[Description]]
         */
        function hasSymb(data, symbs) {
          var iSymb, curSymb;
          for (iSymb = 0; iSymb < symbs.length; iSymb++) {
            curSymb = symbs[iSymb];
            if (data[curSymb]) {
              if (data[curSymb].push != undefined) {
                if (data[curSymb].length != 0) {
                  return true;
                }
              } else {
                return true;
              }
            }
          }
          return false;
        }
        /**
         *    Tant que le XML de la symbologie est trop long
         * pour être géré par GeoServer et qu'il y a des symboles
         * on allège la symbologie afin d'obtenir une légende
         * même tronquée.
         *
         * @param {[[type]]} data [[Description]]
         */
        function getXmlForSymbolizers(data) {
          var symbolizers, dataw, iSymb, curSymb;
          var symbs = [
            'PointSymbolizer',
            'LineSymbolizer',
            'PolygonSymbolizer',
          ];
          for (iSymb = 0; iSymb < symbs.length; iSymb++) {
            if (data[symbs[iSymb]]) break;
          }
          if (iSymb == symbs.length) dataw = data[0];
          else dataw = data;
          symbolizers = Array.isArray(dataw)
            ? dataw.map(x2js.json2xml_str).join('')
            : x2js.json2xml_str(dataw);

          //-- Tant que le XML de la symbologie est trop long.
          while (symbolizers.length > 2000 && hasSymb(dataw, symbs)) {
            //-- Enlever un symbole.
            for (iSymb = 0; iSymb < symbs.length; iSymb++) {
              curSymb = symbs[iSymb];
              if (dataw[curSymb]) {
                if (dataw[curSymb].push != undefined) {
                  if (dataw[curSymb].length != 0) {
                    dataw[curSymb].splice(dataw[curSymb].length - 1, 1);
                    //-- Un symbolizer enlevé =>
                    //-- il faut essayer la généation du xml.
                    if (dataw[curSymb].length == 0) delete dataw[curSymb];
                    break;
                  }
                } else {
                  delete dataw[curSymb];
                  //-- Un symbolizer enlevé =>
                  //-- il faut essayer la généation du xml.
                  break;
                }
              }
            }
            symbolizers = Array.isArray(dataw)
              ? dataw.map(x2js.json2xml_str).join('')
              : x2js.json2xml_str(dataw);
          }

          return symbolizers;
        }

        /*
         * Get the GeoServer GetLegendGraphic
         */
        var generateUrl = function() {
          if (!scope.data || !changed) {
            return false;
          }

          var data = {};
          if (scope.symbolizerName) {
            data[scope.symbolizerName] = scope.data;
          } else {
            data = scope.data;
          }
          data = angular.copy(data); // Strip $$hashKey

          var xml = data;
          if (!scope.dataissld) {
            // if the object passed into data is json
            sldUtils.cleanSLD(data);
            var symbolizers = getXmlForSymbolizers(data);

            xml =
              '<?xml version="1.0" encoding="UTF-8"?>' +
              '<StyledLayerDescriptor>' +
              '<NamedLayer><UserStyle>' +
              '<FeatureTypeStyle>' +
              '<Rule>' +
              symbolizers +
              '</Rule>' +
              '</FeatureTypeStyle>' +
              '</UserStyle></NamedLayer>' +
              '</StyledLayerDescriptor>';

            // console.log(xml);
          }

          /*
                    scope.legendUrl = '/geoserver/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0'
                        + '&FORMAT=image/png&LAYER=topp:states&TRANSPARENT=true'
                        + '&WIDTH=' + parseInt(scope.width, 10)
                        + '&HEIGHT=' + parseInt(scope.height, 10)
                        + '&SLD_BODY='+encodeURIComponent(xml);

*/
          if(DataStoreFactory.resources.datastores.length === 0) {
            get(localStorage.getItem('portal')).then(
                () => {
                  defineLegendUrl(data, xml,
                      DataStoreFactory.resources.datastores
                      .some(ds=> ds.type === 'ArcGis'));
                });
          } else {
            defineLegendUrl(data, xml,
                DataStoreFactory.resources.datastores
                .some(ds=> ds.type === 'ArcGis'));
          }

        }

        /**
         * Définie l'url de l'image à renvoyer selon que l'on soit sur un portail arcgis
         */
        const defineLegendUrl = (data, xml, esriExists) => {
          // Dans le cas d'un serveur arcgis, pas de geoserver,
          // Les icones sont placées dans le dossier kisreb du front
          if (esriExists) {
            scope.legendUrl = '/kis/geoserver/styles/kis/common/images/annotations/'
                + data.PointSymbolizer[0].Graphic.Mark.WellKnownName.replace(/^shape:\/\//, '')
                + '.png';
          } else {
            scope.legendUrl =
                '/services/' +
                localStorage.getItem('portal') +
                '/printLegend' +
                '/getLegendGraphic?LAYER=topp:states' +
                '&TRANSPARENT=true' +
                '&WIDTH=' +
                parseInt(scope.width, 10) +
                '&HEIGHT=' +
                parseInt(scope.height, 10) +
                '&SLD_BODY=' +
                encodeURIComponent(xml) +
                '&token=' +
                localStorage.auth_token;
            changed = false;
          }
        }

        // get the img url
        generateUrl();

        // ---- ONLY IF scope.update == true ----
        if (scope.update) {
          changed = false;
          // check for changes every 100ms only
          var spinner = $interval(generateUrl, 100);

          // Stop the interval when the directive is destroyed
          elt.on('$destroy', function() {
            $interval.cancel(spinner);
          });

          scope.$watch(
            'data',
            function() {
              changed = true;
            },
            1
          );
        }
      },
    };
  };

  sldlegend.$inject = ['$interval', 'sldUtils', 'DataStoreFactory'];
  return sldlegend;
});
