'use strict';
define(function() {
  let sldfilter = function($timeout, QueryFactory, $filter) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/style/views/sldfilter.html',
      restrict: 'E',
      replace: true,
      scope: true,
      link: function(scope,elt,attrs) {

        /**
         * Supprime un critère de filtre d'une règle sld
         * Dans le cas d'un filtre multi-critère, supprime le critère du tableau de critères
         */
        scope.removeFilter = () => {
          if ('groupIndex' in scope && scope.isMultiCriteria) {
            const groupType = Object.keys(
                scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator])[scope.groupIndex];
            scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator][groupType].splice(
                scope.$index, 1);
            // supprime le groupe de critères s'il est vide
            if (scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator][groupType].length === 0) {
              delete scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator][groupType];
            }
            //-- Le ng-if qui dépend de la valeur de "selectSymbol.show"
            //-- permet de reconstruire les éléments de la liste des filtres.
            //-- Sans cela elle n'est pas rafraichi à cause du ng-if d'un des parents du DOM.
            scope.selectSymbol.show = false;
            $timeout(() => {
              scope.selectSymbol.show = true;
            });
          } else {
            eval("scope." + attrs.removeFilter.replace("$index", "scope.$index"));
          }
        };

        scope.criteriaTemplate = {};
        scope.criteriaTemplate.comparison = {
          showValue: true,
          between: false,
          showLikeHelp: false,
        };

        /**
         * Au changement du select du type d'un critère de filtre de règle sld.<ul><li>
         * Affiche/masque les champs liés au type de critère.</li><li>
         * Déplace le critère depuis le tableau de critères de l'ancien type vers le tableau de critères du nouveau type</li></ul>
         * Remplace le vieux watcher existant qui s'exécutait au démarrage de manière indésirée
         */
        scope.onFilterTypeChange = () => {

          changeCriteriaDisplayByType(scope.currentFilter.type);

          const tmp = {};
          tmp[scope.currentFilter.type] = scope.currentFilter.data;
          scope.newFilter = tmp;

          if ('groupIndex' in scope && scope.isMultiCriteria) {
            // remplacement d'un filtre multi-critères
            changeMultiCriteriasFilter(scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator],
                scope.currentFilter.type, scope.groupIndex, scope.$index);

            //-- permet de reconstruire les éléments de la liste des filtres.
            //-- Sans cela elle n'est rafraichi qu'à cause du ng-if d'un des parents du DOM.
            scope.selectSymbol.show = false;
            $timeout(() => {
              scope.selectEditComponent('wait-refresh');
              $timeout(() => {
                scope.selectEditComponent({rule:scope.selectedComponent.index});
              });
            });
          } else {
            // remplacement d'un fitre à critère unique
            eval("scope." + attrs.changeFilter.replace("$index", "scope.$index"));
          }
        };

        scope.listOfComparisonOperators = [
          {
            name: 'model.styles.editor.filter.types.comparison.title',
            list: [
              {
                key: 'PropertyIsEqualTo',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsEqualTo',
              },
              {
                key: 'PropertyIsNotEqualTo',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsNotEqualTo',
              },
              {
                key: 'PropertyIsLessThan',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsLessThan',
              },
              {
                key: 'PropertyIsLessThanOrEqualTo',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsLessThanOrEqualTo',
              },
              {
                key: 'PropertyIsGreaterThan',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsGreaterThan',
              },
              {
                key: 'PropertyIsGreaterThanOrEqualTo',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsGreaterThanOrEqualTo',
              },
              {
                key: 'PropertyIsLike',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsLike',
              },
              {
                key: 'PropertyIsNull',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsNull',
              },
              {
                key: 'PropertyIsBetween',
                label:
                  'model.styles.editor.filter.types.comparison.list.PropertyIsBetween',
              },
            ],
          }
        ];

        /**
         * Modifie l'affichage du critère de filtre suivant le type du critère
         * @param criteriaType type du critère de filtre (ex. "PropertyIsEqualTo", "PropertyIsNotEqualTo"...)
         */
        const changeCriteriaDisplayByType = (criteriaType) => {
          if (!Array.isArray(scope.attributeValues) || (Array.isArray(scope.attributeValues) && scope.attributeValues.length > 0)){
            scope.currentFilter.noValues = true;
          }
          scope.criteriaTemplate.comparison = {
            showValue: true,
            between: false,
            showLikeHelp: false,
          };

          if (criteriaType === 'PropertyIsNull') {
            delete scope.currentFilter.data.Literal;
            scope.criteriaTemplate.comparison.showValue = false;
          }

          if (criteriaType === 'PropertyIsBetween') {
            delete scope.currentFilter.data.Literal;
            if(!scope.currentFilter.data.hasOwnProperty('LowerBoundary')
                || typeof scope.currentFilter.data.LowerBoundary !== 'object'
                || scope.currentFilter.data.LowerBoundary === null) {
              scope.currentFilter.data.LowerBoundary = {Literal:''};
            }
            if(!scope.currentFilter.data.hasOwnProperty('UpperBoundary')
                || typeof scope.currentFilter.data.UpperBoundary !== 'object'
                || scope.currentFilter.data.UpperBoundary === null) {
              scope.currentFilter.data.UpperBoundary = {Literal:''};
            }
            scope.criteriaTemplate.comparison.showValue = false;
            scope.criteriaTemplate.comparison.between = true;
          }

          if (criteriaType === 'PropertyIsLike') {
            scope.criteriaTemplate.comparison.showLikeHelp = true;
          }

          if (criteriaType !== 'PropertyIsBetween') {
            if (scope.currentFilter.data.LowerBoundary) {
              delete scope.currentFilter.data.LowerBoundary;
            }
            if (scope.currentFilter.data.UpperBoundary) {
              delete scope.currentFilter.data.UpperBoundary;
            }
          }
        };

        /**
         * Change le type d'un critère de filtre d'une règle sld.<br>
         * Changer le type implique de déplacer le critère d'un tableau de critères à un autre:<br>
         * <code>And:{propertyEqualsTo:[critèreX],propertyIsLessThan:[]} => And:{propertyEqualsTo:[],propertyIsLessThan:[critèreX]}</code>
         * @param {object} filterCriterias valeur de l'objet ayant pour clé l'opérateur logique du filtre multi-critère.
         * Paramètre correspondant à l'objet <code>scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator]</code>
         * @param {string} newCriteriaType clé de l'objet contenant le tableau de critères cible qui va recevoir le critère déplacé
         * @param {number} groupIndex rang de la clé de l'objet contenant le tableau de critères source dans l'objet <code>filterCriterias</code>
         * @param {number} criteriaIndex rang du critère dans le tableau de critères source
         */
        const changeMultiCriteriasFilter = (filterCriterias, newCriteriaType, groupIndex,
            criteriaIndex) => {

          // détermine la clé du groupe de critères source d'après le rang de la clé dans l'objet
          const oldCriteriaType = Object.keys(filterCriterias)[groupIndex];

          if (oldCriteriaType) {
            // supprime le critère dans le groupe source
            filterCriterias[oldCriteriaType].splice(criteriaIndex, 1);

            // créé le groupe de critères de destination s'il n'existe pas
            if (!Array.isArray(filterCriterias[newCriteriaType])) {
              filterCriterias[newCriteriaType] = [];
            }
            // insère le critère dans le groupe de critères de destination
            filterCriterias[newCriteriaType].push(scope.newFilter[newCriteriaType]);

            // supprime le groupe de critères s'il est vide
            if (filterCriterias[oldCriteriaType].length === 0) {
              delete filterCriterias[oldCriteriaType];
            }
          }
        };

        const dateTypes =  ['java.util.Date', 'java.sql.Timestamp', 'java.sql.Time', 'java.sql.Date'];

        /**
         * Au changement d'attribut du filtre.
         * Désactive le select des valeurse
         */
        scope.onAttributeChange = () => {
          scope.currentFilter.noValues = true;
          const isAttributeDateType = dateTypes.includes(getAttributeType());
          if ((scope.currentFilter.data.PropertyName !== 'fid') && isAttributeDateType) {
            scope.currentAttributeIsDate = true;
          }
          if (scope.criteriaTemplate.comparison.showValue) {
            scope.currentFilter.data.Literal = '';
          }
          if (Array.isArray(scope.attributeValues)) {
            scope.attributeValues.splice(0, scope.attributeValues.length);
          } else {
            scope.attributeValues = [];
          }
          // KIS-3270: réinitialise la saisie d'une valeur d'attribut
          if (Array.isArray(scope.currentFilter.data.customAttValues)) {
            scope.currentFilter.data.customAttValues = null;
          }
          scope.attributeValueEditMode = {};
        };

        /**
         *
         */
        scope.searchAttributeValues = () => {
          scope.isSearchingValues = true;
          QueryFactory.dataattribute(scope.fti.uid, scope.currentFilter.data.PropertyName).then(
              res => {
                if (Array.isArray(res.data)) {
                  if (res.data.length === 0 || (res.data.length === 1 && res.data[0] === '')) {
                    require('toastr').info(
                        $filter('translate')('model.featuretypes.attributes.no_values')
                    );
                  } else {
                    if (!Array.isArray(scope.attributeValues)) {
                      scope.attributeValues = [];
                    }
                    for (const attValue of res.data) {
                      // KIS-3270: Le paramétrage d’un style avec filtre ne propose pas la liste des valeurs en base
                      // pour les champs dont le type n’est pas “Chaine de caractères”
                      if (scope.currentAttributeIsDate) {
                        scope.attributeValues.push(formatDate(attValue));
                      } else if (typeof attValue === 'string' && attValue !== '') {
                        scope.attributeValues.push({label: attValue, value: attValue});
                      } else if (typeof attValue === 'number') {
                        scope.attributeValues.push({label: attValue, value: attValue});
                      }
                    }
                    if (scope.attributeValues.length > 0) {
                      if (scope.criteriaTemplate.comparison.showValue) {
                        scope.currentFilter.data.Literal = '';
                      } else if (scope.criteriaTemplate.comparison.between){
                        scope.currentFilter.data.LowerBoundary.Literal = '';
                        scope.currentFilter.data.UpperBoundary.Literal = '';
                      }
                      scope.currentFilter.noValues = false;
                    }
                  }
                }
              }).finally(() => {
                scope.isSearchingValues = false;
          });
        };

        const formatDate = (attValue) => {
          const d = new Date(attValue);
          // valid date
          if (d.getTime() > 0) {
            return {
              label:
              d.getFullYear() +
              '/' +
              (d.getMonth() + 1) +
              '/' +
              d.getDate(),
              value: d.toISOString()
            }
          }
        };

        const getAttributeType = () => {
          const attribute = scope.fti.attributes.find(attr => attr.name === scope.currentFilter.data.PropertyName);
          if (attribute) {
            return attribute.type;
          } else {
            return 'java.lang.String';
          }
        };

        /**
         * Au clic sur le bouton de saisie d'une valeur d'attribut par l'utilisateur:<ul><li>
         *   remplace l'autocomplete qui lag par un input</li><li>
         *   remplace le bouton "Saisie" (stylo) par le bouton "Valider" (check)</li></ul>
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3270">KIS-3270: [BEZIERS -
         * ADMIN STYLE] La recherche de valeur sur le filtre d'un style personnalisé</a>
         * @param {string} inputType catégorie de la propriété:
         * "showValue" par défaut, "low" ou "up" lorsque le type de filtre est "propriété comprise entre valeur 1 et valeur 2"
         */
        scope.toggleAttributeValueEditMode = (inputType) => {
          if (!scope.attributeValueEditMode) {
            scope.attributeValueEditMode = {};
          }
          if (!scope.attributeValueEditMode[inputType] || !scope.attributeValueEditMode[inputType].open) {
            // ouverture du mode édition (dont la 1ère initialisation)
            scope.attributeValueEditMode[inputType] = {
              open: true,
              change: false
            };
          } else {
            // fermeture du mode édition
            scope.attributeValueEditMode[inputType] = {
              open: !scope.attributeValueEditMode[inputType].open,
              change: false
            };
          }
        };

        /**
         * Ajoute la valeur saisie par l'utilisateur dans la liste des valeurs d'attributs de l'autocomplete.<br>
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3270">KIS-3270: [BEZIERS -
         * ADMIN STYLE] La recherche de valeur sur le filtre d'un style personnalisé</a>
         * @param {string|null} inputType paramètre non null lorsque le type de filtre est "propriété comprise entre valeur 1 et valeur 2"
         */
        scope.addCustomAttributeValue = (inputType = null) => {

          // récupère la valeur saisie
          let customValue;
          if (scope.criteriaTemplate.comparison.between && typeof inputType === 'string') {
            customValue = scope.currentFilter.data[inputType === 'low' ? 'LowerBoundary' : 'UpperBoundary'].Literal;
          } else {
            customValue = scope.currentFilter.data.Literal;
            inputType = 'uniqueValue';
          }

          // ajoute la valeur saisie à la liste des valeurs d'attributs issue de la base
          if (scope.attributeValueEditMode[inputType].change) {
            if (!Array.isArray(scope.attributeValues)) {
              scope.attributeValues = [];
            }
            if (!scope.attributeValues.includes(customValue)) {
              scope.attributeValues.push({label: customValue, value: customValue});
            }
          }

          // remplace l'input par un autocomplete et le bouton "check" par le bouton "saisie"
          scope.toggleAttributeValueEditMode(inputType);
        };

        /**
         * Vérifie si une nouvelle valeur a été saisie dans l'input de l'attribut du filtre
         * @param {string} inputType type de la propriété ("showValue" par défaut, "low"/"up" pour un critère between)
         * @param {*} oldValue ancienne valeur avant l'évènement onChange déclenché appelant
         */
        scope.onCustomAttributeValueChange = (inputType, oldValue) => {

          // récupère la nouvelle valeur
          let currentValue;
          if (scope.criteriaTemplate.comparison.between && typeof inputType === 'string') {
            currentValue = scope.currentFilter.data[inputType === 'low' ? 'LowerBoundary' : 'UpperBoundary'].Literal;
          } else {
            currentValue = scope.currentFilter.data.Literal;
            inputType = 'uniqueValue';
          }
          // compare oldvalue == newValue (sans tenir compte du type à cause de l'interpolation string de oldvalue)
          scope.attributeValueEditMode[inputType].change = currentValue != oldValue;
        };


        /**
         * INITIALISATION
         */

        // scope.groupIndex existe uniquement pour un filtre multi-critère (cf. unique_tpl.html)
        scope.isMultiCriteria = 'groupIndex' in scope && Number.isInteger(scope.groupIndex);

        if (scope.isMultiCriteria) {
          scope.currentFilter = {
            type: Object.keys(scope.selectSymbol.rule.Filter[0][scope.filterRuleOperator])[scope.groupIndex],
            data: scope.filter
          };
        } else {
          scope.currentFilter = {
            type: Object.keys(scope.filter)[0],
            data: scope.filter[Object.keys(scope.filter)[0]],
          };
        }

        // affiche/masque les inputs/selects de chaque critère suivant son type respectif
        changeCriteriaDisplayByType(scope.currentFilter.type);
      },
    };
  };

  sldfilter.$inject = ['$timeout', 'QueryFactory', '$filter'];
  return sldfilter;
});
