'use strict';
define(function() {
  var radiusattributepicker = function($timeout) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/radiusattributepicker.html',
      restrict: 'EA',
      scope: {
        degree: '=degree',
        fti: '=fti',
      },
      link: function(scope, elt, attrs, ctrl) {
        if (angular.isUndefined(scope.degree)) scope.degree = 0;
        scope.innerdegree = { v: scope.degree };
        if (scope.degree.hasOwnProperty('PropertyName')) {
          scope.picked = scope.degree.PropertyName;
        } else {
          scope.picked = 'degrees';
        }

        scope.pickerChoices = [
          {
            key: 'degrees',
            label: 'model.styles.editor.symbolizers.common.angle',
          },
        ];
        if (scope.fti)
          for (var i in scope.fti.attributes) {
            var att = scope.fti.attributes[i];
            scope.pickerChoices.push({
              key: att.name,
              label: att.alias,
            });
          }

        var saveAngle = 0;
        scope.$watch('picked', function(picked, prev) {
          if (picked == prev) return;

          if (picked != 'degrees') {
            saveAngle = scope.degree;
            scope.degree = { PropertyName: picked };
          }
          if (picked == 'degrees') {
            scope.degree = saveAngle;
          }
        });

        scope.$watch('innerdegree.v', function(d) {
          scope.degree = d;
        });
      },
    };
  };

  radiusattributepicker.$inject = ['$timeout'];
  return radiusattributepicker;
});
