'use strict';
define(function() {
  var palettelibrary = function() {
    return {
      templateUrl: 'js/XG/widgets/mapapp/style/views/palettelibrary.html',
      restrict: 'A',
      scope: {
        selectedpalette: '=',
        closePalette: "="
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.palettes = [
          {
            id: 'hsv_rainbow1',
            scheme: 'rainbow',
            nb: 50,
            extra: [],
          },
          {
            id: 'hsv_rainbow2',
            scheme: 'rainbow',
            nb: 50,
            extra: [0.5],
          },
          {
            id: 'hsv_rainbow3',
            scheme: 'rainbow',
            nb: 50,
            extra: [1, 0.5],
          },
          {
            id: 'hsv_rainbow4',
            scheme: 'rainbow',
            nb: 50,
            extra: [0.5, 0.5],
          },
          {
            id: 'lemon',
            func: 'lemon',
            nb: 50,
          },
          {
            id: 'red',
            func: 'red',
            nb: 50,
          },
          {
            id: 'sky',
            func: 'sky',
            nb: 50,
          },
          {
            id: 'orange',
            func: 'orange',
            nb: 50,
          },

          {
            id: 'lagoon',
            func: 'lagoon',
            nb: 50,
          },
        ];
        scope.palettescbf = [
          {
            id: 'tol-dv',
            nb: 50,
          },
          {
            id: 'tol-sq',
            nb: 50,
          },
          {
            id: 'tol-rainbow',
            nb: 50,
          },
        ];

        scope.selectPalette = function(palette) {
          scope.selectedpalette = palette;
          scope.closePalette();
        };
      },
    };
  };

  palettelibrary.$inject = [];
  return palettelibrary;
});
