'use strict';
define(function() {
  var toolbarstreetview = function(GoogleMapsFactory, $timeout, $rootScope) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/streetview/views/toolbarstreetview.html',
      restrict: 'A',
      link: function(scope, element, attrs, ctrl) {
        var m = scope.map,
          marker = null,
          panorama = false,
          mapdiv = angular
            .element(document)
            .find('#map')
            .eq(0);

        // Detecting mouse direction in order to change the streetview icon orientation
        // TODO: Move it into a service
        var oldx = 0,
          mousemovemethod = function(e) {
            if (Math.abs(e.pageX - oldx) > 1) {
              mapdiv.removeClass('streetViewCursorLeft streetViewCursorRight');
              if (e.pageX <= oldx) {
                mapdiv.addClass('streetViewCursorLeft');
              } else if (e.pageX > oldx) {
                mapdiv.addClass('streetViewCursorRight');
              }
            }
            oldx = e.pageX;
          };

        var btnElt = $(element.children()[0]);

        /**
         * disabled the widget
         * when icon is clicked or panel is closed
         */
        var disableStreetView = function() {
          mapdiv.removeClass('streetViewCursorLeft streetViewCursorRight');
          document.removeEventListener('mousemove', mousemovemethod);
          btnElt.addClass('btn-default');
          scope.isActive = false;
          scope.panelsManager.removePanel('streetView');
          removeMarker();
          scope.isActive = false;
          btnElt.removeClass('btn-info');
        };

        /* Click on the GoogleStreetView toolbar button*/
        btnElt.bind('click', function() {
          panorama = false;

          btnElt.removeClass('btn-info btn-default');
          if (scope.isActive) {
            disableStreetView();
          } else {
            btnElt.addClass('btn-info');

            GoogleMapsFactory.lazyLoad().then(function() {
              scope.panelsManager.addPanel({
                id: 'streetView',
                stickToRight: true,
                templateUrl:
                  'js/XG/widgets/mapapp/streetview/views/streetview.html',
                scope: scope,
                stickToBorder: true,
                visible: false,
                resizable: true,
              });

              document.addEventListener('mousemove', mousemovemethod);

              scope.isActive = true;
            });
          }
        });

        scope.$on('closeToolsBar_toolbarstreetview', function(event) {
          disableStreetView();
          scope.isActive = false;
        });

        /**
         * Center the map on the GoogleStreeview Marker
         * @param coordinates
         */
        function centerMapOnGswMarker(coordinates) {
          var view = m.getView();
          /*var pan = ol.animation.pan({
                        duration: 500,
                        source: (view.getCenter())
                    });
                    m.beforeRender(pan);*/
          view.animate({
            duration: 500,
            source: view.getCenter(),
          });
          view.setCenter([coordinates[0], coordinates[1]]);
        }

        /**
         * Move the gsw marker and set its orientation
         * @param evt
         */
        function move_marker(evt) {
          if (!marker) return;

          // set the marker new geometry
          if (evt.coordinate) {
            marker.f.setGeometry(
              new ol.geom.Point([evt.coordinate[0], evt.coordinate[1]])
            );
            centerMapOnGswMarker(evt.coordinate);
          }

          // set the marker orientation
          if (evt.pov) {
            var defautStyle = 9;
            if (evt.pov.heading > 157.5) {
              defautStyle = 9;
            } else if (evt.pov.heading > 112.5) {
              defautStyle = 7;
            } else if (evt.pov.heading > 67.5) {
              defautStyle = 5;
            } else if (evt.pov.heading > 22.5) {
              defautStyle = 3;
            } else if (evt.pov.heading > -22.5) {
              defautStyle = 2;
            } else if (evt.pov.heading > -67.5) {
              defautStyle = 15;
            } else if (evt.pov.heading > -112.5) {
              defautStyle = 13;
            } else if (evt.pov.heading > -157.5) {
              defautStyle = 10;
            }

            marker.l.setStyle(marker.styles[defautStyle]);
          }
        }

        /**
         * Create the gmap marker
         * @param coordinates
         */
        function create_marker(evt) {
          if (marker) {
            move_marker(evt);
            return;
          }

          var vectorSource = new ol.source.Vector({}),
            iconFeature = new ol.Feature({
              geometry: new ol.geom.Point([
                evt.coordinate[0],
                evt.coordinate[1],
              ]),
              name: 'Gsmap',
            });
          vectorSource.addFeature(iconFeature);

          //create the style
          var styles = [];
          for (var i = 0; i < 22; i++) {
            var num = i < 10 ? '0' + i : i;
            styles[i] = new ol.style.Style({
              image: new ol.style.Icon({
                anchor: [0.5, 46],
                anchorXUnits: 'fraction',
                anchorYUnits: 'pixels',
                opacity: 0.75,
                src: 'img/widget/gsw/gsw_' + num + '.png',
              }),
            });
          }

          //add the feature vector to the layer vector, and apply a style to whole layer
          var vectorLayer = new ol.layer.Vector({
            source: vectorSource,
            style: styles[21],
          });

          m.addLayer(vectorLayer);
          marker = {
            l: vectorLayer,
            f: iconFeature,
            styles: styles,
          };
        }

        /**
         * Remove the gsw marker
         */
        function removeMarker() {
          if (marker !== null) {
            m.removeLayer(marker.l);
            marker = null;
          }
        }

        /**
         * set streetview panel
         * @param panoramaPos
         */
        function setSW(panoramaPos) {
          if (panorama) {
            panorama.setPosition(panoramaPos);
            /*google.maps.event.trigger(panorama, 'resize');*/
          } else {
            scope.panelsManager.showPanel('streetView');
            panorama = new google.maps.StreetViewPanorama(
              document.getElementById('map-canvas'),
              {
                position: panoramaPos,
                pov: {
                  heading: 0,
                  pitch: 0,
                },
              }
            );

            google.maps.event.addListener(panorama, 'pano_changed', function() {
              var latlng = panorama.getPosition();
              move_marker({
                coordinate: GoogleMapsFactory.latLngTocoordinates(
                  {
                    lng: latlng.lng(),
                    lat: latlng.lat(),
                  },
                  m.getView().getProjection()
                ),
                pov: panorama.getPov(),
              });
            });
            google.maps.event.addListener(panorama, 'pov_changed', function() {
              move_marker({
                pov: panorama.getPov(),
              });
            });
          }

          var latlng = panorama.getPosition();
          move_marker({
            coordinate: GoogleMapsFactory.latLngTocoordinates(
              { lng: latlng.lng(), lat: latlng.lat() },
              m.getView().getProjection()
            ),
            pov: panorama.getPov(),
          });
        }

        $rootScope.$on('elementResized', function(event, args) {
          if (args.element.type == 'panel' && args.element.id == 'streetView') {
            google.maps.event.trigger(panorama, 'resize');
          }
        });

        /**
         * close the panel via close icon
         */
        scope.closeStreetviewPanel = function() {
          disableStreetView();
        };

        function tryDist(dist, pos) {
          if (dist > 50000) {
            require('toastr').error(
              'No panorama for this position (5km radius)'
            );
            return;
          }

          new google.maps.StreetViewService().getPanoramaByLocation(
            pos,
            dist,
            function(data, status) {
              console.log(data);
              if (status == 'OK') {
                console.log(data.location.latLng);
                setSW(data.location.latLng);
              } else {
                console.log(
                  'No panorama for this position (' + dist + ' meters)'
                );
                //require('toastr').warning('No panorama for this position ('+dist+' meters)');
                tryDist(dist * 10, pos);
              }
            }
          );
        }

        /**
         * Load the google Street View Panel
         * @param evt
         */
        function gsw(evt) {
          var panoramaPos = GoogleMapsFactory.coordinatesToLatLng(
            evt.coordinate,
            m.getView().getProjection()
          );
          tryDist(50, panoramaPos);
        }

        /**
         * Handle the click on the map when the gsw toolbar is active
         */
        m.on('singleclick', function(evt) {
          if (!scope.isActive) return;
          create_marker(evt);
          mapdiv.removeClass('streetViewCursorLeft streetViewCursorRight');
          document.removeEventListener('mousemove', mousemovemethod);

          GoogleMapsFactory.lazyLoad().then(function() {
            gsw(evt);
          });
        });
      },
    };
  };

  toolbarstreetview.$inject = ['GoogleMapsFactory', '$timeout', '$rootScope'];
  return toolbarstreetview;
});
