'use strict';
define(function() {
  var toolbarselecttool = function(
    gcStyleFactory,
    $http,
    SelectManager,
    gclayers,
    gcPopup,
    $filter,
    gcRestrictionProvider,
    gcInteractions,
    $rootScope,
    gaJsUtils,
    ogcFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selecttoolbyline/views/toolbarselecttool.html',

      restrict: 'AE',

      link: function(scope, element) {
        scope.pop = null;
        scope.isActive = false;
        scope.altKeyPressed = false;
        var map = scope.map;
        //                var btnElt = $(element.children()[0]);
        var btnElt = $(element[0]);
        scope.$on('closeToolsBar_toolbarselecttoolbyline', () => {
          if (scope.drawinteractByLine.getActive()) {
            deactivate();
          }
        });
        btnElt.bind('click', () => {
          if (
            !scope.drawinteractByLine &&
            gclayers.getDrawLayer() instanceof ol.layer.Vector
          )
            setInteraction();

          if (scope.drawinteractByLine) {
            if (scope.drawinteractByLine.getActive()) {
              deactivate();
            } else {
              activate();
            }
          }
        });

        const deactivate = () => {
          scope.drawinteractByLine.setActive(false);
          map.removeInteraction(scope.drawinteractByLine);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(undefined);
          }
        }

        const activate = () => {
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.drawinteractByLine.setActive(true);
          map.addInteraction(scope.drawinteractByLine);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn('toolbarselecttoolbyline');
          }
        }

        function setInteraction() {
          scope.drawinteractByLine = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'LineString',
            condition: function(e) {
              //console.log(e.originalEvent.shiftKey);
              scope.altKeyPressed = e.originalEvent.ctrlKey;
              return true; //always return true but need to set whether shift key is pressed or not
            },
          });

          scope.drawinteractByLine.set('gctype', 'kis');
          scope.drawinteractByLine.set('interaction', 'Draw');
          scope.drawinteractByLine.set('widget', 'select');
          scope.drawinteractByLine.setActive(false);
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();

          //map.addInteraction(scope.drawinteractByLine);

          scope.drawinteractByLine.on('drawend', function(evt) {
            var wktObj = new ol.format.WKT();

            //console.log( );
            var wktStr = wktObj.writeGeometry(evt.feature.getGeometry());
            var spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
            //console.log(spatialClause);
            var filter = gclayers.getSelectFilterasStringuid(map);
            if (filter != '') {
              ogcFactory.getfeaturespost(
                spatialClause,
                filter,
                map.getView()
                  .getProjection()
                  .getCode()
                ).then(
                function(res) {
                  if (
                    $rootScope.xgos &&
                    $rootScope.xgos.sector === 'hpo' &&
                    $rootScope.xgos.hpo
                  ) {
                    //require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
                    $rootScope.xgos.hpo.clauseWhere = spatialClause;
                    if (scope.map && scope.map.getView)
                      $rootScope.xgos.hpo.srid = scope.map
                        .getView()
                        .getProjection()
                        .getCode();
                  }

                  gaJsUtils.prepareThingsWhenNewSelection(
                    scope,
                    SelectManager,
                    res
                  );

                  if (res.data.totalFeatures == 0) {
                    gclayers.clearhighLightFeatures();
                    SelectManager.clear();
                    require('toastr').error(
                      $filter('translate')('layermanager.no_selectable_layer')
                    );
                  } else {
                    var newScope = $rootScope.$new();
                    newScope.map = scope.map;
                    newScope.panelsManager = scope.panelsManager;
                    SelectManager.addFeaturesFromGeojson(res.data);
                    var pop = gcPopup.open({
                      scope: newScope,
                      title: 'Informations : ',
                      content: '<div selectfeaturetreewidget></div>',
                      showClose: true,
                      resizable: true,
                      minimizeMaximize: true,
                      className: 'no-default-height',
                      minWidth: 430,
                      onclose: function() {
                        SelectManager.clear();
                      },
                    });
                    gclayers
                      .getDrawLayer()
                      .getSource()
                      .clear();
                    SelectManager.setpop(pop);
                  }
                  gclayers
                    .getDrawLayer()
                    .getSource()
                    .clear();
                },
                function(result) {
                  gcRestrictionProvider.showDetailsErrorMessage(result);
                  if (SelectManager.getpop()) {
                    try {
                      if (SelectManager.getpop().element) {
                        SelectManager.getpop().destroy();
                      }
                      if (SelectManager.getpop().scope) {
                        SelectManager.getpop().scope.$broadcast('$destroy');
                      }
                    } catch (e) {
                      SelectManager.setpop(null);
                    }
                  }
                  gclayers.clearhighLightFeatures();
                  gclayers
                    .getDrawLayer()
                    .getSource()
                    .clear();
                  SelectManager.clear();
                }
              );
            } else {
              gclayers
                .getDrawLayer()
                .getSource()
                .clear();
              map.removeLayer(gclayers.getDrawLayer());
              require('toastr').error(
                $filter('translate')('layermanager.no_selectable_layer')
              );
            }
          });
        }

        if (gclayers.getDrawLayer() instanceof ol.layer.Vector)
          setInteraction();
      },
    };
  };

  toolbarselecttool.$inject = [
    'gcStyleFactory',
    '$http',
    'SelectManager',
    'gclayers',
    'gcPopup',
    '$filter',
    'gcRestrictionProvider',
    'gcInteractions',
    '$rootScope',
    'gaJsUtils',
    'ogcFactory'
  ];
  return toolbarselecttool;
});
