'use strict';
define(function() {
  var buffersizewidget = function(
    gcStyleFactory,
    $http,
    SelectManager,
    gclayers,
    gcPopup,
    $filter,
    gcRestrictionProvider,
    GeometryFactory,
    ogcFactory,
    gcInteractions,
    $rootScope,
     gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selecttoolbuffer/views/toolbarselecttoolbuffer.html',
      restrict: 'AE',

      link: function(scope, element) {
        scope.altKeyPressed = false;
        scope.currentmode = '';
        scope.isBufferCmdActive = false;
        var map = scope.map;
        scope.size = { buffer: '', type: '' };

        var btnElt = $(element[0]);

        scope.$on('closeToolsBar_buffersizewidget', function(arg0, origin) {
          if (origin.origin == 'buffersizewidget') return;
          if (scope.isBufferCmdActive) {
            scope.justToHideWidget = true;
            setTimeout(function() {
              $('#toolbar_selectbuffer_popover').click();
            }, 350);
          }
          //                    	setTimeout(function(){ $("#toolbar_selectbuffer_popover").click(); },350);
        });

        /**
         * Nettoyage de carte à l'ouverture / fermeture du widget
         */
        scope.cleanMap = function() {
          if (scope.justToHideWidget) {
            scope.justToHideWidget = false;
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isBufferCmdActive = false;
            if (scope.interaction) scope.interaction.setActive(false);
            return;
          }
          scope.size = { buffer: 5, type: '' };
          SelectManager.closepop();
          if (scope.interaction) scope.interaction.setActive(false);
          map.removeInteraction(scope.interaction);
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          gclayers.clearhighLightFeatures();
          SelectManager.clear();
          scope.currentmode = '';
          if (scope.isBufferCmdActive)
            scope.toolbarInfo.setActiveBtn(undefined, 'buffersizewidget');
          else
            scope.toolbarInfo.setActiveBtn(
              'buffersizewidget',
              'buffersizewidget'
            );

          if (scope.isBufferCmdActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isBufferCmdActive = false;
          } else {
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isBufferCmdActive = true;
          }
        };

        /**
         * Watcher sur la taille du buffer
         * @param  {number}
         * @return {number}
         */
        scope.$watch('scope.size.buffer', function(newValue) {
          if (newValue) {
            scope.size.buffer = newValue;
          } else {
            scope.size.buffer = '';
          }
        });

        /**
         * Fonction de dessin
         * @param  {String, String}
         * @return {Object}
         */
        scope.draw = function(typec, btnid) {
          if (scope.currentmode == btnid) {
            scope.currentmode = '';
          } else {
            scope.currentmode = btnid;
          }

          map.removeInteraction(scope.interaction);
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();

          scope.interaction = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: typec,
            condition: function(e) {
              scope.altKeyPressed = e.originalEvent.ctrlKey;
              return true;
            },
          });

          scope.interaction.set('gctype', 'kis');
          scope.interaction.set('interaction', 'Draw');
          scope.interaction.set('widget', 'select');

          map.addInteraction(scope.interaction);

          //Réinitialisation du layer / applique la taille de tampon souhaitée
          scope.interaction.on('drawstart', function() {
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
          });

          scope.interaction.on('drawend', function(evt) {
            //Conversion de la géométrie en objet GeoJSON
            var geoJsonObj = new ol.format.GeoJSON();
            var geoJsonStr = geoJsonObj.writeGeometry(
              evt.feature.getGeometry()
            );

            /**
             * Buffer de la geometrie
             * @return {Geométrie buffer}
             */
            scope.apply = function() {
              var bufferedGeoJson = GeometryFactory.buffer(
                geoJsonStr,
                'FLAT',
                scope.size.buffer
              );
              //Résolution de la promise
              bufferedGeoJson.then(function(res) {
                evt.feature.setGeometry(geoJsonObj.readGeometry(res.data));

                //Conversion de l'objet en WKT
                var wktObj = new ol.format.WKT().writeGeometry(
                  geoJsonObj.readGeometry(res.data)
                );
                var spatialClause = 'INTERSECTS(geom, ' + wktObj + ')';
                //Définition du filtre du layer
                var filter = gclayers.getSelectFilterasStringuid(map);

                if (filter != '') {
                  /**
                   * Promise recupération des features
                   * @param  {Feature}
                   * @return {Selected}
                   */
                  var promise = ogcFactory.getfeatures(
                    'GetFeature',
                    'WFS',
                    '1.0.0',
                    filter,
                    'json',
                    map
                      .getView()
                      .getProjection()
                      .getCode(),
                    spatialClause
                  );

                  promise.then(
                    function(resultat) {
                      gaJsUtils.prepareThingsWhenNewSelection(
                        scope,
                        SelectManager,
                        res
                      );

                      SelectManager.addFeaturesFromGeojson(resultat.data);

                      if (resultat.data.totalFeatures == 0) {
                        gclayers.clearhighLightFeatures();
                        SelectManager.clear();
                        require('toastr').error(
                          $filter('translate')(
                            'layermanager.no_selectable_layer'
                          )
                        );
                      } else {
                        var newScope = $rootScope.$new();
                        newScope.map = scope.map;
                        newScope.panelsManager = scope.panelsManager;
                        var pop = gcPopup.open({
                          scope: newScope,
                          title: 'Informations : ',
                          content: '<div selectfeaturetreewidget></div>',
                          showClose: true,
                          minimizeMaximize: true,
                          resizable: true,
                          minWidth: 430,
                          className: 'no-default-height',
                          onclose: function() {
                            SelectManager.clear();
                          },
                        });
                        SelectManager.setpop(pop);
                      }
                    },
                    function(result) {
                      gcRestrictionProvider.showDetailsErrorMessage(result);

                      if (SelectManager.getpop()) {
                        try {
                          if (SelectManager.getpop().element) {
                            SelectManager.getpop().destroy();
                          }
                          if (SelectManager.getpop().scope) {
                            SelectManager.getpop().scope.$broadcast('$destroy');
                          }
                        } catch (e) {
                          SelectManager.setpop(null);
                        }
                      }

                      gclayers.clearhighLightFeatures();
                      SelectManager.clear();
                    }
                  );
                } else {
                  require('toastr').error(
                    $filter('translate')('layermanager.no_selectable_layer')
                  );
                }
              });
            };
          });
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
        };
      },
    };
  };

  buffersizewidget.$inject = [
    'gcStyleFactory',
    '$http',
    'SelectManager',
    'gclayers',
    'gcPopup',
    '$filter',
    'gcRestrictionProvider',
    'GeometryFactory',
    'ogcFactory',
    'gcInteractions',
    '$rootScope',
    'gaJsUtils'
  ];
  return buffersizewidget;
});
