/**
 *
 */
'use strict';
define(function() {
  var SelectManager = function() {
    var selectFeatures = {};
    var Popover = null;
    this.$get = function($rootScope, gcPopup, $filter) {
      var Select = function() {
        this.setpop = function(pop) {
          Popover = pop;
        };
        this.getpop = function() {
          return Popover;
        };
        this.openpop = function(scope) {
          if (Popover) {
            Popover.destroy();
          }

          Popover = gcPopup.open({
            scope: scope,
            title: 'Informations : ',
            content: '<div selectfeaturetreewidget  ></div>',
            showClose: true,
            resizable: true,
            minimizeMaximize: true,
            minWidth: 430,
            className: 'no-default-height',
            onclose: function() {
              selectFeatures = {
                type: 'FeatureCollection',
                totalFeatures: 0,
                features: [],
              };
              $rootScope.$broadcast('gcSelectChange');
            },
          });
        };
        this.closepop = function() {
          if (Popover) {
            Popover.destroy();
            Popover = null;
          }
        };
        /**
         *Add features to select Manager
         *
         */
        this.getFeaturesByftiType = function(ftiname) {
          var extract2 = {
            features: [],
            totalFeatures: 0,
            type: 'FeatureCollection',
          };

          var extract = angular.copy(selectFeatures);
          var val = ftiname + '.';
          angular.forEach(extract.features, function(value) {
            if (value.id.indexOf(val) != -1) {
              //extract.features.splice(i,1);
              extract2.features.push(value);
            }
          });
          extract2.totalFeatures = extract2.features.length;
          return extract2;
        };

        /*Add features to select Manager
         *
         */
        this.getFeatures = function() {
          return selectFeatures;
        };
        /**
         * [getFeaturesIDByftiType return listofid]
         * @param  {[String]} ftiname [description]
         * @return {[Array]}         [listoffid]
         */
        this.getFeaturesIdByftiType = function(ftiname) {
          var extract = [];
          var val = ftiname + '.';
          angular.forEach(selectFeatures.features, function(value) {
            if (value.id.indexOf(val) != -1) {
              extract.push(value.id);
            }
          });
          return extract;
        };
        this.updateFeaturesIdByftiType = function(ftiname, geojson) {
          var i = 0;
          var val = ftiname + '.';

          angular.forEach(selectFeatures.features, function(value) {
            if (value.id.indexOf(val) != -1) {
              selectFeatures.features.splice(i, 1);
            }
            i++;
          });

          angular.forEach(geojson.features, function(feat) {
            selectFeatures.features.push(feat);
          });
          $rootScope.$broadcast('gcSelectChange');
        };
        /**
         *Add features to select Manager
         *
         */
        this.addFeaturesFromGeojson = function(features) {
          if (features.trim !== undefined)
            console.log('SelectManager.ERREUR:\n' + features);
          else {
            if (!features.addMode) {
              selectFeatures = features;
            } else {
              selectFeatures.features = selectFeatures.features.concat(
                  features.features
              );
            }
            $rootScope.$broadcast('gcSelectChange',selectFeatures);
          }
        };
        this.clear = function() {
          selectFeatures = {
            type: 'FeatureCollection',
            totalFeatures: 0,
            features: [],
          };
          $rootScope.$broadcast('gcSelectChange');
        };
        this.getfeatures = function () {
          return selectFeatures;
        };
        this.removefeatures = function(featid) {
          const deleteIndex = selectFeatures.features.findIndex(feat => feat.id === featid);
          if (deleteIndex > -1) {
            selectFeatures.features.splice(deleteIndex, 1);
            selectFeatures.totalFeatures = selectFeatures.totalFeatures - 1;
            $rootScope.$broadcast('gcSelectChange');
          }
        };
        /**
         *
         */

        this.getExtent = function() {
          var featuresCollection = new ol.geom.GeometryCollection();
          var geometries = [];

          selectFeatures.features.forEach(function(f) {
            var feature = undefined;
            if (f.geometry && f.geometry.type) {
              switch (f.geometry.type) {
                case 'Point':
                  feature = new ol.Feature({
                    geometry: new ol.geom.Point(f.geometry.coordinates),
                  });
                  break;
                case 'MultiPoint':
                  feature = new ol.Feature({
                    geometry: new ol.geom.MultiPoint(f.geometry.coordinates),
                  });
                  break;
                case 'LineString':
                  feature = new ol.Feature({
                    geometry: new ol.geom.LineString(f.geometry.coordinates),
                  });
                  break;
                case 'MultiLineString':
                  feature = new ol.Feature({
                    geometry: new ol.geom.MultiLineString(
                      f.geometry.coordinates
                    ),
                  });
                  break;
                case 'Polygon':
                  feature = new ol.Feature({
                    geometry: new ol.geom.Polygon(f.geometry.coordinates),
                  });
                  break;
                case 'MultiPolygon':
                  feature = new ol.Feature({
                    geometry: new ol.geom.MultiPolygon(f.geometry.coordinates),
                  });
                  break;
              }
            }
            if (feature) geometries.push(feature.getGeometry());
          });

          featuresCollection.setGeometries(geometries);

          return featuresCollection.getExtent();
        };

        this.isGeojsonEmpty = (geojson) => {
          if (geojson && geojson.totalFeatures === 0) {
            require('toastr').warning(
                $filter('translate')('elastic.search.search_success_without_results')
            );
            return true;
          } else {
            return false;
          }
        };

        this.hasFeature = function(featid) {
          return selectFeatures.features.some(feat => feat.id === featid);
        };
      };
      return new Select();
    };
    this.$get.$inject = ['$rootScope', 'gcPopup', '$filter'];
  };
  return SelectManager;
});
