'use strict';
define(function() {
  var quickquerywidget = function(ParametersFactory,
     gaJsUtils, QueryService, $timeout) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/quickquery/views/quickquerywidget.html',
      restrict: 'A',
      link: function(scope, element) {
        
        ///Composant
        scope.selectedcomponent = '';
        scope.component = [];

        //Attribut
        scope.selectedattribut = null;
        scope.attributs = [];

        //values
        scope.selectedattvalue = '';
        scope.attvalues = [];
        //operand
        scope.operands = ['=', '<>', '>', '>=', '<', '<=', 'LIKE'];
        scope.combin = ['AND', 'OR'];

        scope.geometricoperand = [
          'EQUALS',
          'DISJOINT',
          'INTERSECTS',
          'TOUCHES',
          'CROSSES',
          'WITHIN',
          'CONTAINS',
          'OVERLAPS',
          'RELATE',
          'DWITHIN',
          'BEYOND',
        ];
        scope.selectedGeomOperand = 'INTERSECTS';
        scope.currentSelectionClause = '';

        scope.whereClause = '';
        scope.geoLimit = 'BD';
        scope.limitZoneGeometry = null;

        //parameters
        scope.parameterAddPopup = null;
        scope.parameterValuePopup = null;
        scope.queryParam = {};
        scope.currtParamName = '';

        var setFavoris = function() {
          scope.favoris = [];
          scope.names = [];
          scope.minwidth = 24;
          scope.style = {
            width: '200 px',
          };
          ParametersFactory.getbytype('Request').then(
            res => {
              scope.favoris.push(...gaJsUtils.sortByKey(res.data, 'name'));
              adjustPopoverPosition(null, 10);
            }
          );
        };

        scope.attributvaluechangeTest = function(selectedValue) {
          scope.queryParam.value = selectedValue.value;
        };

        scope.dateChanged = function(selectedDate) {
          scope.queryParam.value = selectedDate;
        };

        scope.replaceParamInQuery = function() {
          QueryService.replaceParamInQuery(scope);
        };
        
        scope.gofavoris = function(fav, name) {
          QueryService.gofavoris(fav, name, scope);
        };

        setFavoris();

        // close the popup when the widget is closed
        // if we dont do this, the popup is unclosable thx to the way popups are now initialized...
        scope.$watch('isActive', (isActive, wasActive) => {
          if(wasActive && !isActive){
            if(scope.parameterValuePopup) scope.parameterValuePopup.close();
          }
        });

        /**
         * Ajustement de la position de la popover de l'outil "starquery" (requêtes favorites)<ul><li>
         * CAS 1 - le bouton "starquery" est placé au bas de la barre verticale : remonte la popover à l'intérieur de l'écran</li><li>
         * CAS 2 - le bouton "starquery" est placé en haut / au milieu de la barre verticale : remonte la popover à gauche du bouton</li></ul>
         * @param {HTMLDivElement} popover conteneur de la liste des requêtes favorites
         * @param {number} tries nombre d'exécution maximum de la méthode. Paramètre ayant pour but d'éviter une répétition sans fin.
         */
        const adjustPopoverPosition = (popover, tries) => {
          // Vérifie si la div popover existe
          if (popover) {
            // Obtient les informations de positionnement de la div popover
            const rect = popover.getBoundingClientRect();

            // Vérifie si la div a une hauteur de 0 (peut ne pas être rendue à ce moment-là)
            if (rect) {
              if (rect.height < 300) {
                // Attendez un court délai et réexécutez la fonction avec la div mise à jour
                $timeout(() => {
                  adjustPopoverPosition(popover, --tries);
                });
                return;
              }

              // Vérifie si la partie basse de la div dépasse de l'écran
              if (rect.bottom > window.innerHeight) {

                // CAS 1: le bouton est au bas de la barre verticale
                // la partie basse de la popover dépasse le bas de l'écran et n'est pas visible

                // Décalage supplémentaire pour laisser un espace entre le bas de la popover et le bas de la page
                const extraOffset = 10;

                // Calcule la quantité de dépassement
                const overflowAmount = rect.bottom - window.innerHeight;

                // Utilise transform pour déplacer la div vers le haut
                popover.style.transform = `translateY(-${(overflowAmount + extraOffset)}px)`;

                const arrow = popover.querySelector('.arrow');
                if (arrow) {
                  arrow.style.transform = `translateY(${extraOffset}px)`;
                }
              } else {

                // CAS 2: le bouton est vers le haut de la barre verticale des outils de droite
                // la popover est décalée vers le bas

                const button = popover.previousSibling;
                if (button && button.tagName === 'BUTTON') {

                  // Obtient les informations de positionnement de la div popover
                  const popoverPosition = popover.getBoundingClientRect();

                  // Calcule le décalage vertical de la popover
                  const buttonMidPosition = button.getBoundingClientRect().top + (button.offsetHeight / 2);
                  const popoverMidPosition = popoverPosition.top + (popover.offsetHeight / 2);
                  const popoverOffset = popoverMidPosition - buttonMidPosition;
                  popover.style.transform = `translateY(-${popoverOffset}px)`;

                  // Calcule le décalage vertical du pointeur de la popover
                  const arrow = popover.querySelector('.arrow');
                  if (arrow) {
                    const arrowMidPosition = arrow.getBoundingClientRect().top + (arrow.offsetHeight / 2);
                    const arrowOffset = arrowMidPosition - buttonMidPosition;
                    arrow.style.transform = `translateY(-${arrowOffset}px)`;
                  }
                }
              }
            }
          } else {
            // Attend un court délai et réexécute la fonction avec la div mise à jour
            $timeout(() => {
              adjustPopoverPosition(element[0].closest('.popover'), --tries);
            });
          }
        };

      },
    };
  };

  quickquerywidget.$inject = [
    'ParametersFactory',
    'gaJsUtils',
    'QueryService',
    '$timeout'
  ];
  return quickquerywidget;
});
