'use strict';
define(function() {
  var quickfilterwidget = function(
    gcPropertiesLayers,
    gclayers,
    QueryFactory,
    SelectManager,
    gcPopup,
    $filter,
    $rootScope,
    QueryService
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/quickfilter/views/quickfilterwidget.html',
      restrict: 'A',
      link: function(scope, element, attrs, ctrl) {
        var map = scope.map;
        ///Composant
        scope.selectedcomponent = '';
        scope.component = [];

        //Attribut
        scope.selectedattribut = null;
        scope.attributs = [];
        //scope where clause
        scope.whereClause = '';

        scope.loadLayers = function() {
          scope.component.splice(0, scope.component.length);
          var layers = gclayers.getEditableLayer();
          layers.forEach(function(l) {
            scope.component.push({
              alias: l.fti.alias,
              value: l.id,
              label: l.name,
              type: l.fti.typeInfo,
              uid: l.fti.uid,
              fti: l.fti,
            });
          });
        };
        scope.attributeunique = function() {
          QueryFactory.dataattribute(
            scope.selectedcomponent.uid,
            scope.selectedattribut.value
          ).then(function(res) {
            if ((scope.selectedattribut.value !== 'fid') &&
              [
                'java.util.Date',
                'java.sql.Timestamp',
                'java.sql.Time',
                'java.sql.Date',
              ].indexOf(scope.selectedattribut.att.type) != -1
            ) {
              scope.currentAttributeIsDate = true;
            }

            if (
              res.data.length === 0 ||
              (res.data.length === 1 && res.data[0] === '')
            ) {
              require('toastr').info(
                $filter('translate')('model.featuretypes.attributes.no_values')
              );
            } else {
              scope.selectedattvalue = '';
              scope.attvalues = [];
              res.data.forEach(function(att) {
                if (att !== '') {
                  var label = att;
                  if (scope.currentAttributeIsDate && att !== null) {
                    var d = new Date(att);
                    // valid date
                    if (d.getTime() > 0) {
                      label =
                        d.getFullYear() +
                        '/' +
                        (d.getMonth() + 1) +
                        '/' +
                        d.getDate();
                      att = d.toISOString();
                    }
                  }

                  scope.attvalues.push({
                    value: att,
                    label: label,
                  });
                }
              });
            }
          });
        };
        scope.attributvaluechange = function() {
          scope.quickvalue = scope.selectedattvalue.value;
        };

        /**
         * Change component
         */
        scope.selectcomponetchange = function() {
          scope.attributs = [];
          scope.selectedattribut = false;
          scope.whereClause = '';

          scope.selectedcomponent.fti.attributes.forEach(function(att) {
            scope.attributs.push({
              value: att.name,
              label: att.alias,
              att: att,
            });
          });
          if (scope.selectedcomponent && scope.selectedcomponent.fti
            && scope.selectedcomponent.fti.type !== "esri") {
            scope.attributs.push({
              value: 'fid',
              label: 'fid',
              att: undefined,
            });
          }
        };

        scope.quickSearch = function() {
          if (scope.selectedattribut.value !== 'fid'
            && scope.selectedattribut.att.type === 'java.lang.String') {
            scope.whereClause =
              scope.selectedattribut.value +
              " LIKE '%" +
              scope.quickvalue +
              "%' ";
          } else {
            scope.whereClause =
              scope.selectedattribut.value + ' = ' + scope.quickvalue + ' ';
          }

          const crs = scope.map.getView().getProjection().getCode();

          // KIS-3145 : gérer la présence d’apostrophe dans les valeurs d’attribut
          const request = QueryService.replaceWhereClauseQuotedText(scope.whereClause);

          const payLoad = {
            groups: [
              {
                filter: request,
                operand: 'count',
                ftiUids: [scope.selectedcomponent.uid]
              }
            ]
          };

          QueryFactory.getCount(payLoad).then(
              res => {
                if (res.data.etat === 'erreur' && res.data.hasOwnProperty('errorList')) {

                  // "gestion" KIS de l'erreur serveur
                  require('toastr').error(gaJsUtils.errorListToOneString(res.data.errorList));

                } else if (Array.isArray(res.data.objValeur.groups) && res.data.objValeur.groups.length > 0
                    && typeof res.data.objValeur.groups[0].result == 'number') {

                  const count = res.data.objValeur.groups[0].result;

                  // si la requête s'est bien exécutée
                  if (count <= 10000) {

                    // le nombre d'objets à retourner est faible => on poursuit sur la requête des objets
                    QueryFactory.pdata(scope.selectedcomponent.uid, request, crs).then(function(res) {
                      if (
                          $rootScope.xgos &&
                          $rootScope.xgos.sector === 'hpo' &&
                          $rootScope.xgos.hpo
                      ) {
                        //require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
                        $rootScope.xgos.hpo.clauseWhere = scope.whereClause;
                        if (scope.map && scope.map.getView)
                          $rootScope.xgos.hpo.srid = scope.map.getView().getProjection().getCode();
                      }

                      if (res.data.totalFeatures === 0) {
                        require('toastr').warning(
                            $filter('translate')('quickfilter.no_value')
                        );
                      } else {
                        SelectManager.addFeaturesFromGeojson(res.data);
                        var extent = SelectManager.getExtent();
                        map.getView().fit(extent, map.getSize());
                        SelectManager.openpop(scope);
                      }
                    });
                  } else {

                    // le nombre d'objets à retourner est important => l'utilisateur doit refaire sa recherche avec un critère
                    swal(
                        {
                          title: $filter('translate')('query.getCountSwalTitle'),
                          text: $filter('translate')('query.dataOverLimit').replace('$1', count),
                          type: 'warning',
                          showCancelButton: false,
                          confirmButtonColor: '#5cb85c',
                          confirmButtonText: $filter('translate')('common.ok'),
                          closeOnConfirm: true
                        }
                    );
                  }
                } else {
                  require('toastr').error($filter('translate')('query.getCountServerErrorMessage'));
                  console.error($filter('translate')('query.getCountServer'));
                }
              }).catch(error => {
                console.error('executeQuery : ', error);
              });
        };

        scope.$on('gcOperationalLayerChange', function(event, l) {
          scope.loadLayers();
        });

        scope.loadLayers();
      },
    };
  };

  quickfilterwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'QueryFactory',
    'SelectManager',
    'gcPopup',
    '$filter',
    '$rootScope',
    'QueryService'
  ];
  return quickfilterwidget;
});
