'use strict';
define(function() {
  var printv2widgetisole = function(ngDialog, ConfigFactory, $q, $filter) {
    return {
      restrict: 'EA',
      templateUrl: 'js/XG/widgets/mapapp/printv2/views/print.html',
      controller: 'printV2Ctrl',
      scope: {
        map: '=map',
        res: '=res',
        ext: '=ext',
        ongeturl: '&ongeturl',
        dictfilename: '=dictfilename',
        inscale: '=',
        launchmode: '=',
      },

      link: function(scope) {
        //-- Configuration par défaut
        scope.config = { layersToPrint: 'user' };
        /**
         * Ouverture de la fenêtre de configuration du widget d'impression.
         */
        scope.openConfig = function() {
          //-- Récupération de la configuration en cours.
          scope.getConfig().then(function() {
            //-- Copie de la configuration en cours
            //-- dans une propriété de travail du scope: configw.
            if (scope.config == undefined) scope.config = {};
            scope.configw = angular.copy(scope.config);
            ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/printv2/views/modal/configuration.html',
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              draggable: {
                title: 'Configuration',
              },
            });
          });
        };

        /**
         * Récupère et charge  la configuration depuis le fichier.
         * @returns {undefined}
         */

        scope.getConfig = function() {
          var p = $q.defer();
          ConfigFactory.get('widgets', 'printv2').then(
            function(res) {
              if (res.data != '') {
                scope.config = res.data;
              }
              p.resolve(true);
            },
            function(reason) {
              console.error(
                'Configuration du widget impression non chargée:' + reason
              );
            }
          );
          return p.promise;
        };

        /**
         *    Sauvegarde de la configuration définié
         * dans le widget de configuration de l'impresion.
         */
        scope.saveConfig = function() {
          ConfigFactory.update(scope.configw, 'widgets', 'printv2').then(
            function(res) {
              if (res.data) {
                require('toastr').success(
                  $filter('translate')('printv2.configurationSaved')
                );
                scope.config.layersToPrint = scope.configw.layersToPrint;
                scope.options.asVisibleOnMap = scope.config.layersToPrint;
              } else
                require('toastr').error(
                  $filter('translate')('printv2.configurationNotSaved')
                );
            }
          );
        };

        /**
         *     Préparation du widget d'impression en fonction de la configuration.
         */
        scope.initFromConfig = function() {
          scope.configw = {};
          scope.getConfig().then(function(res) {
            if (
              scope.config != undefined &&
              scope.config.layersToPrint != 'user'
            ) {
              scope.options.asVisibleOnMap = scope.config.layersToPrint;
            }
          });
        };

        scope.initFromConfig();
      },
    };
  };

  printv2widgetisole.$inject = ['ngDialog', 'ConfigFactory', '$q', '$filter'];
  return printv2widgetisole;
});
