'use strict';
define(function() {
  var overviewwidget = function(ParametersFactory, $timeout) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/overview/views/overviewwidget.html',
      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        var v = scope.map.getView();
        var canvasMap = undefined;
        var image = undefined;
        var imageSource = undefined;
        var imgLayer = undefined;
        var ratio = undefined;
        var overviewExt = undefined;
        var locFeature = undefined; //Feature representant le cadre rouge de localisation
        var savedParam = undefined;

        var dragBox = new ol.interaction.DragBox({
          condition: ol.events.condition.shiftKeyOnly,
          style: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: [0, 0, 255, 1],
            }),
          }),
        });

        dragBox.set('gctype', 'kis');
        dragBox.set('interaction', 'Select');
        dragBox.set('widget', 'select');

        /**
         * Utlisé poure le cadre de localisation.
         * @type ol.source.Vector
         */
        var vectorSource = new ol.source.Vector({});
        var vectorLayer = new ol.layer.Vector({
          source: vectorSource,
          style: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: 'red',
              width: 2,
            }),
          }),
        });

        /**
         * Méthode de récupération des données de la vue courante de la Map.
         * Handler de clic du bouton de 'capture de la vue courante'.
         * @returns {undefined}
         */
        scope.saveView = function() {
          //Nouveaux réglages à enregistrer dans les paramètres en base.
          var map = scope.map;

          //Overview a le même centre que la carte
          var center = v.getCenter();
          canvasMap.getView().setCenter(center);

          //Calcul du ratio de resolution entre la carte principale et l'overview.
          //Remarque: le calcul de la resolution de l'overview ne se fait qu'en fonction du rapport des largeurs des carte principal et overview;
          //donc si les rapports hauteur/largeur des deux cartes sont differents, la carte de l'overview affichera plus ou moins de données en hauteur lors de la capture de l'image.
          // Pour que la capture image represente exactement la meme etendu en 'y' que la carte,
          // il faut que les rapports hauteur/largeur des deux cartes soient les mêmes.
          var originalSize = scope.map.getSize();
          var canvasSize = canvasMap.getSize();
          var origWidth = originalSize[0];
          var canvasWidth = canvasSize[0];
          ratio = canvasWidth / origWidth;

          //Adaptation de la resolution de l'overview pour que toute l'entendue de la carte  soit contenue dans le cadre overview
          var resolution = v.getResolution() / ratio;
          canvasMap.getView().setResolution(resolution);

          //Calcul de l'entendu de l'overview
          overviewExt = canvasMap
            .getView()
            .calculateExtent(canvasMap.getSize());

          //Génération d'une image à partir de la carte principale affichée.
          map.once('postcompose', function(event) {
            var canvas = event.context.canvas;
            image = canvas.toDataURL('image/png');
            //Entendu correspondant à l'image capturé de la carte.
            var initialExtent = v.calculateExtent(scope.map.getSize());
            updateImageSource(initialExtent);
            //Sauvegarde des réglages de l'overview
            saveViewParameters(center, resolution, initialExtent, image);
          });
          map.renderSync();
        };
        /**
         * Méthode de sauvegarde des données affichées dans l'overview.
         * @param {type} center
         * @param {type} resolution
         * @returns {undefined}
         */
        function saveViewParameters(center, resolution, imageExtent, image) {
          console.log('Save overview parameters');
          var param = {
            center: center,
            resolution: resolution,
            extent: imageExtent,
            img: image,
          };
          if (savedParam != undefined) {
            savedParam.data = param;
            ParametersFactory.update(savedParam, savedParam.id).then(function(
              res
            ) {
              savedParam = res.data;
              console.log('Static overview parameters saved !');
            });
          } else {
            ParametersFactory.add(param, 'StaticOverview', '1').then(function(
              res
            ) {
              savedParam = res.data;
              console.log('Static overview parameters saved !');
            });
          }
        }

        /**
         * Méthode de récupération des donnéees de l'overview precedement sauvegardées.
         * @returns {undefined}
         */
        function getSavedView() {
          //Affectation des eventuels réglages de la vue préalablement sauvés sous forme d'un paramètre.
          ParametersFactory.getbytype('StaticOverview').then(function(res) {
            if (res.data[0] != undefined) {
              console.log(
                "StaticOverview, affectation des paramètres de l'overview."
              );
              savedParam = res.data[0];
              var param = res.data[0].data;
              canvasMap.getView().setResolution(param.resolution);
              canvasMap.getView().setCenter(param.center);
              image = param.img;
              updateImageSource(param.extent);
            }
          });
        }

        function updateImageSource(imageExtent) {
          canvasMap.removeLayer(imgLayer);
          canvasMap.removeLayer(vectorLayer);
          imageSource = new ol.source.ImageStatic({
            attributions: [],
            url: image,
            projection: scope.map.getView().getProjection(),
            imageExtent: imageExtent,
          });
          imgLayer = new ol.layer.Image({
            source: imageSource,
          });
          canvasMap.addLayer(imgLayer);
          canvasMap.addLayer(vectorLayer);
        }

        function removeParameter(paramID) {
          ParametersFactory.remove(paramID).then(function(res) {});
        }

        /**
         * Méthode creant une Map dans l'overview.
         * @returns {undefined}
         */

        scope.snapShot = function() {
          //elt.find('div').off('mouseover', scope.snapShot);

          canvasMap = new ol.Map({
            target: 'overViewStatic',
            controls: [],
            view: new ol.View({
              zoom: 0,
              center: scope.map.getView().getCenter(),
               projection: scope.map.getView().getProjection(),
            }),
            interactions: [
              dragBox,
              //new ol.interaction.DragPan()
            ],
            layers: [
              //                            new ol.layer.Tile({
              //                                source:new ol.source.OSM()
              //                            })
            ],
          });
          //Layer de type image representant la vue statique
          var initialExtent = v.calculateExtent(scope.map.getSize());
          //
          //                    //Cadre rouge de localisation de l'etendu de la carte principale
          locFeature = new ol.Feature({ name: '' });
          locFeature.setGeometry(new ol.geom.Polygon.fromExtent(initialExtent));
          //Ajout des quatre points extremes de initialExtent
          //                    var locFeatureCoordinates = [];
          //                    locFeatureCoordinates.push([initialExtent[0],initialExtent[1]]);
          //                    locFeatureCoordinates.push([initialExtent[0],initialExtent[3]]);
          //                    locFeatureCoordinates.push([initialExtent[2],initialExtent[1]]);
          //                    locFeatureCoordinates.push([initialExtent[2],initialExtent[3]]);
          //                    locFeature.setGeometry(new ol.geom.Polygon([locFeatureCoordinates],'xy'));
          //
          vectorSource.addFeature(locFeature);
          canvasMap.addLayer(vectorLayer);
          v.on('propertychange', scope.updateLocateFrame);

          //Calcul du ratio de resolution entre la carte principale et l'overview
          var originalSize = scope.map.getSize();
          var canvasSize = canvasMap.getSize();
          var origWidth = originalSize[0];
          var canvasWidth = canvasSize[0];
          ratio = canvasWidth / origWidth;

          //Récupération d'une eventuelle vue préalablement sauvée.
          getSavedView();

          //Ajout des handler d'evenement souris sur l'overview
          canvasMap.on('click', updateMapFromClick);
          // canvasMap.on("moveend", updateMapFromMove); //Handler appelé meme au chargement de la canvasMap et entraine une mise à jour de la carte dès l'ouverture de la popup
          dragBox.on('boxend', updateMapFromDragBox);

          // canvasMap.on("pointerdrag", updateMapFromZoom);
          //                    canvasMap.bindTo('layers', scope.map);
          //                    canvasMap.bindTo('view', scope.map);

          //
          //Tentative de récupération de l'image de la Map
          //                    var target = scope.map.getTarget();
          //                    var targetElement = scope.map.getTargetElement();
          //                    targetElement =  targetElement.cloneNode(true);
          //                    var blob = new Blob([targetElement.innerHTML], {type: "image/jpeg"});
          //                    var objectUrl = URL.createObjectURL(blob);
          //                    window.open(objectUrl);
          //                     scope.overviewSrc = objectUrl;

          //Récupération d'un png issu du service utilisé pour le fond de carte
          //                    var baseLayers = gclayers.getBackGroundLayer();
          //                    var l = baseLayers[0];
          //                    var tileSource = l.getSource();
          //                    var grid = tileSource.getTileGrid();
          //                    var keys = tileSource.getKeys();
          //                    var img = tileSource.get(keys[0]);

          // "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNby
          // blAAAADElEQVQImWNgoBMAAABpAAFEI8ARAAAAAElFTkSuQmCC"
          // scope.overviewSrc = imageData;
        };
        //elt.find('div').on('mouseover', scope.snapShot);

        //Attente de l'insertion du conteneur (div) dans le DOM (ouverture de la popup) avant d'inserer la canvasMap
        $timeout(scope.snapShot, 100);

        /**
         * Mise à jour de la position du cadre rouge de localisation.
         * @param {type} event
         * @returns {undefined}
         */
        scope.updateLocateFrame = function(event) {
          var initialExtent = v.calculateExtent(scope.map.getSize());

          //                    var locFeatureCoordinates = [];
          //                    locFeatureCoordinates.push([initialExtent[0],initialExtent[1]]);
          //                    locFeatureCoordinates.push([initialExtent[0],initialExtent[3]]);
          //                    locFeatureCoordinates.push([initialExtent[2],initialExtent[1]]);
          //                    locFeatureCoordinates.push([initialExtent[2],initialExtent[3]]);
          //                    locFeature.setGeometry(new ol.geom.Polygon([locFeatureCoordinates],'xy'));

          locFeature.setGeometry(new ol.geom.Polygon.fromExtent(initialExtent));
        };

        /**
         * Met à jour la carte principale dès qu'un evenement souris dans l'overview à lieu
         * @param {type} mouseevent
         * @returns {undefined}
         */
        function updateMapFromClick(clickEvent) {
          var coord = clickEvent.coordinate;
          v.setCenter([coord[0], coord[1]]);
        }

        function updateMapFromDragBox(boxEvent) {
          var ext = dragBox.getGeometry().getExtent();
          //                     //Calcul du nouveau centre
          //                    var x = (ext[2]+ext[0])/2 ;
          //                    var y = (ext[3]+ext[1])/2 ;
          //                    v.setCenter([x,y]);

          //                     //Calcul de la nouvelle résolution
          //                    var locFrameExtent = locFeature.getGeometry().getExtent();
          //                    var originaldistanceX = locFrameExtent[2] - locFrameExtent[0] ;
          //                    var originaldistancey = locFrameExtent[3] - locFrameExtent[1] ;
          //                    var framedistanceX = ext[2] - ext[0] ;
          //                    var framedistancey = ext[3] - ext[1] ;
          //                    //Distance en x dans la frame dessinée à la souris / distance en x de l'etendu de la map de l'overview
          //                    var zoomRatio = (framedistanceX * framedistancey) /(originaldistanceX * originaldistancey) ;
          //                    var newresolution = v.getResolution() * zoomRatio;
          //                    v.setResolution(newresolution);

          //Affectation de la nouvelle étendue à la carte
          v.fit(ext, scope.map.getSize());
        }

        function updateMapFromMove(moveEvent) {
          var cV = canvasMap.getView();
          v.setCenter(cV.getCenter());
        }

        function updateMapFromZoom(zoomEvent) {
          if (ratio == undefined) {
            alert("Capturez une vue avant l'utilisation de celle-ci.");
            return;
          }
          var frame = zoomEvent.frameState;
          if (frame != undefined) {
            var ext = frame.extent;
            var cV = canvasMap.getView();

            //Calcul du nouveau centre
            var x = (ext[2] + ext[0]) / 2;
            var y = (ext[3] + ext[1]) / 2;
            v.setCenter([x, y]);

            //Calcul de la nouvelle résolution

            var originaldistanceX = overviewExt[2] - overviewExt[0];
            var framedistanceX = ext[2] - ext[0];

            //Distance en x dans la frame dessinée à la souris / distance en x de l'etendu de la map de l'overview
            var zoomRatio = framedistanceX / originaldistanceX;

            var newresolution = v.getResolution() * zoomRatio;
            v.setResolution(newresolution);
          }
        }
      },
    };
  };

  overviewwidget.$inject = ['ParametersFactory', '$timeout'];
  return overviewwidget;
});
