'use strict';
define(function() {
  var gcmouseposition = function(
    gaJsUtils,
    SridFactory,
    ConfigFactory,
    ngDialog,
    $rootScope,
    $filter, $timeout
  ) {
    return {
      restrict: 'EA',
      templateUrl:
        'js/XG/widgets/mapapp/mouseposition/views/gcmouseposition.html',
      /*scope: {
            map: '=gcmousepositionmap',
            options: '=gcmousepositionoptions'
          },*/

      link: function(scope) {
        scope.currentsrid = {
          name: scope.map.getView().getProjection().getCode(),
          description: null,
        };
        scope.selectedsrid = scope.currentsrid;
        if (!$rootScope.xgos.mouseposition) $rootScope.xgos.mouseposition = {};
        $rootScope.xgos.mouseposition.srid = scope.currentsrid;

        var map = scope.map,
          viewport = map.getViewport();
        ConfigFactory.get('main', 'coordinate').then(function(res) {
          //console.log(res.data)   ;
          if (res.data != '') {
            scope.currentsrid = res.data;
            scope.selectedsrid = res.data;
            $rootScope.xgos.mouseposition.srid = scope.currentsrid;
          }
          //require('toastr').success(res.data);
        });
        scope.position = { x: null, y: null };
        $rootScope.xgos.mouseposition.position = scope.position;

        scope.zoom = {};
        var move = function(e) {
          var coord = map.getEventCoordinate(e.originalEvent);
          const scale
            = gaJsUtils.resolutionToScale(map.getView().getResolution(), 'm');
          scope.zoom.z = '1:' + Math.round(scale);

          if (angular.isArray(coord)) {
            try {
              $timeout( () => {
                scope.position.x = Math.round(coord[0] * 1000, 3) / 1000;
                scope.position.y = Math.round(coord[1] * 1000, 3) / 1000;
                $rootScope.xgos.mouseposition.position = scope.position;
              });
            }
            catch(err) {}
          }
        };
        /**
         * Use our own listener because ol.control.MousePosition
         * doesnt allow us to get the position value and doesnt handle mouse hover
         */
        angular.element(viewport).on('mousemove', move);
        scope.$watch('currentsrid', function(newVal, oldVal) {
          //console.log(newVal)
          if (newVal.name != oldVal.name) {
            angular.element(window).off('mousemove', move);
          }
        });
        /**
         * Edit the projection used to display the position
         */
        scope.selectedsrid = {};
        scope.getandsave = function() {
          $rootScope.xgos.srid = scope.selectedsrid;
          console.log(scope.selectedsrid);
          //scope.currentsrid.name = scope.selectedsrid;
          SridFactory.getbycode(scope.selectedsrid.name).then(
            function(res) {
              scope.selectedsrid.description = res.data;
              scope.currentsrid = scope.selectedsrid;
              $rootScope.xgos.mouseposition.srid = scope.currentsrid;
              require('toastr').success($filter('translate')('common.apply'));
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };

        scope.selectsridchange = function() {
          scope.currentsrid.name = scope.selectedsrid.name;
        };

        scope.srids = SridFactory.sridsList;

        /**
         * Select the projection
         */
        scope.projectionEdit = function() {
          //scope.selectedsrid ={ name : map.getView().getProjection().getCode()};

          ngDialog.open({
            template:
              'js/XG/widgets/mapapp/mouseposition/views/gcmouseposition_edit.html',
            className: 'ngdialog-theme-plain',
            closeByDocument: false,
            scope: scope,
          });
        };
        scope.listSRID = SridFactory.listSRID;
      },
    };
  };

  gcmouseposition.$inject = [
    'gaJsUtils',
    'SridFactory',
    'ConfigFactory',
    'ngDialog',
    '$rootScope',
    '$filter', '$timeout'
  ];
  return gcmouseposition;
});
