'use strict';
define(function() {
  var measureDirective = function(gcPropertiesLayers, gclayers, $rootScope) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/measure/views/measure.html',

      restrict: 'EA',

      link: function(scope, element, attrs, ctrl) {
        scope.continuePolygonMsg = 'Cliquer pour continuer le polygone';
        scope.continueLineMsg = 'Cliquer pour continuer la ligne';
        scope.typemeasure = '';
        scope.currentmode = '';
        scope.isActive = false;
        var wgs84Sphere = new ol.Sphere(6378137);

        /**
         * [fct description]
         * @param  {[type]} evt [description]
         * @return {[type]}     [description]
         */
        var fct = function(evt) {
          if (evt.dragging) {
            return;
          }
          /** @type {string} */
          var helpMsg = 'Cliquer pour commencer';
          /** @type {ol.Coordinate|undefined} */
          var tooltipCoord = evt.coordinate;

          if (scope.sketch) {
            var output;
            var geom = scope.sketch.getGeometry();
            if (geom instanceof ol.geom.Polygon) {
              output = scope.formatArea(/** @type {ol.geom.Polygon} */ (geom));
              helpMsg = scope.continuePolygonMsg;
              tooltipCoord = geom.getInteriorPoint().getCoordinates();
            } else if (geom instanceof ol.geom.LineString) {
              output = scope.formatLength(
                /** @type {ol.geom.LineString} */ (geom)
              );
              helpMsg = scope.continueLineMsg;
              tooltipCoord = geom.getLastCoordinate();
            }
            scope.measureTooltipElement.innerHTML = output;
            scope.measureTooltip.setPosition(tooltipCoord);
          }

          scope.helpTooltipElement.innerHTML = helpMsg;
          scope.helpTooltip.setPosition(evt.coordinate);
        };
        /**
         * [description]
         * @param  {[type]} e        [description]
         * @param  {[type]} $dialog) {                                                 console.log('ngDialog closed: ' );                                      scope.map.un('pointermove',fct );                                      map.removeInteraction(scope.drawinteraction);                                      if (scope.helpTooltipElement ! [description]
         * @return {[type]}          [description]
         */
        /*$rootScope.$on('ngDialog.closed', function (e, $dialog) {
                                      console.log('ngDialog closed: ' );
                                      scope.map.un('pointermove',fct );
                                      if (scope.drawinteraction != null)
                                      {
                                        scope.map.removeInteraction(scope.drawinteraction);
                                      }
                                      if (scope.helpTooltipElement != null)
                                      {
                                        scope.helpTooltipElement.remove();
                                      }
                                     scope.map.getOverlays().clear();
                                      scope.helpTooltipElement = null;
                                      
                                      gclayers.getDrawLayer().getSource().clear();

                            });   */

        scope.reset = function() {
          scope.map.un('pointermove', fct);
          if (scope.drawinteraction != null) {
            scope.map.removeInteraction(scope.drawinteraction);
          }
          if (scope.helpTooltipElement != null) {
            scope.helpTooltipElement.remove();
          }
          scope.map.getOverlays().clear();
          scope.helpTooltipElement = null;

          gclayers
            .getMeasureLayer()
            .getSource()
            .clear();
        };
        /**
         * format length output
         * @param {ol.geom.LineString} line
         * @return {string}
         */
        scope.formatLength = function(line) {
          var length;
          if (true) {
            var coordinates = line.getCoordinates();
            length = 0;
            var sourceProj = map.getView().getProjection();
            for (var i = 0, ii = coordinates.length - 1; i < ii; ++i) {
              var c1 = ol.proj.transform(
                coordinates[i],
                sourceProj,
                'EPSG:4326'
              );
              var c2 = ol.proj.transform(
                coordinates[i + 1],
                sourceProj,
                'EPSG:4326'
              );
              length += wgs84Sphere.haversineDistance(c1, c2);
            }
          } else {
            length = Math.round(line.getLength() * 1000) / 100;
          }
          var output;
          if (length > 1000) {
            output = Math.round((length / 1000) * 100) / 100 + ' ' + 'km';
          } else {
            output = Math.round(length * 1000) / 100 + ' ' + 'm';
          }
          return output;
        };

        /**
         * format length output
         * @param {ol.geom.Polygon} polygon
         * @return {string}
         */
        scope.formatArea = function(polygon) {
          var area;
          if (true) {
            var sourceProj = map.getView().getProjection();
            var geom = /** @type {ol.geom.Polygon} */ (polygon
              .clone()
              .transform(sourceProj, 'EPSG:4326'));
            var coordinates = geom.getLinearRing(0).getCoordinates();
            area = Math.abs(wgs84Sphere.geodesicArea(coordinates));
          } else {
            area = polygon.getArea();
          }
          var output;
          if (area > 10000) {
            output =
              Math.round((area / 10000) * 100) / 100 +
              ' ' +
              'km<sup>2</sup>' +
              area;
          } else {
            output = Math.round(area * 100) / 100 + ' ' + 'm<sup>2</sup>';
          }
          return output;
        };
        /**
         * Handle pointer move.
         * @param {ol.MapBrowserEvent} evt
         */
        //scope.pointerMoveHandler =
        scope.createHelpTooltip = function() {
          if (scope.helpTooltipElement) {
            scope.helpTooltipElement.parentNode.removeChild(
              scope.helpTooltipElement
            );
          }
          scope.helpTooltipElement = document.createElement('div');
          scope.helpTooltipElement.className = 'tooltip';
          scope.helpTooltip = new ol.Overlay({
            element: scope.helpTooltipElement,
            offset: [15, 0],
            positioning: 'center-left',
          });
          scope.map.addOverlay(scope.helpTooltip);
        };

        /**
         * Creates a new measure tooltip
         */
        scope.createMeasureTooltip = function() {
          if (scope.measureTooltipElement) {
            scope.measureTooltipElement.parentNode.removeChild(
              scope.measureTooltipElement
            );
          }
          scope.measureTooltipElement = document.createElement('div');
          scope.measureTooltipElement.className = 'tooltip tooltip-measure';
          scope.measureTooltip = new ol.Overlay({
            element: scope.measureTooltipElement,
            offset: [0, -15],
            positioning: 'bottom-center',
          });
          scope.map.addOverlay(scope.measureTooltip);
        };

        /**
         * [measurelength description]
         * @return {[type]} [description]
         */
        scope.measure = function(type, btnid) {
          console.log(btnid);
          var map = scope.map;
          map.updateSize();
          map.removeInteraction(scope.drawinteraction);
          var btnElt = element.find('#' + btnid);
          if (btnid == 'length') {
            var btnEltother = element.find('#area');
            btnEltother.removeClass('btn-info');
            btnEltother.addClass('btn-default');
            //scope.isActive =false;
          } else {
            btnEltother = element.find('#length');
            btnEltother.removeClass('btn-info');
            btnEltother.addClass('btn-default');
            //scope.isActive =false;
          }
          if (scope.currentmode == btnid) {
            scope.currentmode = '';
          } else {
            scope.currentmode = btnid;
            scope.isActive = false;
          }
          btnElt = element.find('#' + btnid);
          /**
           * Gestion du bouton
           */
          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
            map.un('pointermove', fct);
            scope.helpTooltipElement.remove();
            scope.helpTooltipElement = null;
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
            map.on('pointermove', fct);
          }
          /** la mesure  */
          if (scope.isActive) {
            scope.drawinteraction = new ol.interaction.Draw({
              source: gclayers.getMeasureLayer().getSource(),
              type: type,
              style: new ol.style.Style({
                fill: new ol.style.Fill({
                  color: 'rgba(255, 255, 255, 0.2)',
                }),
                stroke: new ol.style.Stroke({
                  color: 'rgba(0, 0, 0, 0.5)',
                  lineDash: [10, 10],
                  width: 2,
                }),
                image: new ol.style.Circle({
                  radius: 5,
                  stroke: new ol.style.Stroke({
                    color: 'rgba(0, 0, 0, 0.7)',
                  }),
                  fill: new ol.style.Fill({
                    color: 'rgba(255, 255, 255, 0.2)',
                  }),
                }),
              }),
            });

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'measure');
            map.on('pointermove', fct);
            map.addInteraction(scope.drawinteraction);

            scope.createMeasureTooltip();
            scope.createHelpTooltip();
            //on start
            scope.drawinteraction.on('drawstart', function(evt) {
              /*sketchFeature = evt.feature;*/
              scope.sketch = evt.feature;
              // console.log("drawstart");
            });

            // on end
            scope.drawinteraction.on('drawend', function(evt) {
              //scope.features = evt.feature;
              scope.measureTooltipElement.className = 'tooltip tooltip-static';
              scope.measureTooltip.setOffset([0, -7]);
              // unset sketch
              scope.sketch = null;
              // unset tooltip so that a new one can be created
              scope.measureTooltipElement = null;
              scope.createMeasureTooltip();
            });
          }
        };
      },
    };
  };

  measureDirective.$inject = ['gcPropertiesLayers', 'gclayers', '$rootScope'];
  return measureDirective;
});
