'use strict';
define(function() {
  var maFeature = function(
    FeatureTypeFactory,
    $q,
    ConfigFactory,
    FunctionFactory,
    $timeout,
    gclayers,
    gaJsUtils
  ) {
    function Feature(template, map, draw, getDefaultStyle, getAnnotationStyle) {
      var self = this;

      /*
       * Create a feature from a feature template
       */
      function createFeature(source) {
        var type = source.properties.featureType;
        var style = source.properties.styleTemplate;

        // Secure the properties
        if (type === 'text' && !source.properties.uid) {
          source.properties.uid = Math.round(Math.random() * 100000000);
        }
        if (type === 'Polygon' && style.opacity === undefined) {
          style.opacity = 100;
        }

        // Instantiate and style the feature
        var reader = new ol.format.GeoJSON();
        var layerFt = reader.readFeature(source);
        if (type !== 'text') {
          if (source.properties.styleGraphic) {
            if (source.properties.styleGraphic.textValue == undefined)
              source.properties.styleGraphic.textValue =
                source.properties.styleTemplate.text;
            if (source.properties.styleGraphic.text != 'Label') {
              var annStyle = getAnnotationStyle(
                type,
                source.properties.styleGraphic
              );
              if (annStyle != undefined) layerFt.setStyle(annStyle);
            }
          } else layerFt.setStyle(getDefaultStyle(type, style));
        }
        return layerFt;
      }

      /*
       * Change the opacity of the given style; it is currently the
       * only way of hiding an OpenLayers feature without removing it
       */
      function updateStyleOpacity(style, opacity) {
        function setOpacity(dest, prop) {
          if (!(dest[prop] && dest[prop]() && dest[prop]().getColor())) {
            return; // The property must have a color
          }
          //@ALI REACTIVATE
          // ol.color.asArray has a cache; we MUST NOT use it directly
          //var color = [].concat(ol.color.asArray(dest[prop]().getColor()));
          //color[3] = opacity;
          //est[prop]().setColor(color);
        }
        if (style != undefined) {
          // Update image style if any (type: 'Symbol' or 'Point')
          if (angular.isDefined(style.getImage)) {
            if (style.getImage()) style.getImage().setOpacity(opacity);
          }
          // Update text style if any (type: 'Label')
          if (angular.isDefined(style.getText)) {
            if (style.getText()) {
              var txt = style.getText();
              setOpacity(txt, 'getFill');
              setOpacity(txt, 'getStroke');
            }
          }
          // Update basic styles if any
          setOpacity(style, 'getFill');
          setOpacity(style, 'getStroke');
        }
        return style;
      }

      /**
       *     Calcul la lrgeur et la hauteur
       * de la bulle du texte à dessiner.
       *
       * @param { [[type]]} textValue     [[Chaine de caractères à écrire]]
       * @param { [[type]]} ratio [[rapport entre zoom level de référence
       *                           et celui de la carte actuelle]]
       * @return {[[type]]} [[largeur bulle, hauteur bulle,
       *                       nombre de ligne de texte]]
       */
      function getTextInfos(textValue, ratio) {
        var ind,
          width = 0,
          nbLignes,
          height;

        if (textValue.indexOf('\n') !== -1) {
          var ttt = textValue.split('\n');
          nbLignes = ttt.length;
          for (ind = 0; ind < nbLignes; ind++) {
            if (ttt[ind].length > width) width = ttt[ind].length;
          }
        } else {
          nbLignes = parseInt(1 + textValue.length / 60);
          if (textValue.length > 60) width = 60;
          else width = textValue.length;
        }

        //-- Récupération de la taille de la police en pixel.
        //-- Cette taille correspond au zoom level de création.
        var fontSize = self.properties.styleTemplate.fontSize;
        if (fontSize == undefined) fontSize = 16;

        //-- Calcul de la taille en mètre terrain
        //-- pour le niveau de zoom actuel.
        var fsMeter;
        fsMeter = map.getView().calculateExtent([fontSize, fontSize]);
        //-- Rapporter la taille en mètre au zoom de création.
        fontSize = (fsMeter[3] - fsMeter[1]) * ratio;

        width *= fontSize * 0.75;
        height = nbLignes * fontSize * 1.5;

        return [width, height, nbLignes];
      }

      /**
       *     Création de la géométrie de la bulle de l'annotation avec bulle.
       */
      self.annotTextFrame = function(ratio) {
        var ii, geom, x, y, x0, y0;
        var newFeat, nbLignes, width, height;
        var coords = [];

        var properties = self.vector.getProperties();
        var textValue;
        textValue = properties.styleTemplate.text;

        // Positionnement de l'accroche en [0,0] [scale(-0.5),scale(0.5)]
        var infos = getTextInfos(textValue, ratio);
        width = infos[0];
        height = infos[1];
        var scalingAccroche;
        if (height < width) scalingAccroche = 0.25 * height;
        else scalingAccroche = 0.25 * width;

        var mg = 0;
        nbLignes = infos[2];
        if (nbLignes > 1) mg = 0.3;
        //-- Préparation d'une bulle en coordonnées [0.0,0.0]
        //-- Dessin du début de l'accroche au point \/
        coords.push([0, 0]);
        coords.push([-scalingAccroche, scalingAccroche - mg]);

        var pi_2 = Math.PI / 2.0;

        //-- Dessin du coin bas gauche
        x0 = -(width / 2);
        y0 = 2 * scalingAccroche;
        if (nbLignes < 1) nbLignes = 1;
        for (ii = pi_2 + Math.PI; ii > Math.PI; ii -= 0.2) {
          x = x0 + scalingAccroche * Math.cos(ii);
          y = y0 + scalingAccroche * Math.sin(ii) - mg;
          coords.push([x, y]);
        }
        //-- Dessin du coin haut gauche
        x0 = -(width / 2);
        y0 = height + scalingAccroche / nbLignes;
        for (ii = Math.PI; ii > pi_2; ii -= 0.2) {
          x = x0 + scalingAccroche * Math.cos(ii);
          y = y0 + scalingAccroche * Math.sin(ii);
          coords.push([x, y]);
        }
        //-- Dessin du coin haut droit
        x0 = width / 2;
        y0 = height + scalingAccroche / nbLignes;
        for (ii = pi_2; ii > 0.0; ii -= 0.2) {
          x = x0 + scalingAccroche * Math.cos(ii);
          y = y0 + scalingAccroche * Math.sin(ii);
          coords.push([x, y]);
        }
        //-- Dessin du coin bas droit
        x0 = width / 2;
        y0 = 2 * scalingAccroche;
        for (ii = Math.PI + Math.PI; ii > (3.0 * Math.PI) / 2.0; ii -= 0.2) {
          x = x0 + scalingAccroche * Math.cos(ii);
          y = y0 + scalingAccroche * Math.sin(ii) - mg;
          coords.push([x, y]);
        }
        //-- Dessin de la fin de l'accroche au point \/
        coords.push([scalingAccroche, scalingAccroche - mg]);
        coords.push([0, -mg]);
        coords.push([0, 0]);

        //-- Placement de la bulle au point de positionnement.
        geom = self.vector.getGeometry().getCoordinates();
        x = geom[0];
        y = geom[1];
        for (ii = 0; ii < coords.length; ii++) {
          coords[ii][0] += x;
          coords[ii][1] += y;
        }

        var polygon = new ol.geom.Polygon([coords]);
        //-- Mise à l'échelle de la bulle.
        //sc = scale / 100;
        //polygon.scale(sc,sc,geom);
        //-- Création du polygone de la bulle.
        newFeat = new ol.Feature({
          geometry: polygon,
          name: 'Polygon',
          featureType: 'Polygon',
        });

        return [newFeat, -height * 0.15, nbLignes];
      };

      self.cleanVectorText = function() {
        if (self.vectorText) {
          if (
            self.vectorText.getId() != undefined &&
            draw.source.getFeatureById(self.vectorText.getId())
          ) {
            try {
              draw.source.removeFeature(self.vectorText);
            } catch (error) {
              console.error(error);
            }
          }
          delete self.vectorText;
        }
      };

      function getTextStrokeColorFromSg(sg) {
        var ind, cp;
        if (sg.Stroke == undefined && sg.stroke == undefined) return;
        //-- Cas des texte à bulle des mesures.
        if (sg.stroke) return sg.stroke.color;
        cp = sg.Stroke.CssParameter;
        return gaJsUtils.hexToRGB('#fbfdd7', 1);
      }

      function getTextStyleExtraParams(sg, ratio, properties, nbLignes) {
        var tsParams = {};
        var teta = (Math.PI * properties.styleGraphic.Rotation) / 180;
        tsParams.offsetX = (-Math.sin(teta) * 6 * ratio) / nbLignes;
        tsParams.offsetY = (Math.cos(teta) * 6 * ratio) / nbLignes;
        tsParams.textBaseline = 'bottom';
        tsParams.textStrokeWidth = 0;
        sg.textValue = properties.styleTemplate.text;

        return tsParams;
      }

      self.getId = function(feat) {
        if (self.id == undefined) {
          if (ol.getUid) {
            self.id = ol.getUid(feat);
          } else {
            self.id = gaJsUtils.getUid(feat);
          }
        }
        return self.id;
      };

      self.drawTextPolygon = function(ratio) {
        var feat2, res;
        var style, textStyle;

        if (ratio == undefined) ratio = 1.0;

        self.cleanVectorText();
        res = self.annotTextFrame(ratio);
        feat2 = res[0];
        if (feat2) {
          feat2.setId(self.getId(feat2));
          //-- Préparation du style conenant
          //-- celui de la bulle et celui dutexte.
          var properties = self.vector.getProperties();
          var sg = angular.copy(properties.styleGraphic);

          textStyle = getAnnotationStyle(
            'text',
            sg,
            ratio,
            getTextStyleExtraParams(sg, ratio, properties, res[2])
          );
          //-- Mettre la couleur de fond de la bulle
          //-- comme couleur de détourage des caractères.
          /*
                    textStyle.getText().getStroke().setColor(
                                    textStyle.getText().getFill().getColor());
                    textStyle.getText().getStroke().setWidth(0);
                    */
          style = new ol.style.Style({
            fill: new ol.style.Fill({
              color: getTextStrokeColorFromSg(sg), //'rgb(0,143,239,0.5)'
            }),
            /*
                        "stroke": new ol.style.Stroke({
                            "width": 0.03,
                            //"color": getTextStrokeColorFromSg(sg)
                            "color": textStyle.getText().getFill().getColor()
                        }),*/
            text: textStyle.getText(),
          });
          //-- Affectation du style et mise en place
          //-- de la bulle à texte sur la carte.
          feat2.setStyle(style);
          if (sg.Rotation != undefined) {
            var oo = self.vector.getGeometry().getCoordinates();
            feat2.getGeometry().rotate(-(sg.Rotation * Math.PI) / 180, oo);
          }

          //-- Pour l'impression:
          var props = self.vector.getProperties();
          feat2.setProperties({
            styleGraphic: props.styleGraphic,
            styleTemplate: props.styleTemplate,
          });
          try {
            draw.source.addFeature(feat2);
          } catch (error) {
            console.error(error);
          }
          self.vectorText = feat2;
        }
      };

      // Set the visibility of a single feature
      self.setVisibility = function(style, ratio) {
        var opacity = Number(!!self.visible);
        // Retro-compatibility: 'text' annotations had no own style (null)
        //var stylex = self.vector.getStyle() || draw.layer.getStyle();
        //recuperer le style graphique des proprietes du feature
        //en fonction du type on cree le style openlayer a partir du style graphique
        var styleGraphic = self.vector.getProperties()['styleGraphic'];
        var type = self.vector.getGeometry().getType();
        if (
          self.properties.featureType === 'text' ||
          self.properties.featureType === 'Text' ||
          self.properties.featureType === 'Label'
        )
          type = 'text';
        if (style == undefined) {
          if (
            styleGraphic &&
            (type != 'text' || self.properties.featureType === 'Label')
          ) {
            if (
              self.properties.featureType === 'Label' &&
              self.vector.getStyle() &&
              self.vector.getStyle().getText()
            ) {
              var text = self.vector.getStyle().getText().text_;
              if (text !== undefined)
                self.properties.styleGraphic.textValue = text;
            }
            style = getAnnotationStyle(
              type,
              self.properties.styleGraphic,
              ratio
            );
          } else {
            style = self.vector.getStyle() || draw.layer.getStyle();
          }
        }

        if (
          (self.properties.featureType === 'text' ||
            self.properties.featureType === 'Text') &&
          self.getStyle() &&
          self.getStyle().text == 'Label'
        ) {
          self.drawTextPolygon(self.getRatio(self.getStyle()));
        }
        if (
          self.properties.featureType === 'Polygon' &&
          styleGraphic &&
          styleGraphic.opacity
        ) {
          if (style.getFill() != undefined) {
            //-- Remplissage non transparent.
            var colFill = style.getFill().getColor();
            if (colFill instanceof String) {
              var newCol;
              var newOpa = styleGraphic.opacity / 100;
              if (colFill.includes('#')) {
                newCol = gaJsUtils.hexToRGB(colFill, newOpa);
              } else {
                var arrcol = style
                  .getFill()
                  .getColor()
                  .split(',');
                var opa = arrcol[arrcol.length - 1];
                var oldOpa = opa.slice(0, -1);
                newCol = colFill.replace(oldOpa, newOpa);
              }
              style.getFill().setColor(newCol);
            }
          }
        }
        if (self.vectorText) self.vectorText.set('visible', self.visible);
        else self.vector.set('visible', self.visible);

        if (
          self.properties.featureType === 'Polygon' &&
          self.visible &&
          typeof self.properties.styleTemplate.opacity === 'number'
        ) {
          opacity = self.properties.styleTemplate.opacity / 100;
        }

        if (self.properties.featureType != 'text' && !self.vectorText) {
          var vecStyle = updateStyleOpacity(style, opacity);
          if (vecStyle != undefined) self.vector.setStyle(vecStyle);
        }
      };

      self.showHide = function() {
        self.visible = !self.visible; // toggle
        self.setVisibility();
      };

      self.zoomTo = function() {
        var extent = self.vector.getGeometry().getExtent();
        map.getView().fit(extent, map.getSize());
      };

      self.source = function() {
        return template;
      };

      self.getOlSource = function() {
        return draw.source;
      };

      self.update = function(newTemplate) {
        template = newTemplate;
        // Clean the template
        delete template.properties.selected;
        if (template.visible === undefined) {
          template.visible = true;
        }

        var found;
        if (draw.source)
          found = draw.source.getFeatures().some(function(olFeat) {
            if (self.vector === olFeat) {
              draw.source.removeFeature(olFeat);
              return true;
            }
          });
        angular.extend(self, template);
        self.template = template;

        self.vector = createFeature(template);
        if (found) {
          draw.source.addFeature(self.vector);
          self.setVisibility();
        }
      };

      self.getRatio = function(style) {
        var ratio;
        if (self.properties.styleTemplate==undefined){
          return 1.0;
        }
        var zl = self.properties.styleTemplate.zoomLevel;
        var differentialAmountScaled = zl - map.getView().getZoom();

        // scale des properties
        var ratio;
        if (style.fixedSize) ratio = 1.0;
        else if (differentialAmountScaled) {
          ratio = Math.pow(2, Math.abs(differentialAmountScaled));
          if (differentialAmountScaled > 0) ratio = 1 / ratio;

          // scale text
          if (
            style.text &&
            style.text.font &&
            style.text.font.indexOf('px') !== -1
          ) {
            var currFontSize = parseInt(style.text.font);
            var newFontSize =
              differentialAmountScaled > 0
                ? currFontSize / ratio
                : currFontSize;
            style.text.font = style.text.font.replace(
              currFontSize,
              newFontSize
            );
          }
        }
        return ratio;
      };

      self.getStyle = function() {
        var theStyle;
        if (angular.isDefined(self.properties.styleGraphic)) {
          if (
            self.properties.styleGraphic.text == 'Label' ||
            self.properties.featureType != 'Text'
          )
            theStyle = angular.copy(self.properties.styleGraphic);
          if (
            self.properties.styleTemplate.text != undefined &&
            self.properties.styleTemplate.text != ''
          )
            theStyle.textValue = self.properties.styleTemplate.text;
          return theStyle;
        } else {
          return angular.copy(self.properties.styleTemplate);
        }
      };

      self.updateScale = function(selectedFeature, theScope) {
        //        if (self.vector==selectedFeature) return;
        if (
          angular.isUndefined(self.properties) ||
          angular.isUndefined(self.properties.styleTemplate) ||
          angular.isUndefined(self.properties.featureType)
        )
          return;
        var type = self.properties.featureType;

        // osef
        if (!angular.isDefined(self.properties.styleTemplate.zoomLevel)) return;

        var zoomStyle, ratio, res, textStyle;
        var style = self.getStyle();
        ratio = self.getRatio(style);
        if (angular.isDefined(self.properties.styleGraphic)) {
          if (type == 'Label') type = 'text';
          zoomStyle = getAnnotationStyle(type, style, ratio);
        } else {
          zoomStyle = getDefaultStyle(type, style);
        }
        /*
                if (style.text=="text") {
                    if (self.visible)
                        self.drawTextPolygon(ratio);
                }
                else {
                            */
        if (self.vector == selectedFeature)
          theScope.styleOfSelectedFeature = zoomStyle;
        else {
          if (!self.vectorText) self.vector.setStyle(zoomStyle);
          self.setVisibility(zoomStyle, ratio);
        }
      };

      // Instanciation
      if (template instanceof ol.Feature) {
        // The template is the vector feature
        self.vector = template;
        if (template.getStyle && template.getStyle() != null && template.getStyle().text)
          self.vector.getStyle().text = template.getStyle().text;
        if (template.fill) self.vector.getStyle().fill = template.fill;
        var writer = new ol.format.GeoJSON({});
        template = writer.writeFeatureObject(self.vector);
        template.visible = true;
        angular.extend(self, template);
      } else {
        // The template is a KIS template
        self.update(template);
      }

      // Unselected by default
      self.properties.selected = false;
      self.vector.set('selected', false);
    }

    return {
      Feature: Feature,
    };
  };

  maFeature.$inject = [
    'FeatureTypeFactory',
    '$q',
    'ConfigFactory',
    'FunctionFactory',
    '$timeout',
    'gclayers',
    'gaJsUtils',
  ];
  return maFeature;
});
