'use strict';
define(['ol3js', 'angular', 'toastr'], function(ol, angular, toastr) {
  var maAnnotation = function(
    FeatureTypeFactory,
    $q,
    ConfigFactory,
    FunctionFactory,
    $timeout,
    ParametersFactory,
    $filter,
    $rootScope,
    gclayers,
    maUtils
  ) {
    /*
     * Very big object to manage an Annotation
     */
    function Annotation(
      template,
      scope,
      AnnotationFeatures,
      AnnotationSelection,
      draw,
      id
    ) {
      var self = this;
      this.annId = id;

      /**
       *     Déplace le point d'ancrage de la ulle de texte
       * au premier point de la géométrie du feature reçu
       * en paramétre.
       * Le feature reçu en paramètre doit être la géométrie
       * de la bulle de texte à sa nouvelle position.
       */
      self.moveVectorText = function(olFeat) {
        let isTipText = false;
        self.features.forEach(function(feat) {
          var geom, coord;

          if (feat.vectorText == olFeat) {
            //-- Le maFeature est bien celui de la bulle de texte déplacé.
            //-- Récupération de la nouvelle position.
            coord = olFeat.getGeometry().getCoordinates()[0][0];
            //-- Modification du point d'ancrage.
            geom = new ol.geom.Point(coord);
            feat.vector.setGeometry(geom);
            isTipText = true;
          }
        });
        return isTipText;
      };

      /**
       *     Retourne VRAI si le paramétre "olFeat"
       * est un texte à bulle, FAUX sinon.
       */
      self.isTexteABulle = function(olFeat) {
        var iFts,
          fts = self.features;

        if (olFeat == undefined) return false;
        for (var iFts = 0; iFts < fts.length; iFts++) {
          if (
            fts[iFts].vectorText != undefined &&
            (fts[iFts].vectorText == olFeat ||
              fts[iFts].vectorText.getId() == olFeat.getId())
          ) {
            return true;
          }
        }
        return false;
      };
      /**
       *     Retourne VRAI si le paramétre "olFeat"
       * est un texte à bulle, FAUX sinon.
       */
      self.getPointFeatureOfTexteABulle = function(olFeat) {
        var iFts,
          fts = self.features;

        for (var iFts = 0; iFts < fts.length; iFts++) {
          if (
            fts[iFts].vectorText != undefined &&
            (fts[iFts].vectorText == olFeat ||
              fts[iFts].vectorText.getId() == olFeat.getId())
          ) {
            return fts[iFts].vector;
          }
        }
        return undefined;
      };

      // Show the annotation
      self.show = function(force) {
        if (!self.isHidden && !force) {
          return;
        }
        self.isHidden = false;
        self.features.forEach(function(feat) {
          feat.getRatio(feat.getStyle());
          feat.setVisibility();
          if (feat.properties.featureType!=undefined && feat.properties.featureType.toLowerCase() == 'text') {
            gclayers.getAnnoText().push(feat);
          }
          if (draw.source != undefined && feat.vectorText == undefined)
            try {
              draw.source.addFeature(feat.vector);
            } catch (e) {}
        });
      };
      //supprimer un element d'un tableau
      function removeItem(array, item) {
        for (var i in array) {
          if (array[i] == item) {
            array.splice(i, 1);
            break;
          }
        }
      }

      // Hide the annotation
      self.hide = function() {
        if (self.isHidden) {
          return;
        }
        self.isHidden = true;
        var source = draw.source;
        //                    };
        self.features.forEach(function(feat) {
          //-- Cas d'une bulle de texte, à condition
          //-- que le polygone existe topujours
          //-- dans la source openlayers.

          if (feat.properties.featureType!=undefined && feat.properties.featureType.toLowerCase() == 'text') {
            removeItem(gclayers.getAnnoText(), feat);
          }

          if (
            feat.properties.featureType == 'text' &&
            feat.vectorText != undefined &&
            source.getFeatureById(feat.vectorText.getId())
          ) {
            try {
              source.removeFeature(feat.vectorText);
            } catch (e) {}
          }
          if (feat.overlay) {
            scope.map.removeOverlay(feat.overlay);
          }
          if (source != undefined)
            source.getFeatures().some(function(olFeat) {
              if (olFeat === feat.vector || olFeat === feat.vectorText) {
                try {
                  source.removeFeature(olFeat);
                } catch (e) {}
                return true;
                //}
              }
            });
        });
        $timeout(function() {
          draw.layer.setVisible(false);
          draw.layer.setVisible(true);
        }, 10);
      };

      // Toggle annotation visibility
      self.showHide = function showHide(visible) {
        if (visible !== undefined) {
          self.visible = visible;
        }
        self[self.visible ? 'show' : 'hide']();
        let map = scope.map;
        let z = map.getView().getZoom();
        map.getView().setZoom(z - 1);
        map.getView().setZoom(z);
      };

      // Toggle annotation visibility
      self.toggleActivation = function toggleActivation() {
        self.svisible = !self.svisible;
        self.writeData();
        angular.extend(template.data, {
          zoom: scope.map.getView().getZoom(),
          center: scope.map.getView().getCenter(),
          srid: scope.map
            .getView()
            .getProjection()
            .getCode(),
        }); // Don't write zoom and center anywhere else
        // If the annotation is not already in the list

        ParametersFactory.getbyid(self.id).then(function(res) {
          res.data.data = template.data;
          ParametersFactory.update(res.data, self.id).then(function() {
            toastr.success($filter('translate')('common.updated'));
          });
        });
      };

      // Control visibility with the given scale
      self.showByScale = function showByScale(scale) {
        if (!self.visible) {
          return false;
        }
        if (scale <= self.maxScale && scale >= self.minScale) {
          self.show();
          return true;
        } else {
          self.hide();
          return false;
        }
      };

      self.clearAnnotationPolygon = () => {
        var ind, feats;
        for (var i = 0; i < self.features.length; i++) {
          if (self.features[i].vectorText) {
            feats = draw.source.getFeatures();
            for (ind = 0; ind < feats.length; ind++) {
              if (feats[ind] == self.features[i].vectorText)
                try {
                  draw.source.removeFeature(feats[ind]);
                } catch (error) {
                  console.log(error);
                }
            }
          }
        }
      }

      self.setScaling2 = function(
        diff,
        selectedFeature,
        theScope,
        onlyTipTexts
      ) {
        if (diff == undefined) return;

        self.clearAnnotationPolygon();
        for (var i = 0; i < self.features.length; i++) {
          if (!angular.isDefined(self.features[i].properties)) continue;
          if (onlyTipTexts && !maUtils.featureIsTipText(self.features[i]))
            continue;

          if (self.visible || self.open) {
            self.features[i].id = self.annId * 10000 + i;
            self.features[i].updateScale(selectedFeature, theScope);
          }
        }
      };

      // Write the annotation data
      self.writeData = function writeData() {
        var writer = new ol.format.GeoJSON({});
        template.data = writer.writeFeaturesObject(self.features.vectors());
        for (var i = 0; i < self.features.vectors().length; i++) {
          if (self.features[i].properties.featureType === 'Label') {
            var text;
            if (template.data.features[i].properties.styleGraphic) {
              text =
                template.data.features[i].properties.styleGraphic.textValue;
              self.features[i].properties.styleGraphic.textValue = text;
            } else {
              //-- Récupération d'une annotation de type texte
              //-- de la version précédente.
              self.features[
                i
              ].properties.styleGraphic = scope.getCurrentDefaultStyle('Text');
              self.features[i].properties.styleGraphic.textValue =
                self.features[i].properties.styleTemplate.text.text;
            }
          }
          template.data.features[i].properties = self.features[i].properties;
        }

        angular.extend(template.data, {
          description: self.description,
          visible: self.visible,
          minScale: self.minScale,
          maxScale: self.maxScale,
          svisible: self.svisible,
        });
        angular.extend(template, {
          id: self.id,
          login: self.login,
          name: self.name,
        });
      };

      self.source = function source() {
        return template;
      };

      // Save the annotation
      self.save0 = function save() {
        if (scope.isEditActive) scope.isEditActive = false;
        if (scope.isGraphicActive) scope.isGraphicActive = false;
        if (scope.isRemoveActive) scope.isRemoveActive = false;
        if (scope.isEditTooltip) scope.isEditTooltip = false;
        scope.map.un('click', scope.modifyTooltip);
        scope.onModifyGraphicEnd();
        draw.features.clear();
        if (draw) draw.stop();
      };

      // Save the annotation
      self.save = function save() {
        if (scope.isEditActive) scope.isEditActive = false;
        if (scope.isGraphicActive) scope.isGraphicActive = false;
        if (scope.isRemoveActive) scope.isRemoveActive = false;
        if (scope.isEditTooltip) scope.isEditTooltip = false;
        scope.map.un('click', scope.modifyTooltip);
        scope.onModifyGraphicEnd();
        draw.features.clear();
        if (draw) draw.stop();
        if (scope.menuContext && scope.menuContext.length >= 3) {
          scope.menuContext.splice(0, scope.menuContext.length - 2);
        }
        self.writeData();
        angular.extend(template.data, {
          zoom: scope.map.getView().getZoom(),
          center: scope.map.getView().getCenter(),
          srid: scope.map
            .getView()
            .getProjection()
            .getCode(),
        }); // Don't write zoom and center anywhere else
        // If the annotation is not already in the list
        if (scope.annotations.indexOf(self) === -1) {
          scope.annotations.push(self);
        }
        if (self.visible != undefined)
          template.data.svisible = self.svisible = self.visible;
        if (self.id) {
          // Existing annotation, update
          ParametersFactory.getbyid(self.id).then(function(res) {
            res.data.data = template.data;
            ParametersFactory.update(res.data, self.id).then(function() {
              toastr.success($filter('translate')('common.updated'));
              self.untouched = angular.copy(self.source());
            });
          });
        } else {
          // New annotation, create (add)
          ParametersFactory.add(template.data, 'Annotation', self.name).then(
            function(res) {
              if (
                res.data ===
                'Ajout impossible: un paramétre avec le même nom existe déjà.'
              ) {
                toastr.error(res.data);
                return false;
              }
              toastr.success($filter('translate')('common.saved'));
              self.id = res.data.id;
              scope.list.fetch(false);
              self.untouched = angular.copy(self.source());
            }
          );
        }
      };

      /**
       *    Recherche d'un objet de type "maFeature"
       * à partir de la feature OpenLayers qui le compose.
       *
       * @param {Object} olFeature Feature OpenLayers
       */
      self.getMaFeatureFromFeat = function(olFeature) {
        var feat;
        for (var iFeat = 0; iFeat < self.features.length; iFeat++) {
          feat = self.features[iFeat];
          if (feat.vector == olFeature) {
            return feat;
          }
        }
      };

      /**
       *     Recherche de l'objet de type "maFeature" lié à l'objet
       * reçu en paramétre. Le cas de liaison d'objet apparaît pour
       * les bulles de textes qui contiennent des dimensions
       * d'une ligne ou d'un polygone.
       *
       * @param {Object} maFeature Objet de type maFeature
       */
      self.getLinkedMaFeatureFromFeat = function(maFeature) {
        var feat;
        var mfLinkId = maFeature.properties.linkId;
        for (var iFeat = 0; iFeat < self.features.length; iFeat++) {
          feat = self.features[iFeat];
          if (feat != maFeature && feat.properties.linkId == mfLinkId) {
            return feat;
          }
        }
      };

      self.getExtent = function() {
        let extent = ol.extent.createEmpty();
        for (let iMaFeat = 0; iMaFeat < self.features.length; iMaFeat++) {
          ol.extent.extend(
            extent,
            self.features[iMaFeat].vector.getGeometry().getExtent()
          );
          if (self.features[iMaFeat].vectorText)
            ol.extent.extend(
              extent,
              self.features[iMaFeat].vectorText.getGeometry().getExtent()
            );
        }
        if (extent[0] != Infinity) return extent;
      };

      self.reset = function(state) {
        if (self.features) {
          self.hide();
        }
        self.features = new AnnotationFeatures(
          state.data.features || [],
          scope.map
        );
        self.selection = new AnnotationSelection(self.features);
        if (draw.features != undefined) draw.features.clear();
        angular.extend(self, {
          id: state.id || false,
          login: state.login || $rootScope.xgos.user.login,
          name: state.name || '',
          description: state.data.description || '',
          visible: state.data.visible || false,
          zoom: state.data.zoom || scope.map.getView().getZoom(),
          center: state.data.center || scope.map.getView().getCenter(),
          minScale: state.data.minScale || 0,
          maxScale: state.data.maxScale || Infinity,
        });
        self.isHidden = !self.visible;
        self.writeData();
        self.untouched = angular.copy(self.source());

        // update scale !
      };

      self.reset(template);
    }

    return {
      Annotation: Annotation,
    };
  };

  maAnnotation.$inject = [
    'FeatureTypeFactory',
    '$q',
    'ConfigFactory',
    'FunctionFactory',
    '$timeout',
    'ParametersFactory',
    '$filter',
    '$rootScope',
    'gclayers',
    'maUtils',
  ];
  return maAnnotation;
});
