define([
  'angular',
  'widgets/mapapp/mapannotations/directives/mapannotationswidget',
  'widgets/mapapp/mapannotations/directives/maptoolbarannotations',
  'widgets/mapapp/mapannotations/directives/mapcolorbox',

  'widgets/mapapp/mapannotations/services/maFeature',
  'widgets/mapapp/mapannotations/services/maAnnotation',
  'widgets/mapapp/mapannotations/services/maStyle',
  'widgets/mapapp/mapannotations/services/maUtils',
], function(
  angular,
  mapannotationswidget,
  maptoolbarannotations,
  mapcolorbox,
  maFeature,
  maAnnotation,
  maStyle,
  maUtils
) {
  'use strict';

  // Angular module
  var gcmapannotations = angular.module('gc_map_annotations', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
  ]);

  // Services
  gcmapannotations.factory('maFeature', maFeature);
  gcmapannotations.factory('maAnnotation', maAnnotation);
  gcmapannotations.factory('maStyle', maStyle);
  gcmapannotations.factory('maUtils', maUtils);

  // Directives
  gcmapannotations.directive('mapgcannotationswidget', mapannotationswidget);
  gcmapannotations.directive('maptoolbarannotations', maptoolbarannotations);
  gcmapannotations.directive('mapcolorbox', mapcolorbox);

  // Filter for proper feature rotation in the UI
  gcmapannotations.filter('showMapDegrees', function() {
    var DEG_PER_RAD = 180 / Math.PI; // Degrees per radian
    return function(radians) {
      return Math.round(radians * DEG_PER_RAD) + ' °';
    };
  });

  return gcmapannotations;
});
