/**
 *
 */
'use strict';
define(function() {
  var gclayers = function() {
    var BackGroundLayer = [];
    var OperationalLayer = new ol.Collection();
    var OperationalLayerESRI = new ol.Collection();
    var TechnicalLayer = [];
    var SelectFilter = [];
    var layerHighlight = {};
    var layerSelect = {};
    var selectSource = {};
    var drawSource = {};
    var layerDraw = {};
    var layerMarker = {};
    var grouplayers = {};

    this.$get = function(
      $rootScope,
      gcPropertiesLayers,
      gcStyleFactory,
      gcWMS
    ) {
      var gcLayers = function() {
        (this.addGroupLayer = function(layer) {
          var themename = layer.theme ? layer.theme : 'Default';

          if (angular.isUndefined(grouplayers[themename])) {
            grouplayers[themename] = [];
          }
          grouplayers[themename].push(layer);

          /*if (!angular.isUndefined(grouplayers[layer.theme] ))
                     {

                     grouplayers[layer.theme].push(layer); ;
                     }
                     else
                     {

                     grouplayers[layer.theme] = [];

                     grouplayers[layer.theme].push(layer);
                     }*/
        }),
          (this.getGroupLayer = function(layer) {
            return grouplayers;
          }),
          (this.deleteGroupLayer = function(layer) {
            var deleteIndex = grouplayers[layer.theme]
              .map(function(x) {
                return x.name;
              })
              .indexOf(layer.name);
            grouplayers[layer.theme].splice(deleteIndex, 1);
          }),
          /**
           * [addBackGroundLayer description]
           * @param {[type]} layer [description]
           */
          (this.addBackGroundLayer = function(layer) {
            gcPropertiesLayers(layer);
            //BackGroundLayer = [];

            BackGroundLayer.push(layer);

            //selectFeatures = features;

            $rootScope.$broadcast('gcBackGroundLayerChange', layer);
          });
        this.getLayerProperties = function() {
          var res = [];
          OperationalLayer.forEach(function(l) {
            var a = [];
            angular.forEach(l, function(value, key) {
              a.push(key + ':' + value);
            });
            res.push(a);
          });

          return res;
        };

        this.addBackGroundLayerByDesc = function(baselayer) {
          if (baselayer.type == 'OSM') {
            //http://wxs.ign.fr/e4i6cff4ot440vro0byfkciw/geoportail/wmts?Layer=GEOGRAPHICALGRIDSYSTEMS.MAPS&style=normal&Style=normal&TileMatrixSet=PM&Service=WMTS&Request=GetTile&Version=1.0.0&Format=image%2Fjpeg&TileMatrix=8&TileCol=130&TileRow=90
            var nuages = new ol.layer.Tile({
              name: baselayer.name,
              label: baselayer.name,
              source: new ol.source.OSM({
                crossOrigin: 'Anonymous',
              }),
              theme: 'WebBackGround',
              visible: true,
              gctype: 'g2c',
            });

            this.addBackGroundLayer(nuages);
            // $rootScope.$broadcast('gcBackGroundLayerChange',nuages);

            //scope.map.addLayer(nuages)
          }

          if (baselayer.type == 'BING') {
            //key Ak-dzM4wZjSqTlzveKz5u0d4IQ4bRzVI309GxmkgSVr1ewS6iPSrOvOKhA-CJlm3
            //Ak-dzM4wZjSqTlzveKz5u0d4IQ4bRzVI309GxmkgSVr1ewS6iPSrOvOKhA-CJlm3http://wxs.ign.fr/e4i6cff4ot440vro0byfkciw/geoportail/wmts?Layer=GEOGRAPHICALGRIDSYSTEMS.MAPS&style=normal&Style=normal&TileMatrixSet=PM&Service=WMTS&Request=GetTile&Version=1.0.0&Format=image%2Fjpeg&TileMatrix=8&TileCol=130&TileRow=90
            var nuages = new ol.layer.Tile({
              name: baselayer.name,
              label: baselayer.name,
              visible: true,
              preload: Infinity,
              theme: 'WebBackGround',
              gctype: 'g2c',
              source: new ol.source.BingMaps({
                key: baselayer.key,
                imagerySet: baselayer.layer,
              }),
            });
            this.addBackGroundLayer(nuages);
            // $rootScope.$broadcast('gcBackGroundLayerChange',nuages);
          }
          if (baselayer.type == 'WMS') {
            var wms = new ol.layer.Tile({
              name: baselayer.name,
              label: baselayer.name,
              theme: 'WebBackGround',
              gctype: 'g2c',
              source: new ol.source.TileWMS({
                version: '1.1.1',
                url: baselayer.url,
                params: {
                  LAYERS: baselayer.layer,
                  TILED: true,
                  VERSION: '1.1.1',
                  FORMAT: 'image/jpeg',
                },
                serverType: 'geoserver',
              }),
            });
            this.addBackGroundLayer(wms);
          }
          if (baselayer.type == 'IGN') {
            var resolutions = [];
            var matrixIds = [];
            var proj3857 = ol.proj.get('EPSG:3857');
            var maxResolution = ol.extent.getWidth(proj3857.getExtent()) / 256;

            for (var i = 0; i < 18; i++) {
              matrixIds[i] = i.toString();
              resolutions[i] = maxResolution / Math.pow(2, i);
            }

            var tileGrid = new ol.tilegrid.WMTS({
              origin: [-20037508, 20037508],
              resolutions: resolutions,
              matrixIds: matrixIds,
            });
            //http://wxs.ign.fr/e4i6cff4ot440vro0byfkciw/geoportail/wmts?Layer=GEOGRAPHICALGRIDSYSTEMS.MAPS&style=normal&Style=normal&TileMatrixSet=PM&Service=WMTS&Request=GetTile&Version=1.0.0&Format=image%2Fjpeg&TileMatrix=8&TileCol=130&TileRow=90
            // API key valid for 'openlayers.org' and 'localhost'.
            // Expiration date is 06/29/2018.
            var key = '8x5snhe1rmiixxbsyz4uh418';

            var ign_source = new ol.source.WMTS({
              url: 'http://wxs.ign.fr/' + baselayer.key + '/wmts',
              layer: baselayer.layer /*'GEOGRAPHICALGRIDSYSTEMS.MAPS'*/,
              matrixSet: 'PM',
              format: 'image/jpeg',
              projection: 'EPSG:3857',
              tileGrid: tileGrid,

              style: 'normal',
              attributions: [
                new ol.Attribution({
                  html:
                    '<a href="http://www.geoportail.fr/" target="_blank">' +
                    '<img src="http://api.ign.fr/geoportail/api/js/latest/' +
                    'theme/geoportal/img/logo_gp.gif"></a>',
                }),
              ],
            });

            var ign = new ol.layer.Tile({
              name: baselayer.name,
              label: baselayer.name,
              theme: 'WebBackGround',
              gctype: 'g2c',
              source: ign_source,
            });
            this.addBackGroundLayer(ign);
            //$rootScope.$broadcast('gcBackGroundLayerChange',nuages);
            //gclayers.addBackGroundLayerByLabel("Bing Aerial et Label");
          }

          //selectFeatures = features;
        };
        this.getEditableLayer = function() {
          return OperationalLayer;
        };
        /**
         * [addToSelectFilter Add layer to selection filter ]
         * @param {[type]} layer [description]
         */
        this.addToSelectFilter = function(layer) {
          SelectFilter.push(layer);
        };

        this.removeSelectFilter = function(layer) {
          //console.log(layer.name);
          var deleteIndex = SelectFilter.map(function(x) {
            return x.name;
          }).indexOf(layer.name);
          SelectFilter.splice(deleteIndex, 1);
        };
        /**
         * [addToSelectFilter Add layer to selection filter ]
         * @param {[type]} layer [description]
         */
        this.getSelectFilterasString = function(att) {
          var res = '';
          SelectFilter.forEach(function(fType) {
            res = res + fType[att] + ',';
          });
          res = res.substr(0, res.length - 1);
          return res;
        };

        function fTypeMatchMapResolution(fType, map) {
          if (fType.maxScale == undefined && fType.minScale == undefined)
            return true;

          var mapResolution = map.getView().getResolution();
          var dpi = 25.4 / 0.28;

          if (fType.maxScale != undefined) {
            var ftiMaxResultion = parseFloat(fType.maxScale) / (39.37 * dpi);
            if (mapResolution > ftiMaxResultion) return false;
          }
          if (fType.minScale != undefined) {
            var ftiMinResultion = fType.minScale / (39.37 * dpi);
            if (mapResolution < ftiMinResultion) return false;
          }
          return true;
        }

        /**
         * [addToSelectFilter Add layer to selection filter ]
         * @param {[type]} layer [description]
         */
        this.getSelectFilterasStringuid = function(map) {
          var res = '';
          SelectFilter.forEach(function(fType) {
            if (fTypeMatchMapResolution(fType, map))
              res = res + fType['fti'].uid + ',';
          });
          res = res.substr(0, res.length - 1);
          return res;
        };
        /**
         * [addOperationalLayer description]
         * @param {[type]} layer [description]
         */
        this.addOperationalLayer = function(layer) {
          OperationalLayer.insertAt(layer.get('index'), layer);
          if (layer.selected) {
            this.addToSelectFilter(layer);
          }

          //console.log(layer.label);
          $rootScope.$broadcast('gcOperationalLayerChange', layer, 'add');
        };

        /**
         * clearOperationalLayer
         */
        this.clearOperationalLayer = function() {
          grouplayers = {};
          OperationalLayer.clear();
          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };

        /**
         * [createselectlayer Creation de la couche de selection]
         * @return {[type]} [description]
         */
        this.createselectlayer = function() {
          selectSource = new ol.source.Vector({
            format: new ol.format.GeoJSON(),
          });

          var wfs_layer = new ol.layer.Vector({
            source: selectSource,
            style: gcStyleFactory.getStyle('select'),
            label: 'Selection',
            name: 'Selection',
            theme: 'Techniques',
            gctype: 'g2c',
          });

          layerSelect = wfs_layer;

          TechnicalLayer.push(wfs_layer);
          gcPropertiesLayers(wfs_layer);
          $rootScope.$broadcast('gcTechnicalLayerChange', wfs_layer);

          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.createhighlightlayer = function(map) {
          layerHighlight = new ol.FeatureOverlay();
          layerHighlight.setMap(map);
          layerHighlight.setStyle(gcStyleFactory.getStyle('highlight'));
        };

        this.createeditlayer = function(map) {
          //drawSource  = new ol.source.GeoJSON(( {}));
          drawSource = new ol.source.Vector({
            format: new ol.format.GeoJSON(),
          });
          var wfs2_layer = new ol.layer.Vector({
            source: drawSource,
            style: gcStyleFactory.getStyle('edit'),
            label: 'Edition',
            name: 'Edition',
            theme: 'Techniques',
            gctype: 'g2c',
          });

          layerDraw = wfs2_layer;

          TechnicalLayer.push(wfs2_layer);
          gcPropertiesLayers(wfs2_layer);
          $rootScope.$broadcast('gcTechnicalLayerChange', wfs2_layer);
          /*layerDraw = new ol.FeatureOverlay();
                     layerDraw.setMap(map);
                     layerDraw.setStyle(gcStyleFactory.getStyle('edit'));
                     console.log("Creation layer edition");
                     console.log(layerDraw);*/
        };

        /**
         * [getSelectLayer description]
         * @return {[type]} [description]
         */
        this.getTechnicalLayer = function() {
          return TechnicalLayer;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getBackGroundLayer = function() {
          return BackGroundLayer;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };

        /**
         * ESRI layers
         */
        this.addOperationalLayerESRI = function(layer) {
          OperationalLayerESRI.insertAt(layer.get('index'), layer);
          if (layer.selected) {
            this.addToSelectFilter(layer);
          }

          //console.log(layer.label);
          $rootScope.$broadcast('gcOperationalLayerChange', layer, 'add');
        };

        /**
         * clearOperationalLayerESRI
         */
        this.clearOperationalLayerESRI = function() {
          grouplayers = {};
          OperationalLayerESRI.clear();
          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };

        this.getOperationalLayerESRI = function() {
          return OperationalLayerESRI.getArray();
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getOperationalLayerESRICollection = function() {
          return OperationalLayerESRI;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };

        this.getOperationalLayerESRIById = function(id) {
          var res = null;
          OperationalLayerESRI.forEach(function(ft) {
            if (ft.fti.uid == id) {
              res = ft.fti;
              //break;
            }
          });
          return res;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getOperationalLayerESRIByLayerName = function(name) {
          var res = null;
          OperationalLayerESRI.forEach(function(ft) {
            console.log(ft.fti, ft.fti.name, name);
            if (ft.fti.name == name) {
              res = ft;
              //break;
            }
          });
          return res;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getOperationalLayerESRIByName = function(name) {
          var res = null;
          OperationalLayerESRI.forEach(function(ft) {
            if (ft.fti.name == name) {
              res = ft.fti;
              //break;
            }
          });
          return res;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };

        this.getOperationalLayer = function() {
          return OperationalLayer.getArray();
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getOperationalLayerCollection = function() {
          return OperationalLayer;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.refreshlayerByid = function(id, map) {
          var layers = OperationalLayer.getArray();
          var l = null;
          layers.forEach(function(ft) {
            if (!angular.isUndefined(ft.fti)) {
              if (ft.fti.uid == id) {
                l = ft;
              }
            }
          });
          if (l != null) {
            $rootScope.$broadcast(
              'gcOperationalLayerChange',
              l,
              'refreshlayer'
            );
          }
        };
        this.getOperationalLayerById = function(id) {
          var res = null;
          OperationalLayer.forEach(function(ft) {
            if (ft.fti.uid == id) {
              res = ft.fti;
              //break;
            }
          });
          return res;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getOperationalLayerByLayerName = function(name) {
          var res = null;
          OperationalLayer.forEach(function(ft) {
            if (ft.fti.name == name) {
              res = ft;
              //break;
            }
          });
          return res;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getOperationalLayerByName = function(name) {
          var res = null;
          OperationalLayer.forEach(function(ft) {
            if (ft.fti.name == name) {
              res = ft.fti;
              //break;
            }
          });
          return res;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        /**
         * [getHighLightLayer description]
         * @return {[type]} [description]
         */
        this.getHighLightLayer = function() {
          return layerHighlight;
        };
        this.getDrawLayer = function() {
          return layerDraw;
        };
        this.getDrawSource = function() {
          return drawSource;
        };
        this.clearEditLayer = function() {
          drawSource.clear();
        };
        this.addhighLightFeatures = function(features) {
          var f = selectSource.getFeatureById(features);
          //console.log(f);
          //console.log(selectSource);
          layerHighlight.addFeature(f);
        };
        this.addhighLightFeature = function(f) {
          layerHighlight.addFeature(f);
        };

        this.removehighLightFeatures = function(features) {
          angular.forEach(layerHighlight.getFeatures(), function(feat, key) {
            console.log(features.getId());
            console.log(feat.getId());
            if (feat.getId() == features.getId()) {
              layerHighlight.removeFeature(feat);
            }
          });
          return layerHighlight.removeFeature(features);
        };
        this.clearhighLightFeatures = function() {
          angular.forEach(layerHighlight.getFeatures(), function(feat, key) {
            layerHighlight.removeFeature(feat);
          });
        };
        /**
         * [getMarkerLayer description]
         * @return {[type]} [description]
         */
        this.getMarkerLayer = function() {
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getselectSource = function() {
          return selectSource;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };
        this.getSelectLayer = function() {
          return layerSelect;
          //selectFeatures = features;
          //$rootScope.$broadcast('gcSelectChange');
        };

        // Event call when the selection change
      };
      return new gcLayers();
    };
    this.$get.$inject = [
      '$rootScope',
      'gcPropertiesLayers',
      'gcStyleFactory',
      'gcWMS',
    ];
  };
  return gclayers;
});
