/**
 *
 */
'use strict';
define(function() {
  var gcMapUtils = function() {
    this.$get = function() {
      var attributions = {};
      return {
        /**
         * Search for an overlay identified by bodId in the map and
         * return it. undefined is returned if the map does not have
         * such a layer.
         */
        getMapOverlayForBodId: function(map, bodId) {
          var layer;
          map.getLayers().forEach(function(l) {
            if (l.bodId == bodId && !l.background && !l.preview) {
              layer = l;
            }
          });
          return layer;
        },

        /**
         * Manage map attributions.
         */
        getAttribution: function(text) {
          var key = text;
          if (key in attributions) {
            return attributions[key];
          } else {
            var a = new ol.Attribution({ html: text });
            attributions[key] = a;
            return a;
          }
        },
       toGeometry: (g) =>{
          var feature = undefined;
            if (g.geometry && g.geometry.type) {
              switch (g.geometry.type) {
                case 'Point':
                  feature = new ol.Feature({
                    geometry: new ol.geom.Point(g.geometry.coordinates),
                  });
                  break;
                case 'MultiPoint':
                  feature = new ol.Feature({
                    geometry: new ol.geom.MultiPoint(g.geometry.coordinates),
                  });
                  break;
                case 'LineString':
                  feature = new ol.Feature({
                    geometry: new ol.geom.LineString(g.geometry.coordinates),
                  });
                  break;
                case 'MultiLineString':
                  feature = new ol.Feature({
                    geometry: new ol.geom.MultiLineString(
                      g.geometry.coordinates
                    ),
                  });
                  break;
                case 'Polygon':
                  feature = new ol.Feature({
                    geometry: new ol.geom.Polygon(g.geometry.coordinates),
                  });
                  break;
                case 'MultiPolygon':
                  feature = new ol.Feature({
                    geometry: new ol.geom.MultiPolygon(g.geometry.coordinates),
                  });
                  break;
              }
            }
          return feature;
        },
        altZoomInteraction: () => {
          let interaction = new ol.interaction.MouseWheelZoom();
          let oldFn = interaction.handleEvent;
          interaction.handleEvent = function(e) {
            var type = e.type;
            if (type !== "wheel" && type !== "wheel" ) {
              return true;
            }
            
            if (!e.originalEvent.altKey) {
              return true
            }

            oldFn.call(this,e);
          }
          return interaction;
      }

      };
    };
  };
  return gcMapUtils;
});
