'use strict';
define(function() {
  var majicLocalConsult = function(MajicFactory) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/majic/views/majicLocalConsult.html',
      restrict: 'E',

      // scope commun

      // methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        var idcommune = '';
        var idparcelle = '';

        // Initialize tabs
        scope.tabsLocalConsult = [
          {
            title: 'Habitat',
            authorized: scope.isBatimentAutorized,
          },
          {
            title: 'Dépendance et professionnel',
            authorized: scope.isBatimentAutorized,
          },
          {
            title: 'Exonérations',
            authorized: scope.isExonerationAutorized,
          },
          {
            title: 'Propriétaire',
            authorized: scope.isProprietairesAutorized,
          },
        ];
        scope.tabsLocalConsult.activeTab = 0;

        // Handler du changement de sélection d'onglet de consultation
        scope.$watch('tabsLocalConsult.activeTab', function(value) {
          idcommune = scope.batIdCommune;
          idparcelle = scope.batIdParcelle;
          if (scope.tabsLocalConsult.activeTab == 1) {
            VueDependance();
          } else if (scope.tabsLocalConsult.activeTab == 2) {
            VueLocalExo();
          } else if (
            (scope.tabsLocalConsult.activeTab == 2 &&
              !scope.isExonerationAutorized) ||
            scope.tabsLocalConsult.activeTab == 3
          ) {
            scope.getTheCoProp();
          }
        });

        var bHabi = false;
        scope.initLocalBoolean = function() {
          bHabi = false;
        };

        scope.initLocalView = function() {
          scope.tabsLocalConsult.activeTab = 0;

          if (scope.selectedParc == undefined) return;
          idcommune = scope.selectedParc.Parcelle.substr(0, 6);
          idparcelle = scope.selectedParc.Parcelle.substr(6);

          VueHabitat();
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Habitat
        // ///////////////////////////////////////////////////////////

        var habitatInfosResults = [];
        var iHab = 0;
        scope.habitatInfosResult = {};

        function VueHabitat() {
          if (bHabi == false) {
            if (idcommune != '') {
              bHabi = true;
              MajicFactory.gethabbyid(idcommune, idparcelle).then(
                function(res) {
                  habitatInfosResults = res.data;
                  changeHabitat(0);
                },
                function(reason) {
                  var resultObject = reason;
                  console.log('VueHabitat echec : ' + resultObject);
                  require('toastr').error('VueHabitat:' + resultObject);
                }
              );
            }
          }
        }

        function changeHabitat(i) {
          iHab = i;
          scope.habitatInfosResult = habitatInfosResults[iHab];
        }
        scope.HabPrec = function() {
          if (iHab <= 0) return;
          changeHabitat(--iHab);
        };
        scope.HabSuiv = function() {
          if (iHab >= habitatInfosResults.length - 1) return;
          changeHabitat(++iHab);
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Dependance
        // ///////////////////////////////////////////////////////////

        var depInfosResults = [];
        var idep = 0;
        scope.depInfosResult = {};

        function VueDependance() {
          if (idcommune != '') {
            MajicFactory.getdepbyid(idcommune, idparcelle).then(
              function(res) {
                if (res.data.length > 0) {
                  depInfosResults = res.data;
                  changeDependance(0);
                }
              },
              function(reason) {
                var resultObject = reason;
                console.log('VueDependance echec : ' + resultObject);
                require('toastr').error('VueDependance:' + resultObject);
              }
            );
          }
        }

        scope.VueDependance = function(pIdcommune, pIdparcelle) {
          idcommune = pIdcommune;
          idparcelle = pIdparcelle;
          VueDependance();
        };

        function changeDependance(i) {
          idep = i;
          scope.depInfosResult = depInfosResults[idep];
        }
        scope.depPrec = function() {
          if (idep <= 0) return;
          changeDependance(--idep);
        };
        scope.depSuiv = function() {
          if (idep >= depInfosResults.length - 1) return;
          changeDependance(++idep);
        };

        // ////////////////////////////////////////////////////////////
        // Onglet Exonérations
        // ///////////////////////////////////////////////////////////

        var localExoInfosResults = [];
        var iExol = 0;
        scope.localExoInfosResult = {};

        function VueLocalExo() {
          if (idcommune != '') {
            MajicFactory.getexolocbyid(idcommune, idparcelle).then(
              function(res) {
                localExoInfosResults = res.data;
                changeLocalExo(0);
              },
              function(reason) {
                var resultObject = reason;
                console.log('VueLocalExoneration echec : ' + resultObject);
                require('toastr').error('VueLocalExoneration:' + resultObject);
              }
            );
          }
        }

        function changeLocalExo(i) {
          iExol = i;
          scope.localExoInfosResult = localExoInfosResults[iExol];
        }
        scope.ExoLocPrec = function() {
          if (iExol <= 0) return;
          changeLocalExo(--iExol);
        };
        scope.ExoLocSuiv = function() {
          if (iExol >= localExoInfosResults.length - 1) return;
          changeLocalExo(++iExol);
        };
      },
    };
  };
  majicLocalConsult.$inject = ['MajicFactory'];
  return majicLocalConsult;
});
