'use strict';
define(function() {
  var gcMainController = function(
    $scope,
    $location,
    ConfigFactory,
    FeatureTypeFactory,
    gcWMS,
    $aside,
    gclayers,
    ngDialog,
    gcDirectivesList,
    panelsManager,
    $rootScope,
    $filter,
    PortalsFactory,
    BaseMapFactory,
    RolesFactory,
    SelectManager,
    gcPopup,
    QueryFactory,
    $timeout,
    ParametersFactory,
    ApplicationFactory,
    DataStoreFactory,
    gaJsUtils,
    UsersFactory,
    layersService,
    defaultFiltersFactory,
    GeolocalisationService,
    $q,
    extendedNgDialog
  ) {
    // TODO Recup id from URL
    function getParameterByName(name) {
      name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
      var regex = new RegExp('[\\?&]' + name + '=([^&#]*)'),
        results = regex.exec($location.$$absUrl);
      return results === null
        ? ''
        : decodeURIComponent(results[1].replace(/\+/g, ' '));
    }
    $scope.filterFunc = gaJsUtils.filterFunc;
    $scope.menuOptions = [
      [
        'Zoom +',
        function() {
          var view = $scope.map.getView();
          view.animate({
            duration: 1000,
            source: view.getCenter(),
            resolution: view.getResolution(),
          });
          view.setZoom(+view.getZoom() + 1);
        },
      ],
      [
        'Zoom -',
        function() {
          var view = $scope.map.getView();
          view.animate({
            duration: 1000,
            source: view.getCenter(),
            resolution: view.getResolution(),
          });
          view.setZoom(+view.getZoom() - 1);
        },
      ],
    ];

    /**
     * Définition de l'application courante à partir de l'URL et des applications de la factory.
     * Les applications de la factory ont été récupérées auparavant depuis le routeProvider.<br>
     * Il s'agit d'une fusion d'anciennes méthodes, <code>initProjection"</code> et <code>postGetDefaultProjection</code>
     * qui avaient pour but d'exécuter l'appel API pour récupérer les datastores, exécuter l'appel API pour récupérer les applications
     * avant de lancer une méthode pour modifier la projection d'une carte déjà créée avec une projection en dur par défaut.
     */
    function setCurrentApplication() {
      $scope.app = getParameterByName('app');
      if (ApplicationFactory.resources.applications.length > 0) {
        $scope.appData = ApplicationFactory.resources.applications.find(app => app.name === $scope.app);
      }
    }

    /**
     * Création de l'objet view de la map à partir du srid de l'application.<br>
     * Il s'agit de l'ancienne méthode <code>changeProjection"</code> mal nommée
     * qui modifiait la projection d'une carte déjà créée avec une projection en dur par défaut.
     * @param {string} srid projection de l'application MAP à charger
     * @param {boolean} applyToMap est true pour appliquer la vue à une carte existante dans le scope au moment de l'exécution
     * @return {ol.View} objet openlayers de la map définissant la projection de la carte
     */
    function createMapView(srid, applyToMap = false) {
      let mapView;
      if (!proj4.defs(srid) || !srid) {
        console.error('The proj4 definition ' + srid + ' not found ==> Stay with EPSG:3857');
        mapView = new ol.View({
          projection: 'EPSG:3857',
          center: [0, 0],
          minResolution: 0,
          zoom: 10,
        });
      }
      else {
        mapView = new ol.View({
          projection: srid,
          center: [0, 0],
          minResolution: 0,
          zoom: 10,
        });
      }
      if (applyToMap && $scope.map) {
        $scope.map.setView(mapView);
        $rootScope.$broadcast('mapViewChanged');
      }
      return mapView;
    }

    function createMap(view) {
      var attribution = new ol.control.Attribution({
        collapsible: false,
        className: 'g2c-attribution',
      });

      var map = new ol.Map({
        layers: [new ol.layer.Tile({})],
        controls: ol.control
          .defaults({
            attribution: false,
            rotate: true,
            zoom: false,
          })
          .extend([new ol.control.FullScreen(), attribution]),
        interactions: ol.interaction
          .defaults({
            altShiftDragRotate: true,
            touchRotate: false,
            keyboard: false,
          })
          .extend([new ol.interaction.DragZoom()]),

        renderer: 'canvas',
        target: 'map',
        view: view ? view : new ol.View({
          projection: 'EPSG:3857',
          center: [0, 0],
          minResolution: 0,
          zoom: 10,
        }),
        ol3Logo: false,
        logo: false,
      });
      $rootScope.$broadcast('mapViewChanged');
      /*
       *  Une fois la carte openlayers initialisée, il se peut que sa taille
       *  ne soit pas correcte (en hauteur). Il y a des cas de démarrage où
       *  elle ne prend pas les 100% de la fenêtre ... du coup,
       *  on reaffecte la hauteur une fois les initialisations faites.
       */
      map.once('postcompose', function() {
        $timeout(function() {
          map.setSize([map.getSize()[0], window.innerHeight]);
        }, 500);
      });

      /**
       * Used to return the main map app for components which cannot access the ngview (ie Calendar)
       * @returns {ol.Map}
       */
      $rootScope.xgos.getMapAppMap = function() {
        return map;
      };

      /**
       * [viewport description]
       * @type {ViewPort Openlayer}
       */
      var viewport = $(map.getViewport());
      map.on('dragstart', function() {
        viewport.addClass(dragClass);
      });
      map.on('dragend', function() {
        viewport.removeClass(dragClass);
      });
      return map;
    }

    $scope.currentuser = {};

    DataStoreFactory.get();
    setCurrentApplication();
    if ($scope.appData && $scope.appData.hasOwnProperty('outsrid')) {
      // on créé la view à partir de la projection de l'application avant de créer la map.
      // permet d'éviter de créer la map en 3857
      const view = createMapView($scope.appData.outsrid);
      $scope.map = createMap(view);
    }
    else {
      // aucune application ou application sans srid => on lance la map en 3857 et on affiche une alerte
      $scope.map = createMap();
      if (!$scope.appData) {
        require('toastr').error('Aucune application');
      }
      else if (!$scope.appData.hasOwnProperty('outsrid')) {
        require('toastr').warning('Aucune projection définie dans l\'application. \n Chargement de la projection EPSG:3857');
      }
    }

    $scope.DirectivesList = gcDirectivesList.listtools();
    $scope.ToolBarList = gcDirectivesList.listtoolbars();
    $scope.directivesMetaData = gcDirectivesList.listtoolsMetaData();
    if (
      $rootScope.xgos &&
      $rootScope.xgos.portal &&
      $rootScope.xgos.portal.name === 'AFFAIRES2'
    )
      $scope.ToolBarList.push({
        type: 'widget',
        title: 'Statistiques Affaires',
        name: 'statsaffairefilter',
        config: '',
        icone: 'fa fa-pie-chart',
      });
    // Roles DualListBox


    // -----------------------------------------------
    // transform the toolbars list (available toolbars)

    $scope.$watch(
      'toolsbarbutton',
      function(toolsbarbutton) {
        $scope.amountOfTools = 0;
        toolsbarbutton.forEach(function(tb, index) {
          $scope.ToolBarList.forEach(function(available) {
            if (index == 0) {
              delete available.used;
              delete available.position;
            }
            if (available.name == tb.name) {
              available.used = true;
              available.position = index;
              available.roles = tb.roles;
              $scope.amountOfTools++;
            }
          });
        });
      },
      1
    );

    $scope.tools = [];
    $scope.mode = getParameterByName('mode');
    localStorage.setItem('mode', $scope.mode);

    var keyboardPan = new ol.interaction.KeyboardPan({
      /*condition: function() {
             return (true);
             }*/
    });

    /**
     * applyMapParametersFromUrl (from urlsharing widget)
     * Some parameters (bbox,visible layers or selected objects...) may be passed in the url
     * extract and apply
     */
    var applyMapParametersFromUrl = function() {
      if ($location.search().fuid) {
        var url_fuid = $location.search().fuid.split(',');
        gclayers.getOperationalLayerg2c().forEach(function(layer) {
          layer.setVisible(false);
          url_fuid.forEach(function(fuid) {
            if (layer.fti.uid == fuid) layer.setVisible(true);
          });
        });
        $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
      }

      // fid
      if ($location.search().fid) {
        $timeout(function() {
          var url_fid = [];
          $location
            .search()
            .fid.split(';')
            .forEach(function(f) {
              var fids_name = f.split(':');
              fids_name[1].split(',').forEach(function(fid) {
                var feature_id = fids_name[0] + '.' + fid;
                url_fid.push(feature_id);
              });
            });
          var groupe_ids;
          var featureCollection;
          var index = 0;
          getFeaturesWithReadAuthorization(FeatureTypeFactory.resources.featuretypes)
            .forEach(function(fType) {
              groupe_ids = [];
              url_fid.forEach(function(fid) {
                if (fType.name == fid.split('.')[0]) {
                  groupe_ids.push(fid);
                }
              });

              if (groupe_ids.length > 0) {
                QueryFactory.get(
                  fType.uid,
                  groupe_ids.toString()
                ).then((res) => {
                  if (index == 0) {
                    featureCollection = res.data;
                    index++;
                  }
                  else {
                    res.data.features.forEach(function(f) {
                      featureCollection.features.push(f);
                    });
                  }
                  featureCollection.totalFeatures =
                    featureCollection.features.length;
                  SelectManager.addFeaturesFromGeojson(featureCollection);
                });
              }
            });

          var pop = gcPopup.open({
            scope: $scope,
            title: 'Informations : ',
            content: '<div selectfeaturetreewidget></div>',
            showClose: true,
            onclose: function() {
              SelectManager.clear();
            },
          });

          SelectManager.setpop(pop);
        });
      }

      // Clause where passée dans l'url sous la forme
      // fid:attr=v1,v2,v3...;fid2:attr2=v1,v2,v3
      if ($location.search().where) {
        let promises = [];
        $timeout(function() {
          var toRetrieve = {};
          $location
            .search()
            .where.split(';')
            .forEach(function(f) {
              var searchOnFti = f.split(':'),
                fid = searchOnFti[0],
                paramValue = searchOnFti[1];

              var x = {};
              var u = paramValue.split('=');
              x[u[0]] = u[1].split(',');

              toRetrieve[fid] = x;
            });

          getFeaturesWithReadAuthorization(FeatureTypeFactory.resources.featuretypes).forEach(function(fType) {
            // requete sur ce composant
            if (Object.keys(toRetrieve).indexOf(fType.name) != -1) {
              var mWhere = '';
              for (var i in toRetrieve[fType.name]) {
                var ftiAttribute = fType.attributes.filter(function(x) {
                  return x.name == i;
                });

                if (ftiAttribute.length == 1) {
                  var simpleType = gaJsUtils.getSimpleAttributeType(
                    ftiAttribute[0]
                  );
                  if (simpleType == 'number' || simpleType == 'boolean') {
                    mWhere +=
                      ' ' +
                      i +
                      ' IN (' +
                      toRetrieve[fType.name][i].join(',') +
                      ') ';
                  }
                  else {
                    mWhere +=
                      ' ' +
                      i +
                      ' IN (\'' +
                      toRetrieve[fType.name][i].join('\',\'') +
                      '\') ';
                  }
                }
                else {
                  require('toastr').error(
                    'Aucun attribut ' + i + ' dans la couche ' + fType.name
                  );
                }
              }

              if (mWhere != '') {
                var promise = QueryFactory.data(
                  fType.uid,
                  mWhere,
                  $scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                );
                promises.push(promise);
              }
            }
          });

          $q.all(promises).then((resList)=>{
            let featureCollection = null;
            for (const res of resList) {
              if (!featureCollection) {
                featureCollection = res.data;
              } else {
                featureCollection.features.push(...res.data.features);
              }
            }
            if(featureCollection && Array.isArray(featureCollection.features) && featureCollection.features.length>0){
              if($location.search().form){
                openForm(featureCollection);
              }else{
                openTreeWidget(featureCollection);
              }
            }else{
              require('toastr').error(
                $filter('translate')('map_config.clausewhere.nodata').replace("$1",$location.search().where)
              );
            }
          })
        });
      } else if($location.search().form){
        openForm();
      }

      // Extra parameters from URL
      // bbox
      if ($location.search().bbox) {
        var url_bbox = $location
          .search()
          .bbox.split(',')
          .map(function(x) {
            return parseFloat(x);
          });
        $timeout(function() {
          $scope.map.getView().fit(url_bbox, $scope.map.getSize());
        });
      }
    };

    const openTreeWidget = (featureCollection) => {
      featureCollection.totalFeatures = featureCollection.features.length;
      SelectManager.addFeaturesFromGeojson(featureCollection);
      const pop = gcPopup.open({
        scope: $scope,
        title: 'Informations : ',
        content: '<div selectfeaturetreewidget></div>',
        showClose: true,
        onclose: function() {
          SelectManager.clear();
        },
      });

      SelectManager.setpop(pop);
    }

    const openForm = (featureCollection) => {
      if(!featureCollection || featureCollection.features.length === 1){
        const formParam = $location.search().form.split(";");
        ConfigFactory.get(formParam[0], formParam[1])
        .then((res) => {
          const mscope = $rootScope.$new(true);
          mscope.ftemplatedata = res.data;

          if (!res.data) {
            if(featureCollection){
              openTreeWidget(featureCollection);
            }
            require('toastr').error(
              $filter('translate')('map_config.clausewhere.noForm').replace("$1",$location.search().form)
            );
          }else{
            if(featureCollection){
              mscope.newobj = { current: featureCollection.features[0]};
            }
            mscope.map = $scope.map;

            const dialogConfig = {
              template: 'js/XG/modules/model/views/modals/modal.featuretypes.render.html',
              className: 'ngdialog-theme-plain width800 nopadding miniclose close-form-class',
              formOptions: res.data.options,
              closeByDocument: false,
              scope: mscope,
              scrollable: true,
              minWidth: '570px',
              minHeight: '400px',
              data: { minimizeProperty: true },
              minimizeMaximize: true,
              resizable: true,
              draggable: true,
            };

            mscope.dlgPopup = extendedNgDialog.open(dialogConfig);
          }
        }, () => {
          if(featureCollection){
            openTreeWidget(featureCollection);
          }
          require('toastr').error(
            $filter('translate')('map_config.clausewhere.formError').replace("$1",$location.search().form)
          );
        });
      }else{
        openTreeWidget(featureCollection);
        require('toastr').error(
          $filter('translate')('map_config.clausewhere.fromMoreThenOneFeature')
        );
      }
    }

    /**
     *
     */
    $scope.options = {};

    /**
     *
     */
    $scope.map.addInteraction(keyboardPan);
    //$scope.map.addInteraction(new ol.interaction.KeyboardZoom());
    //////////////////////////////////////////////
    /// INITIALISATION DES LAYERS DE LA MAP    ///
    //////////////////////////////////////////////
    // Ajout des couches du FeatureTypeFactory au systeme gclayer

    function getMainMapConfig(res, restoreMapFromAnc = false) {
      if (res.data !== '') {
        $scope.propmap = res.data;

        // KIS-3487: insère le nom de la couche de fond de carte active dans le service
        if (Array.isArray($scope.propmap.bcklayer) && $scope.propmap.bcklayer.length > 0) {
          BaseMapFactory.resources.activeBaseMap = $scope.propmap.bcklayer[0].name;
        }

        if (!angular.isUndefined($scope.propmap.extent) && !restoreMapFromAnc) {
          $scope.go($scope.propmap.extent);
          if (angular.isDefined($scope.propmap.zoom))
            $scope.map.getView().setZoom($scope.propmap.zoom);
        }
        if (!angular.isUndefined($scope.propmap.bcklayer)) {
          $scope.baselayers;
          if (
            $scope.propmap &&
            $scope.propmap.bcklayer &&
            $scope.propmap.bcklayer.length > 0
          )
            $scope.propmap.bcklayer = [
              $scope.propmap.bcklayer[$scope.propmap.bcklayer.length - 1],
            ];
          gclayers.forceClearBackgroundLayer();
          if (BaseMapFactory.resources.basemaps.length == 0) {
            BaseMapFactory.get().then(function() {
              $scope.baselayers = BaseMapFactory.resources.basemaps;
              $scope.propmap.bcklayer.forEach(function(ft) {
                $scope.baselayers.forEach(function(bl) {
                  // -- Seul OSM utilise la propriété label.
                  // -- Il faut utiliser la propriété name pour identifier un fond de plan.
                  // -- Malgré tout por compatibilité avec configurations sauvées,
                  // -- on test aussi par rapport à label.
                  if (ft.name === bl.name || (ft.label && ft.label===bl.name)
                      || (ft.name.startsWith('_') && ft.name.substring(1) === bl.name)) {
                    gclayers.addBackGroundLayerByDesc(bl, $scope.map);
                  }
                });
              });
            });
          }
          else {
            $scope.baselayers = BaseMapFactory.resources.basemaps;
            $scope.propmap.bcklayer.forEach(function(ft) {
              $scope.baselayers.forEach(function(bl) {
                if (ft.name == bl.name || (ft.label && ft.label===bl.name)
                    || (ft.name.startsWith('_') && ft.name.substring(1) === bl.name)) {
                  gclayers.addBackGroundLayerByDesc(bl);
                }
              });
            });
          }
        }
      }
      applyMapParametersFromUrl();
    }

    function sortLayersByIndex(layer1, layer2) {
      var index1 = layer1.get('index');
      var index2 = layer2.get('index');
      if (index1 == null) return -1;
      else if (index2 == null) return 1;
      else if (index1 < index2) return -1;
      return 1;
    }

    function addOperationalLayer(layer) {
      if (layer.fti.type === 'esri' && layer.fti.geographic) {
        gclayers.addOperationalLayerESRI(layer);
      }
      else if (layer.fti.geographic && layer.fti.published) {
        gclayers.addOperationalLayerg2c(layer);
      }
    }

    const organizeLayers = () => {
      //-- Trier les layers par groupe, pour les listes de layer créées avant
      //-- cette évolution ou pour les nouvelles layers ajoutées.
      const ret = layersService.organizeLayers(gclayers.layersGroupedByStore);
      //-- Ne pas appeler la méthode clear de gclayers qui va faire
      //-- un broadcast dont on ne veut pas.
      gclayers.getOperationalLayerCollection().clear();
      gclayers.getOperationalLayerg2cCollection().clear();
      gclayers.getOperationalLayerESRICollection().clear();
      gclayers.clearListOfSelectableLayers();
      for (const group of ret.layerGroups) {
        for (const layer of group.layers) {
          if (layer.gctype === 'esri') {
            gclayers.addOperationalLayerESRI(layer);
          } else {
            gclayers.addOperationalLayerg2c(layer);
          }
        }
      }
    };


    const getMainMapModel = (res) => {
      if (!res.data == '') {
        let mappedLayers = [];
        let i = 1;
        getFeaturesWithReadAuthorization(FeatureTypeFactory.resources.featuretypes)
          .forEach(function (fType) {
            if (
              fType &&
              fType.uid &&
              fType.name.indexOf('kis_anc_ef') === -1 &&
              fType.name.indexOf('kis_anc_bibliotheque_ef') === -1 &&
              userHasReadAuthorization(fType)
            ) {
              const deleteIndex = res.data
                .map(function (x) {
                  if (x.fti) {
                    return x.fti.uid;
                  }
                  else {
                    //-- On ne stocke plus le FTI complet dans le mapmodel.
                    return x.ftiUid;
                  }
                })
                .indexOf(fType.uid);
              if (deleteIndex != -1) {
                const t = res.data[deleteIndex];
                const modelfti = fType;
                if (modelfti != null) {
                  t.fti = modelfti;
                  t.theme = fType.theme;
                  const l = gcWMS.getOlLayerFromMapModelElement(t);
                  mappedLayers.push(l);
                }
              }
              else {
                if (fType.geographic && (fType.type === 'esri' || fType.published)) {
                  ind = Math.max.apply(Math, res.data.map(function (o) {
                    return o.index;
                  })) + i++;
                  const l = gcWMS.getOlLayerFromFeaturetypeInfo(fType, ind);
                  mappedLayers.push(l);
                }
              }
            }
          });

        gclayers.clearOperationalLayer();
        mappedLayers = mappedLayers.sort(sortLayersByIndex);
        for (let i = 0; i < mappedLayers.length; i++)
          addOperationalLayer(mappedLayers[i]);
      }
      else {
        // AUcun map model alors on ajoute tous les composants
        //console.log("Pas de config  " +FeatureTypeFactory.resources.featuretypes);
        var ind = 0;
        getFeaturesWithReadAuthorization(FeatureTypeFactory.resources.featuretypes)
          .forEach(function (fType) {
            if (
              fType &&
              fType.uid &&
              fType.uid.indexOf('kis_anc_ef') === -1 &&
              fType.uid.indexOf('kis_anc_bibliotheque_ef') === -1
            ) {
              if (fType.geographic && fType.published) {
                const l = gcWMS.getOlLayerFromFeaturetypeInfo(fType, ind);
                if (fType.type === 'esri' && fType.geographic) {
                  gclayers.addOperationalLayerESRI(l);
                }
                else if (fType.geographic && fType.published) {
                  gclayers.addOperationalLayerg2c(l);
                }
              }
              ind++;
            }
          });
      }

      organizeLayers();
    };

    /**
     * En l'absence de modèle de carte par défaut, exécute le chargement de la liste des couches selon les rôles de l'utilisateur connecté.
     * @param {boolean} forceGetModels true pour indiquer à <code>mapModelSelector</code> la nécessité de récupérer les modèles de carte du serveur.
     * Le paramètre est false dans l'unique cas où l'on clique sur le bouton "Réinitialiser le modèle de carte" de <code>mapModelSelector</code>
     */
    const loadDefaultMap = (forceGetModels = true) => {
      ConfigFactory.get('main', 'map').then((res) => {
        getMainMapConfig(res, $scope.restoreFromAnc);
        ConfigFactory.get('main', 'mapmodel').then((res) => {
          getMainMapModel(res);

          layersService.resources.activeModel = null;

          // KIS-3464: en l'absence de modèle de carte à l'initialisation de la carte,
          // le style par défaut du composant doit être affiché
          applyLayerFtiDefaultStyle();

          // envoie un évènement à mapModelSelector pour afficher "Aucun modèle chargé"
          $scope.$broadcast('mapModelReady', forceGetModels);

          $rootScope.$broadcast('gcOperationalLayerOnInit');
          // stoppe le spinner du sélecteur de modèles de carte
          toggleMapModelSpinner();
        });
      });
    };


    /**
     * Récupère et applique la configuration de la map et le modèle de carte
     * @param {boolean} forceGetModels true pour indiquer à <code>mapModelSelector</code> la nécessité de récupérer les modèles de carte du serveur.
     * Le paramètre est false dans l'unique cas où l'on clique sur le bouton "Réinitialiser le modèle de carte" de <code>mapModelSelector</code>
     */
    const setDefaultFunctionMap = (forceGetModels = true) => {
      // lance le spinner du sélecteur de modèles de carte
      toggleMapModelSpinner();
      ParametersFactory.getbytype(
        layersService.MAP_MODEL_LAST_EDITED_CONFIGURATION_NAME,
        $scope.map.getView().getProjection().getCode()
      ).then(
        function(res) {
          if (res.data.length > 0) {
            ParametersFactory.getbytypeandname(res.data[0].data.name, layersService.MAP_MODELS_USERS)
              .then((res) => {
                if (!res.data || !res.data.data) {
                  // -- La carte par défaut a disparu !
                  loadDefaultMap(forceGetModels);
                }
                else {
                  getMainMapConfig({data: res.data.data.propmap}, $scope.restoreFromAnc);
                  getMainMapModel(res.data.data);

                  // défini le modèle actif dans le service
                  layersService.resources.activeModel = res.data.data.id;

                  // envoie un évènement à mapModelSelector pour sélectionner le modèle actif
                  $scope.$broadcast('mapModelReady', forceGetModels);
                  // stoppe le spinner du sélecteur de modèles de carte
                  toggleMapModelSpinner();
                }
                $rootScope.$broadcast('gcOperationalLayerOnInit');
              });
          }
          else {
            loadDefaultMap(forceGetModels);
          }
        },
        function() {
          loadDefaultMap(forceGetModels);
        }
      ).finally(() => {
        delete $scope.restoreFromAnc;
      });
    };


    FeatureTypeFactory.get().then(function() {
      var errorMsg;
      errorMsg = '<h4>Erreur</h4> ';
      errorMsg += '<br/><h4>Details</h4>';

      if (FeatureTypeFactory.resources.featuretypes == undefined) {
        errorMsg += '<br/>FeatureTypes non définis';
        require('toastr').error(errorMsg);
      }
      else if (FeatureTypeFactory.resources.featuretypes.code == 403) {
        errorMsg += '<br/>' + FeatureTypeFactory.resources.featuretypes.message;
        require('toastr').error(errorMsg);
      }
      else {
        //-- Si on n'est pas connecté ne pas chercher de paramètres en base
        //-- auxquels on n'aura pas le droit d'accéder, d'ailleurs
        //-- on n'accédera pas au service en premier lieu ...
        if (localStorage.auth_token != undefined) {
          setDefaultFunctionMap();
        }
      }
    });

    /**
     * Evènement envoyé à l'application d'un mapModel (@see layersService.setMapModel)
     */
    $scope.$on('gcUpdateMainConfig', function(event, conf, b) {
      getMainMapModel(conf);

      // KIS-3197: quand je récupère un modèle de carte il ne prend pas en compte le zoom défini
      getMainMapConfig({data: conf.propmap}, false);

      // informe mapModelMgtWidget du changement de modèle de carte
      $scope.$broadcast('mapModelChange');

      $rootScope.$broadcast('gcOperationalLayerOnInit', b);

      // stoppe le spinner du sélecteur de modèles de carte
      toggleMapModelSpinner();
    });

    /**
     * forceReloadDefaultMapConfig
     * Reload the default map cfg
     */
    $rootScope.$on(
      'forceReloadDefaultMapConfig',
      () => {
        $rootScope.$broadcast('gcOperationalLayerEmptyToUpdate');
        gclayers.clearLayersFromGroupLayer();
        gclayers.clearOperationalLayerg2c(true);
        gclayers.clearOperationalLayerESRI(true);

        setDefaultFunctionMap();
      },
      1
    );

    // Init panelsManager and reference it into scope
    panelsManager.init();
    $scope.panelsManager = panelsManager;
    const ignoreToolbarButtons = ['maptoolbarlogo']; // List of Toolbar Buttons that should not be added from/to backend

    ConfigFactory.get('main', 'toolbar').then(function(res) {
      if (res.data !== undefined && res.data !== '' && Array.isArray(res.data)) {
        res.data.forEach(function(t) {
          if (ignoreToolbarButtons.indexOf(t.name) === -1) {
            $scope.addtoolsbar(t);
          }
        });
      }
    });

    /**
     * Récupère les rôles de l'utilisateur connecté
     * Attend que le user soit défini
     */
    $rootScope.$watch('xgos.user',() => {
      if ($rootScope.xgos.user && $rootScope.xgos.user.login){
        RolesFactory.getRolesByUser($rootScope.xgos.user.login).then(
          res => {
            getConfigAndOrderWidgetsByUserRole(res.data);
          },
          ()=>{
            require('toastr').error(
              $filter('translate')('rights.roles.retrieve_error')
            );
          }
        );
      }
    });


    /**
     * Récupère la configuration des widgets
     * Vérifie si le widget a un rôle en commun avec l'utilisateur connecté
     * @param userRoles rôles de l'utilisateur (rôles de groupes compris)
     */
    const getConfigAndOrderWidgetsByUserRole = (userRoles) => {
      //les Widgets
      ConfigFactory.get('main', 'tools').then((res) => {
        if (res.data.code === 403) {
          let errorMsg = '<h4>Erreur 403</h4> ';
          errorMsg += '<br/><h4>Details</h4>';
          errorMsg += '<br/>' + res.data.message;
          require('toastr').error(errorMsg);
        }
        else {
          if (res.data !== '') {
            if (Array.isArray(res.data)) {
              for (let cat of res.data) {
                const cateMenu = {};
                cateMenu.categorie = cat.categorie;
                cateMenu.categorie_icon = cat.categorie_icon;
                cateMenu.modules = [];
                for (let module of cat.modules) {
                  if (!module.roles) {
                    module.roles = [];
                  }
                  if ($rootScope.xgos.user.name !== 'root') {
                    if (module.roles.length > 0) {

                      //on recherche les roles
                      for (let userRole of userRoles) {
                        const moduleHasUserRole = module.roles.some(moduleRoleName => moduleRoleName === userRole.name);
                        if (moduleHasUserRole) {
                          cateMenu.modules.push(module);
                          break; // le widget est inséré dans la catégorie donc on arrête de boucler sur les rôles de l'utilisateur
                        }
                      }
                    }
                    else {
                      cateMenu.modules.push(module);
                    }
                  }
                  else {
                    // je suis root
                    cateMenu.modules.push(module);
                  }
                }
                if (!$scope.tools) {
                  $scope.tools = [];
                }
                if (Array.isArray($scope.tools)) {
                  $scope.tools.push(cateMenu);
                }
              }
            }
            else {
              // si res.data n'est pas un tableau alors c'est un objet
              for (const [key, value] of Object.entries(res.data)) {
                const em = {};
                em.categorie = key;
                em.modules = value;
                // on vérifie que l'utilisateur a un rôle inclus dans les restrictions du widget
                if (Array.isArray(em.modules)) {
                  const filteredModules = [];
                  for (const module of em.modules) {
                    if ($rootScope.xgos.user.name === 'root' || !module.roles || module.roles.length === 0) {
                      filteredModules.push(module);
                    }
                    else {
                      for (let userRole of userRoles) {
                        const deleteIndex = module.roles.findIndex(moduleRoleName => moduleRoleName === userRole.name);
                        if (deleteIndex > -1) {
                          filteredModules.push(module);
                          break; // le widget est inséré dans la catégorie donc on arrête de boucler sur les rôles de l'utilisateur
                        }
                      }
                    }
                  }
                  em.modules = filteredModules;
                }
                if (!$scope.tools) {
                  $scope.tools = [];
                }
                if (Array.isArray($scope.tools)){
                  $scope.tools.push(em);
                }
              }
            }
            // supprime les catégories sans widgets
            removeEmptyCategories();
          }
        }
      });
    };


    $scope.previewUsers = [];

    UsersFactory.getactiveuserslight().then(function(res) {
      var resultObject = res.data;

      for (var i = 0; i < resultObject.length; i++) {
        var u = resultObject[i];
        $scope.previewUsers.push(u);
      }

      $scope.previewUsers.sort();
    });

    $scope.propmap = {};
    $rootScope.asideOpened = true;

    /**
     * [hideaside use to hide aside]
     *
     * @return nothing
     */
    $scope.toggleaside = function() {
      /*
       * console.clear(); console.log('ICI');
       */
      var map_aside = document.getElementById('map_aside');
      if (parseInt(map_aside.style['left'], 10) < 0) {
        map_aside.className = map_aside.className.replace('hide_aside', '');
        document.body.className = document.body.className + ' aside-open';
        map_aside.style['left'] = 0;

        $rootScope.asideOpened = true;
      }
      else {
        map_aside.className = map_aside.className + ' hide_aside';
        document.body.className = document.body.className.replace(
          'aside-open',
          ''
        );
        map_aside.style['left'] =
          '-' + (parseInt(map_aside.clientWidth) - 30) + 'px';

        $rootScope.asideOpened = false;
      }
    };

    // delete if it already exists
    if (document.getElementById('map_aside') !== null) {
      document.getElementById('map_aside').outerHTML = '';
    }
    $aside({
      scope: $scope,
      placement: 'left',
      backdrop: false,
      templateUrl: 'js/XG/widgets/mapapp/main/views/asides/left.html',
      keyboard: false,
    });

    /* ------------------
         MAP  CONFIG
         ------------------- */
    $scope.mapConfigTabs = [
      {
        title: 'map_config.tabs.menu.title',
      },
      {
        title: 'map_config.tabs.tools.title',
      },
    ];
    $scope.mapConfigTabs.activeTab = 0;

    /**
     * Sauvegarde de la configuration de la carte:
     * - Etendue de la carte
     * - Fonds de plan visibles
     * - Modèle de la carte (organisation des couches)
     */
    $scope.savemapconfig = function() {
      var size = $scope.map.getSize();
      console.log($scope.map);
      console.log($scope.map.getView());
      console.log(size);
      console.log($scope.map.getView().calculateExtent(size));

      //-- Sauvegarde de l'étendue
      $scope.propmap.extent = $scope.map.getView().calculateExtent(size);
      $scope.propmap.zoom = $scope.map.getView().getZoom();
      $scope.propmap.srid = $scope.map
        .getView()
        .getProjection()
        .getCode();

      //-- Sauvegarde des fonds de plan.
      $scope.propmap.bcklayer = [];
      gclayers.getBackGroundLayer().forEach(function(ft) {
        $scope.propmap.bcklayer.push({
          name: ft.name,
        });
      });
      if ($scope.propmap && $scope.propmap.bcklayer &&
        $scope.propmap.bcklayer.length > 0
      )
        $scope.propmap.bcklayer = [
          $scope.propmap.bcklayer[$scope.propmap.bcklayer.length - 1],
        ];
      gclayers.forceClearBackgroundLayer();

      // KIS-3487: cas du fond de plan composé
      if (BaseMapFactory.resources.activeBaseMap) {
        const activeLayer = BaseMapFactory.resources.basemaps.find(bm => bm.name === BaseMapFactory.resources.activeBaseMap);
        if (activeLayer && activeLayer.type === 'COMPOSED') {
          $scope.propmap.bcklayer = [{name: BaseMapFactory.resources.activeBaseMap}];
        }
      }

      ConfigFactory.add($scope.propmap, 'main', 'map').then(
          () => {
            require('toastr').success($filter('translate')('map_config.config_saved_FDP'));
          },
          err => {
            require('toastr').error($filter('translate')('map_config.error_saving_FDP'));
            console.error('saveMapConfig', err.data);
          });
    };

    /**
     *
     */
    $scope.savetoolbars = function() {
      const toolbarButtonsToSave = $scope.toolsbarbutton
        .filter(button => ignoreToolbarButtons.indexOf(button.name) === -1);
      ConfigFactory.add(toolbarButtonsToSave, 'main', 'toolbar').then(() => {
        require('toastr').success(
          $filter('translate')('map_config.config_saved')
        );
      });
    };

    $scope.mapmodel = function () {
      let ind = 0;
      const data = [];
      angular.forEach(gclayers.layersGroupedByStore.layerGroups,
        (group) => {
          angular.forEach(group.layers,
            function (lay) {
              if (!angular.isUndefined(lay.fti)) {
                const a = {
                  name: lay.name,
                  index: ind++,
                  maxScale: lay.maxScale,
                  minScale: lay.minScale,
                  selected: lay.selected,
                  invertedOpacity: lay.invertedOpacity,
                  minResolution: lay.minResolution,
                  maxResolution: lay.maxResolution,
                  visible: lay.visible,
                  layerDefs: lay.layerDefs,
                  theme: lay.theme,
                  style: lay.style,
                  fti: lay.fti,
                };
                data.push(a);
              }
            }
          );
        }
      );
      ConfigFactory.add(data, 'main', 'mapmodel').then(
        () => {
          require('toastr').success(
            $filter('translate')('map_config.config_saved_layers')
          );
        },
        (reason) => {
          require('toastr').error(reason);
        }
      );
    };


    $scope.savetools = function () {

      // KIS-3149: envoie un évènement à l'enfant "geolocalisationbutton"
      // informant de la présence du widget "Localisation à l'adresse"
      $scope.$broadcast('hasGeolocalisationWidget', GeolocalisationService.hasGeolocalisationWidget($scope.tools));

      ConfigFactory.add($scope.tools, 'main', 'tools').then(function() {
        //require('toastr').success("Configuration sauvee");
      });
    };

    $scope.go = function(extent) {
      var size = $scope.map.getSize();
      var view = $scope.map.getView();
      view.fit(extent, size);
    };

    /**
     * [addtools use to addtool on the aside object ]
     * @param  {[tools]} tool [add tool to the aside manadger ]
     * @return nothing
     */
    $scope.openmodifytools = function(tool) {
      $scope.oldtool = tool;
      $scope.curtool = angular.copy(tool);
      ngDialog.open({
        template: 'js/XG/widgets/mapapp/main/views/toolmodify.html',
        className: 'ngdialog-theme-plain',

        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.modifytools = function(tool) {
      $scope.removetool($scope.oldtool);
      $scope.addtools(tool);
    };
    $scope.addtools = function(tool) {
      tool.chosenTitle = tool.title;

      if (angular.isUndefined(tool.categorie)) {
        tool.categorie = 'Divers';
      }
      if (angular.isUndefined(tool.mode)) {
        tool.mode = 'Panel';
      }
      var toolselement = null;
      $scope.tools.forEach(function(m) {
        if (m.categorie == tool.categorie) {
          toolselement = m;
        }
      });
      if (toolselement == null) {
        toolselement = {};
        if (angular.isUndefined(tool.categorie)) {
          tool.categorie = 'Divers';
        }

        toolselement.categorie = tool.categorie;
        toolselement.modules = [];
        toolselement.modules.push(tool);
        $scope.tools.push(toolselement);
      }
      else {
        toolselement.modules.push(tool);
      }

      $scope.configToolPopup.close();
    };

    $scope.movetoolbar = function(name, direction) {
      let index = $scope.toolsbarbutton.findIndex(toolbarButton => toolbarButton.name === name);
      if (
        (index == 0 && direction == 'up') ||
        (index == $scope.amountOfTools - 1 && direction == 'down')
      ) {
        return false;
      }
      var newIndex = direction == 'up' ? index - 1 : index + 1;
      $scope.toolsbarbutton.splice(
        index,
        0,
        $scope.toolsbarbutton.splice(newIndex, 1)[0]
      );
    };

    $scope.configToolsRoles = function(vertTool) {
      $scope.currentVertTool = vertTool;

      $scope.configVerticalToolPopup = ngDialog.open({
        template: 'js/XG/widgets/mapapp/main/views/verticaltoolconfig.html',
        className:
          'ngdialog-theme-plain overflowY width400 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Move a tool up
     *
     * @param tool
     * @param category
     */
    $scope.uptool = function(tool, category) {
      var moveIndex = category.modules
        .map(function(x) {
          return x.name + x.title;
        })
        .indexOf(tool.name + tool.title);
      $scope.moveelement(category.modules, moveIndex, -1);
    };

    /**
     * Move a tool down
     *
     * @param tool
     * @param category
     */
    $scope.downtool = function(tool, category) {
      var moveIndex = category.modules
        .map(function(x) {
          return x.name + x.title;
        })
        .indexOf(tool.name + tool.title);
      $scope.moveelement(category.modules, moveIndex, 1);
    };

    /**
     * delete categorie
     *
     * @param categorie
     */
    $scope.deleteCategorie = function(categorie) {
      var ans = confirm(
        $filter('translate')('map_config.toolsbar.confirm_delete_categorie')
      );
      if (ans) {
        var deleteIndex = $scope.tools
          .map(function(x) {
            return x.categorie;
          })
          .indexOf(categorie.categorie);
        $scope.tools.splice(deleteIndex, 1);
      }
    };

    /** move categorie up * */
    $scope.upcategorie = function(categorie) {
      console.log(categorie);
      var deleteIndex = $scope.tools
        .map(function(x) {
          return x.categorie;
        })
        .indexOf(categorie.categorie);
      console.log(deleteIndex);
      $scope.moveelement($scope.tools, deleteIndex, -1);
    };
    /** move categorie down * */
    $scope.downcategorie = function(categorie) {
      var deleteIndex = $scope.tools
        .map(function(x) {
          return x.categorie;
        })
        .indexOf(categorie.categorie);
      console.log(deleteIndex);
      $scope.moveelement($scope.tools, deleteIndex, 1);
    };

    $scope.removecategorie = function(categorie) {
      var deleteIndex = $scope.tools
        .map(function(x) {
          return x.categorie;
        })
        .indexOf(categorie.categorie);
      $scope.tools.splice(deleteIndex, 1);
    };

    /**
     * Move an element (tool/category)
     *
     * @param table
     * @param index
     * @param delta
     * @returns {boolean}
     */
    $scope.moveelement = function(table, index, delta) {
      if (index < 0 || index >= table.length) {
        return false;
      }
      var index2 = index + delta;
      if (index2 < 0 || index2 >= table.length) {
        return false;
      }
      var temp_item = table[index];
      table[index] = table[index2];
      table[index2] = temp_item;
      return true;
    };

    // Role @RB voi si on le met pas avant
    RolesFactory.get().then(function(fdata) {
      $scope.rolelist = RolesFactory.resources.roles;
    });
    /**
     * [addRolesTool description]
     *
     * @param {[type]}
     *            tool [description]
     * @param {[type]}
     *            nRole [description]
     */
    $scope.addRolesTool = function(tool, nRole) {
      if (angular.isUndefined(tool.roles)) {
        tool.roles = [];
      }
      var deleteIndex = tool.roles
        .map(function(x) {
          return x;
        })
        .indexOf(nRole.name);
      if (deleteIndex == -1) {
        tool.roles.push(nRole.name);
      }
    };
    /**
     * [removeRolesTool description]
     *
     * @param {[type]}
     *            tool [description]
     * @param {[type]}
     *            nRole [description]
     * @param {[type]}
     *            deleteIndex [description]
     * @return {[type]} [description]
     */
    $scope.removeRolesTool = function(tool, nRole, deleteIndex) {
      tool.roles.splice(deleteIndex, 1);
    };

    /**
     * [addRolesToVerticalTool description]
     *
     * @param {[type]}
     *            tool [description]
     * @param {[type]}
     *            nRole [description]
     */
    $scope.addRolesToVerticalTool = function(tool, nRole) {
      if (angular.isDefined(nRole)) {
        if (angular.isUndefined(tool.roles)) {
          tool.roles = [];
        }

        var deleteIndex = tool.roles
          .map(function(x) {
            return x;
          })
          .indexOf(nRole.name);

        if (deleteIndex == -1) {
          tool.roles.push(nRole.name);
        }
      }
    };
    /**
     * [removeRolesToVerticalTool description]
     *
     * @param {[type]}
     *            tool [description]
     * @param {[type]}
     *            deleteIndex [description]
     */
    $scope.removeRolesToVerticalTool = function(tool, deleteIndex) {
      tool.roles.splice(deleteIndex, 1);
    };

    /**
     * Remove tool from category
     *
     * @param tool
     * @param category
     */
    $scope.removetool = function(tool, category) {
      var deleteIndex = category.modules
        .map(function(x) {
          return x.name + x.title;
        })
        .indexOf(tool.name + tool.title);
      category.modules.splice(deleteIndex, 1);
    };

    $scope.removetoolsbar = function(toolbar) {
      var deleteIndex = $scope.toolsbarbutton
        .map(function(x) {
          return x.name;
        })
        .indexOf(toolbar.name);
      $scope.toolsbarbutton.splice(deleteIndex, 1);
    };
    $scope.addtoolsbar = function(toolbar) {
      $scope.toolsbarbutton.push(toolbar);
    };

    /**
     * edit a toolbar item configuration (popup)
     *
     * @param tool
     * @param category
     * @param isnew
     */
    $scope.editToolsBarConfig = function(tool, category, isnew) {
      /* $scope.savecurtool = angular.copy(tool); */
      $scope.curtool = angular.copy(tool);
      $scope.curtoolSvg = angular.copy(tool);
      $scope.curtool.categorie = category.categorie;
      $scope.curcategory = category;
      $scope.isNewTool = isnew;
      $scope.categoriesList = $scope.tools.map(function(a) {
        return a.categorie;
      });

      // uniq nom de config
      if (isnew) {
        $scope.curtool.config += '_' + new Date().valueOf();
      }

      if (isnew && $scope.categoriesList.length == 1) {
        $scope.curtool.categorie = $scope.categoriesList[0];
      }

      $scope.configToolPopup = ngDialog.open({
        template: 'js/XG/widgets/mapapp/main/views/toolconfig.html',
        className:
          'ngdialog-theme-plain overflowY width600 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Update a tool bar
     */
    $scope.updateToolsBarCfg = function() {
      // same categorie, only other parameters were changed (title, cfg)
      if ($scope.curtool.categorie == $scope.curcategory.categorie) {
        delete $scope.curtool.categorie; // not used anymore, no need to save it
        $scope.curcategory.modules.forEach(function(mod, i) {
          if (
            mod.name == $scope.curtool.name &&
            mod.config === $scope.curtoolSvg.config
          ) {
            $scope.curcategory.modules[i] = $scope.curtool;
          }
        });

        // different category
      }
      else {
        // only if the tool was previously set in a category (not a new tool)
        if ($scope.curcategory) {
          // remove from original category
          $scope.curcategory.modules.forEach(function(mod, i) {
            if (
              mod.name == $scope.curtool.name &&
              mod.title == $scope.curtoolSvg.title
            ) {
              $scope.curcategory.modules.splice(i, 1);
            }
          });
          // if the category is now empty
          if ($scope.curcategory.modules.length == 0) {
            var categoryIndex = $scope.tools
              .map(function(x) {
                return x.categorie;
              })
              .indexOf($scope.curcategory.categorie);
            $scope.tools.splice(categoryIndex, 1);
          }
        }

        // add to new category
        var newCategoryIndex = $scope.tools
          .map(function(x) {
            return x.categorie;
          })
          .indexOf($scope.curtool.categorie);
        delete $scope.curtool.categorie; // not used anymore, no need to save it
        $scope.tools[newCategoryIndex].modules.push($scope.curtool);
        setDirectivesListExtraInformation();
      }

      $scope.configToolPopup.close();
    };

    /**
     * Update a vertical config
     */
    $scope.updateVerticalToolCfg = function() {
      var updateIndex = $scope.toolsbarbutton
        .map(function(x) {
          return x.name;
        })
        .indexOf($scope.currentVertTool.name);

      $scope.toolsbarbutton.splice(updateIndex, 1, $scope.currentVertTool);

      $scope.configVerticalToolPopup.close();
    };

    $scope.prevUser = {};

    $scope.clearCurrentPrevUser = function() {
      $scope.prevUser.selectedUser = undefined;
    };

    $scope.filterOnUserRoles = function(tool) {
      var hasRole = true;

      if (angular.isDefined($scope.prevUser.selectedUser)) {
        if (angular.isDefined(tool.roles)) {
          if (tool.roles.length > 0) {
            hasRole = false;

            angular.forEach($scope.prevUser.selectedUser.roles, function(ro) {
              var deleteIndex = tool.roles
                .map(function(x) {
                  return x;
                })
                .indexOf(ro.name);

              if (deleteIndex > -1) {
                hasRole = true;
              }
            });
          }
        }
      }

      return hasRole;
    };

    /**
     * Add or remove a tool (left side)
     *
     * @param tool
     */
    $scope.configToolPopup = {};
    $scope.addOrRemoveFromToolslist = function(tool) {
      /*
       * if(!tool.hasOwnProperty('used') || !tool.used){
       * $scope.editToolsBarConfig(tool,1); // $scope.addtools(tool);
       * }else{ $scope.removetool(tool); }
       */
    };

    /**
     * setDirectivesListExtraInformation for display in new tool modal
     */
    var setDirectivesListExtraInformation = function() {
      var arr = {};
      $scope.DirectivesList.forEach(function(d) {
        if (!arr[d.categorie]) arr[d.categorie] = [];
        d.used = 0;
        $scope.tools.forEach(function(t) {
          t.modules.forEach(function(m) {
            if (m.directive == d.directive) {
              d.used = d.used + 1;
            }
          });
        });
        arr[d.categorie].push(d);
      });

      $scope.DirectivesListExtra = arr;
    };

    /** Add a tool modal * */
    $scope.addToolModal = function() {
      $scope.newTool = {};
      setDirectivesListExtraInformation();
      $scope.newToolDialog = ngDialog.open({
        template: 'js/XG/widgets/mapapp/main/views/new_tool.html',
        className:
          'ngdialog-theme-plain overflowY width80pct nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /** Add a category modal * */
    var oldCategoryName;
    $scope.editCategoryModal = function(category) {
      $scope.categoryAdded = false;
      $scope.editCategory = {};
      $scope.isNewCategory = true;
      if (category) {
        $scope.isNewCategory = false;
        $scope.editCategory.name = category.categorie;
        $scope.editCategory.icon = category.categorie_icon;
        oldCategoryName = category.categorie;
      }
      $scope.editCategoryDialog = ngDialog.open({
        template: 'js/XG/widgets/mapapp/main/views/new_category.html',
        className:
          'ngdialog-theme-plain overflowY width600 nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /** Add a category * */
    $scope.addCategory = function() {
      $scope.editCategoryDialog.close();
      if ($scope.isNewCategory) {
        $scope.categoryAdded = true;
        $scope.tools.push({
          categorie: $scope.editCategory.name,
          categorie_icon: $scope.editCategory.icon,
          modules: [],
        });
      }
      else {
        for (var i in $scope.tools) {
          if ($scope.tools[i].categorie == oldCategoryName) {
            $scope.tools[i].categorie = $scope.editCategory.name;
            $scope.tools[i].categorie_icon = $scope.editCategory.icon;
          }
        }
      }
    };

    const setBaseLayerOpacity = () => {
      let mBaseLayer = gclayers.getBackGroundLayer();
      if (!mBaseLayer.length) return;
      mBaseLayer.forEach(mBl => {
        mBl.setOpacity(+$scope.basemap_opacity.value / 10);
      });
    };

    $scope.basemap_opacity = { value: 10 };
    $scope.$watch(
      'basemap_opacity',
      bo => {
        setBaseLayerOpacity();
      },
      1
    );
    $scope.$watch(
      'tools',
      bo => {
        if($scope.tools instanceof Array === false){
          $scope.tools = Object.values($scope.tools);
        }
      },
      1
    );
    $rootScope.$on('gcBackGroundLayerChange', setBaseLayerOpacity);

    /**
     * Reset all the toolbars
     */
    $scope.resetToolsBar = function() {
      var ans = confirm(
        $filter('translate')('map_config.toolsbar.reset_title')
      );
      if (ans) {
        $scope.tools = [];
      }
    };
    /**
     * Add or remove a toolbar (right side)
     *
     * @param toolbar
     */
    $scope.addOrRemoveFromToolsbar = function(toolbar) {
      if (toolbar.used) {
        $scope.toolsbarbutton.push(toolbar);
      }
      else {
        var deleteIndex = $scope.toolsbarbutton
          .map(function(x) {
            return x.name;
          })
          .indexOf(toolbar.name);
        $scope.toolsbarbutton.splice(deleteIndex, 1);
      }
    };

    /**
     * Save everything (tools,toolbars,map
     */
    $scope.saveToolsAndToolsBarsConfig = function() {
      $scope.savetools();
      $scope.savetoolbars();
    };

    let mapConfigurationLoading = false;
    $scope.openMapConfiguration = function() {
      if (mapConfigurationLoading) return;
      mapConfigurationLoading = true;

      $scope.mapConfigTabs.activeTab = 0;
      ngDialog.open({
        template: 'js/XG/widgets/mapapp/main/views/toolbarconfig.html',
        className: 'ngdialog-theme-plain overflowY width800 miniclose',
        closeByDocument: false,
        scope: $scope,
        preCloseCallback: function() {
          mapConfigurationLoading = false;
        },
      });
    };

    /**
     * [toolsbarbutton Array of the vertical toolbar button ]
     *
     * @type {Array}
     */
    $scope.toolsbarbutton = [
      /*
       * { "type": "widget", "name": "gctoolbarasideleft", "config": "b" }
       */
    ];

    /** ************************************************************************************** */
    /**
     * [app description]
     *
     * @type {[type]}
     */
    $scope.app = getParameterByName('app');
    localStorage.setItem('app', $scope.app);
    // -- Store the application name on the main module, in order
    // -- the application won't be overwritten by the local storage
    // -- value in case many tabs are opened on different applications.
    var gcMain = angular.module('gcMain');
    gcMain.app = $scope.app;
    /**
     * [portalid description]
     *
     * @type {[type]}
     */
    $scope.portalid = getParameterByName('portal');
    //
    //
    PortalsFactory.setPortal($scope.portalid);

    gcMain.portalid = $scope.portalid;

    function getFeaturesWithReadAuthorization(features) {
      if (!Array.isArray(features)) {
        return [];
      }
      return features.filter(featureType => userHasReadAuthorization(featureType));
    }

    function userHasReadAuthorization(featureType) {
      if ($rootScope.xgos.user.roles.find( (role) => role.name==='rootUser')) {
        return true;
      }
      const featureAuthorization = $rootScope.xgos.user.roles.reduce((right, role) => {
        if (!role || !role.authorizations) {
          return false;
        }
        right = role.authorizations.find(authorization => authorization && authorization.item === featureType.uid) || right;
        return right;
      }, {});
      return !featureAuthorization.item ||  // Case where there is no specific rule authorization for user(root)
        featureAuthorization.read;
    }
    if ($rootScope.xgos.isadmin && $scope.mode === 'config') {
      $scope.addtoolsbar({
        title: 'Afficher un logo',
        name: 'maptoolbarlogo',
        type: 'widget',
        icone: 'fa fa-camera',
        used: true,
        position: 14,
      });
    }

    /**
     * Lance l'application des filtres de données au démarrage de la carte
     */
    $rootScope.$on('gcOperationalLayerOnInit', () => {
      defaultFiltersFactory.findFilters();
    });

    /**
     * Supprime les catégories vides<br>
     * C'est à dire les catégories dont les widgets sont restreintes à des rôles non détenus par l'utilisateur courant
     */
    function removeEmptyCategories(){
      if ($scope.tools){

        // création d'une variable distincte pour itérer
        const categories = Object.assign($scope.tools);

        // variable contenant les catégories avec le nouvel index
        const result = {};

        let index = 0;

        for (let i=0; i<categories.length;i++){
          const widgets = categories[i].modules;

          // Quand le widget est restreint à un rôle que l'utilisateur ne détient pas alors il est déjà absent du tableau de modules
          // ce qui nous permet ici de ne tester que la présence/absence de widgets sans avoir à vérifier les rôles
          if (!widgets || widgets.length==0){
            delete $scope.tools[i];
          }
          else{
            result[index] = $scope.tools[i];
            index++;
            // l'index est incrémenté uniquement si la catégorie a été ajouté au résultat (i.e. si contient des widgets)
          }
        }
        $scope.tools = result;
      }
    }

    // A la fermeture d'un dossier ANC ouvert par le bouton "Sélection par point" du widget ANC
    // (KIS-2447 | ANC-98)
    $rootScope.$on('anc_close_dossier', () => {
      $scope.restoreFromAnc = true;
      setDefaultFunctionMap();
    });

    /**
     * Evènement envoyé par le clic sur le bouton "Réinitialiser le modèle de carte".
     * Restaure la configuration initiale de la carte sans provoquer les bugs de l'évènement "forceReloadDefaultMapConfig"
     */
    $scope.$on('setDefaultMap', (evt) => {
      setDefaultFunctionMap(false);
    });

    /**
     * Démarre/stoppe le spinner du bouton "Réinitialiser" du sélecteur de modèles de carte
     */
    const toggleMapModelSpinner = () => {
      if (!$scope.mapModelSpinner) {
        $scope.mapModelSpinner = {show: true};
      } else {
        $scope.mapModelSpinner.show = ! $scope.mapModelSpinner.show;
      }
    };

    /**
     * Applique le style par défaut du composant des couches openLayers référencées dans le géocatalogue<br>
     * Uniquement dans le cas où aucun modèle de carte n'est appliqué à l'initialisation de la carte.<br>
     * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3464">KIS-3464</a>
     */
    const applyLayerFtiDefaultStyle = () => {
      const layers = gclayers.getOperationalLayer();
      for (const layer of layers) {
        if (layer.fti && typeof layer.fti.defaultStyle === 'string' && layer.fti.defaultStyle.length > 0) {
          layer.style = layer.fti.defaultStyle;
        }
      }
    };

    /** ************************************************************************************** */
  };
  gcMainController.$inject = [
    '$scope',
    '$location',
    'ConfigFactory',
    'FeatureTypeFactory',
    'gcWMS',
    '$aside',
    'gclayers',
    'ngDialog',
    'gcDirectivesList',
    'panelsManager',
    '$rootScope',
    '$filter',
    'PortalsFactory',
    'BaseMapFactory',
    'RolesFactory',
    'SelectManager',
    'gcPopup',
    'QueryFactory',
    '$timeout',
    'ParametersFactory',
    'ApplicationFactory',
    'DataStoreFactory',
    'gaJsUtils',
    'UsersFactory',
    'layersService',
    'defaultFiltersFactory',
    'GeolocalisationService',
    '$q',
    'extendedNgDialog'
  ];

  return gcMainController;
});
