'use strict';
define(function () {
  var profilPreview = function (
    LongitudinalProfileFactory,
    $translate,
    $q,
    $rootScope,
    gaDomUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/longitudinalprofile/views/profilPreview.html',
      restrict: 'EA',
      scope: {
        selectTool: '=selecttool',
        geojson: '=',
        elementConfigs: '=elementconfigs',
        diameter: '=',
        api: '='
      },
      link: function (scope, elt, attrs, ctrl) {
        let elevationTip = '';
        $translate('profil.elevationTip').then((res) => {
          elevationTip = res;
        });
        let distanceTip = '';
        const p1 = $translate('profil.distanceTip').then((res) => {
          distanceTip = res;
        });
        let distanceCumulTip = '';
        const p2 = $translate('profil.distanceCumulTip').then((res) => {
          distanceCumulTip = res;
        });
        let coteRadierTip = '';
        const p3 = $translate('profil.coteRadierTip').then((res) => {
          coteRadierTip = res;
        });
        let coteTamponTip = '';
        const p4 = $translate('profil.coteTamponTip').then((res) => {
          coteTamponTip = res;
        });
        let diametreTip = '';
        const p5 = $translate('profil.diametreTip').then((res) => {
          if (scope.diameter && scope.diameter.name) {
            diametreTip = res + ' (' + scope.diameter.name + ')';
          } else {
            diametreTip = res;
          }
        });
        let penteTip = '';
        const p6 = $translate('profil.penteTip').then((res) => {
          penteTip = res;
        });

        const stroke = new ol.style.Stroke({ color: 'green', width: 2 });
        //        var fill = new ol.style.Fill({color: 'green'});
        const fill = undefined;
        const imageStyles = {
          square: new ol.style.RegularShape({
            fill: fill,
            stroke: stroke,
            points: 4,
            radius: 10,
            angle: Math.PI / 4,
          }),
          triangle: new ol.style.RegularShape({
            fill: fill,
            stroke: stroke,
            points: 3,
            radius: 10,
            rotation: Math.PI / 4,
            angle: 0,
          }),
          star: new ol.style.RegularShape({
            fill: fill,
            stroke: stroke,
            points: 5,
            radius: 10,
            radius2: 4,
            angle: 0,
          }),
          cross: new ol.style.RegularShape({
            fill: fill,
            stroke: stroke,
            points: 4,
            radius: 10,
            radius2: 0,
            angle: 0,
          }),
          x: new ol.style.RegularShape({
            fill: fill,
            stroke: stroke,
            points: 4,
            radius: 10,
            radius2: 0,
            angle: Math.PI / 4,
          }),
        };

        const image = new ol.style.Circle({
          radius: 5,
          fill: new ol.style.Fill({
            color: 'rgba(255, 255, 0, 0.1)',
          }),
          stroke: new ol.style.Stroke({ color: 'red', width: 1 }),
        });

        const image2 = new ol.style.Circle({
          radius: 3,
          fill: new ol.style.Fill({
            color: 'rgba(0, 0, 0, 0.4)',
          }),
          //  ,stroke: new ol.style.Stroke({color: 'red', width: 1})
        });

        let styleFunction = (feature, resolution) => {
          let fontSize = '12';
          if (resolution >= 3 * 1.19) {
            fontSize = '2';
          } else if (resolution >= 2 * 1.19) {
            fontSize = '6';
          } else if (resolution >= 1.19) {
            fontSize = '8';
          } else if (resolution < 0.5) {
            fontSize = '14';
          } else {
            fontSize = '12';
          }
          // Feature POINTS du réseau
          if (feature.get('type') == 'terrain_point') {
            return [
              new ol.style.Style({
                image: image,
                text: new ol.style.Text({
                  font: fontSize + 'px sans-serif,helvetica',
                  text: feature.get('label'),
                  textAlign: 'left',
                  offsetY: -10,
                  offsetX: -5,
                  rotation: -0.523599,
                  textBaseline: 'alphabetic',
                  fill: new ol.style.Fill({
                    color: 'black', //'#'+Math.floor(Math.random()*16777215).toString(16)
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#ddd',
                    width: 1,
                  }),
                }),
              }),
            ];
          }
          // TERRAIN (Surface)
          if (feature.get('type') == 'terrain') {
            return [
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'red',
                  width: 2,
                }),
              }),
            ];
          }

          // Feature Line du réseau
          if (feature.get('type') == 'cana') {
            return [
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'blue',
                  width: 3,
                }),
              }),
            ];
          }
          //Features intersectant le réseau
          if (feature.get('type') == 'intersectedFeature') {
            for (let i = 0; i < scope.elementConfigs.length; i++) {
              const element = scope.elementConfigs[i];
              if (feature.get('layerName') == element.layerName) {
                const style = new ol.style.Style({
                  image: imageStyles[element.imageStyleKey],
                  text: new ol.style.Text({
                    font: fontSize + 'px sans-serif,helvetica',
                    text: feature.get('fid'),
                    textAlign: 'right',
                    offsetY: 20,
                    offsetX: 0,
                    rotation: -0.523599,
                    textBaseline: 'alphabetic',
                    fill: new ol.style.Fill({
                      color: 'green', //'#'+Math.floor(Math.random()*16777215).toString(16)
                    }),
                    stroke: new ol.style.Stroke({
                      color: '#ddd',
                      width: 1,
                    }),
                  }),
                });
                return [style];
              }
            }
          }
          // Axe des abcisse et des ordonnes
          if (feature.get('type') == 'axe') {
            return [
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'black',
                  width: 1,
                }),
              }),
            ];
          }
          if (feature.get('type') == 'axe') {
            return [
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'black',
                  width: 1,
                }),
              }),
            ];
          }
          if (feature.get('type') == 'array') {
            return [
              new ol.style.Style({
                stroke: new ol.style.Stroke({
                  color: 'gray',
                  width: 1,
                }),
              }),
            ];
          }
          if (feature.get('type') == 'labelvSurface') {
            return [
              new ol.style.Style({
                text: new ol.style.Text({
                  font: fontSize + 'px sans-serif,helvetica',
                  text: feature.get('label'),
                  textAlign: 'left',
                  rotation: 0,
                  textBaseline: 'alphabetic',
                  fill: new ol.style.Fill({
                    color: 'red',
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#ddd',
                    width: 1,
                  }),
                }),
              }),
            ];
          }
          if (feature.get('type') == 'labelvLegend') {
            return [
              new ol.style.Style({
                text: new ol.style.Text({
                  font: fontSize + 'px sans-serif,helvetica',
                  text: feature.get('label'),
                  textAlign: 'left',
                  rotation: 0,
                  textBaseline: 'alphabetic',
                  fill: new ol.style.Fill({
                    color: 'black', //'#'+Math.floor(Math.random()*16777215).toString(16)
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#ddd',
                    width: 1,
                  }),
                }),
              }),
            ];
          }
          if (feature.get('type') == 'labelvcentered') {
            return [
              new ol.style.Style({
                image: image2,
                text: new ol.style.Text({
                  offsetY: -5,
                  font: fontSize + 'px sans-serif,helvetica',
                  text: feature.get('label'),
                  textAlign: 'center',
                  rotation: 0,
                  textBaseline: 'alphabetic',
                  fill: new ol.style.Fill({
                    color: 'black', //'#'+Math.floor(Math.random()*16777215).toString(16)
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#ddd',
                    width: 1,
                  }),
                }),
              }),
            ];
          }
          if (feature.get('type') == 'labelv') {
            return [
              new ol.style.Style({
                image: image2,
                text: new ol.style.Text({
                  font: fontSize + 'px sans-serif,helvetica',
                  text: feature.get('label'),
                  textAlign: 'left',
                  offsetY: -5,
                  offsetX: 12,
                  rotation: -0.523599,
                  textBaseline: 'alphabetic',
                  fill: new ol.style.Fill({
                    color: 'black', //'#'+Math.floor(Math.random()*16777215).toString(16)
                  }),
                  stroke: new ol.style.Stroke({
                    color: '#ddd',
                    width: 1,
                  }),
                }),
              }),
            ];
          }
          if (feature.get('type') == 'graduation') {
            return [
              new ol.style.Style({
                text: new ol.style.Text({
                  font: fontSize + 'px sans-serif,helvetica',
                  text: feature.get('label'),
                  textAlign: 'right',
                  rotation: 0,
                  fill: new ol.style.Fill({
                    color: 'black', //'#'+Math.floor(Math.random()*16777215).toString(16)
                  }),
                }),
              }),
            ];
          }
          return [
            new ol.style.Style({
              text: new ol.style.Text({
                font: fontSize + 'px sans-serif,helvetica',
                text: feature.get('label'),
                fill: new ol.style.Fill({
                  color:
                    '#' + Math.floor(Math.random() * 16777215).toString(16),
                }),
                baseline: 'alphabetic',
                stroke: new ol.style.Stroke({
                  color: '#ddd',
                  width: 1,
                }),
              }),
            }),
          ];
        };

        scope.isEsriType = scope.$parent.$parent.isEsriType;

        const projection = new ol.proj.Projection({
          code: 'EPSG:21781',
          units: 'm',
        });

        let map = new ol.Map({
          layers: [
            /*new ol.layer.Tile({
                  source: new ol.source.OSM()
                }),*/
            //vectorLayer
          ],
          target: 'profilmap',
          //                  controls: ol.control.defaults({
          //                    attributionOptions: /** @type {olx.control.AttributionOptions} */ ({
          //                      collapsible: false
          //                    })
          //                  }),
          controls: [new ol.control.Zoom()],
          view: new ol.View({
            center: [100, -80],
            projection: projection,
            zoom: 18,
          }),
        });

        let geojsonObject;
        /* $.getJSON( "/services/kise6f6e961-ba9b-48dd-9693-76a9132678f8/profile/longitudinal?token=007", function( data ) {
          geojsonObject= data;

        });*/

        let features = undefined;
        let vectorLayer = undefined;
        let popup;
        function buildMap() {
          if (angular.isDefined(scope.geojson)) {
            geojsonObject = scope.geojson;
            console.log(scope.geojson);
            features = new ol.format.GeoJSON().readFeatures(geojsonObject);

            const vectorSource = new ol.source.Vector({
              features: features,
            });
            map.removeLayer(vectorLayer);
            vectorLayer = new ol.layer.Vector({
              source: vectorSource,
              style: styleFunction,
            });
            map.addLayer(vectorLayer);

            //Centrage du profil
            let centerX, centerY;
            for (let i = 0; i < features.length; i++) {
              const id = features[i].getId();
              if (id == 'axe.Axe X') {
                const exent = features[i].getGeometry().getExtent();
                centerX = (exent[2] + exent[0]) / 2;
                centerY = (exent[3] + exent[1]) / 2;
              }
            }
            if (angular.isDefined(centerX) && angular.isDefined(centerY)) {
              map.getView().setCenter([centerX, centerY]);
            }

            //// GESTION DE POPUP D'INFORMATIONS SUR LES FEATURES //////////////////
            //GESTION DE POPUP D'INFORMATIONS SUR LES FEATURES
            const container = document.getElementById('popupProfil');
            const content = document.getElementById('popup-content-Profil');
            const closer = document.getElementById('popup-closer-Profil');

            popup = new ol.Overlay({
              element: container,
              positioning: 'center-center',
            });
            map.addOverlay(popup);

            //                map.on('click', function(evt) {
            //                    var pixel = map.getPixelFromCoordinate(evt.coordinate);
            //                    map.forEachFeatureAtPixel(pixel,function(feature,layer){
            //                        if (feature.get('type')=="cana"){
            //                            var fid = feature.get("fid");
            //                            var pente = feature.get("pente");
            //                            var diametre = feature.get("diametre");
            //                            content.innerHTML = '<p>'+fid+'</p>'
            //                            +'<p>'+penteTip+':'+pente+'</p>'
            //                            +'<p>'+diametreTip+':'+diametre+'</p>';
            //                            popup.setPosition(evt.coordinate);
            //                            return;
            //                        }
            //                    });
            //                });
            map.on('pointermove', (evt) => {
              popup.setPosition(undefined);
              const pixel = map.getPixelFromCoordinate(evt.coordinate);
              map.forEachFeatureAtPixel(pixel, (feature, layer) => {
                if (feature.get('type') == 'cana') {
                  const fid = feature.get('fid');
                  const pente = feature.get('pente');
                  const diametre = feature.get('diametre');
                  content.innerHTML =
                    '<div class="ol-longitudinal-popup"' +
                    '<p>' +
                    fid +
                    '</p>' +
                    '<p>' +
                    penteTip +
                    ': ' +
                    pente +
                    '</p>' +
                    '<p>' +
                    diametreTip +
                    ': ' +
                    diametre +
                    '</p>' +
                    '</div>';
                  popup.setPosition(evt.coordinate);
                  return;
                } else if (feature.get('type') == 'intersectedFeature') {
                  const elevationValue = feature.get('elevation');
                  const distanceValue = feature.get('distance');
                  content.innerHTML =
                    '<p>' +
                    elevationTip +
                    ': ' +
                    elevationValue +
                    '</p>' +
                    '<p>' +
                    distanceTip +
                    ': ' +
                    distanceValue +
                    '</p>';
                  popup.setPosition(evt.coordinate);
                  return;
                  //popup.show(evt.coordinate, '<div><h2>Coordinates</h2><p>' + prettyCoord + '</p></div>');
                } else if (feature.get('type') == 'terrain_point') {
                  const coteRadier = feature.get('coteRadier');
                  const coteTampon = feature.get('coteTampon');
                  const distanceValue = feature.get('distance');
                  content.innerHTML =
                    '<p>' +
                    coteRadierTip +
                    ': ' +
                    coteRadier +
                    '</p>' +
                    '<p>' +
                    coteTamponTip +
                    ': ' +
                    coteTampon +
                    '</p>' +
                    '<p>' +
                    distanceTip +
                    ': ' +
                    distanceValue +
                    '</p>';
                  popup.setPosition(evt.coordinate);
                  return;
                }
              });
            });

            closer.onclick = () => {
              popup.setPosition(undefined);
              closer.blur();
              return false;
            };

            //// FIN GESTION DE POPUP D'INFORMATIONS SUR LES FEATURES //////////////////
          }
        }
        buildMap();

        scope.exportToShape = () => {
          gaDomUtils.showGlobalLoader();
          LongitudinalProfileFactory.exportProfilToShapeFile(scope.geojson)
            .then((res) => {
              const resultFileName = res.data;
              const downloadurl =
                '/services/'+localStorage.getItem('portal')+'/profile/downloadexportedfile?f=json' +
                '&exportedFileId=' +
                resultFileName;

              window.open(downloadurl);

              //                        var blob = new Blob([resultFile], {type: "application/zip"});
              //
              //                        var url = URL.createObjectURL(blob);
              //                        window.open(url);
            })
            .catch(
              (error) =>
                require('toastr').error("L'export SHP a échoué : ", error)
            )
            .finally(gaDomUtils.hideGlobalLoader());
        };

        //// EXPORT DXF //////////////////////////////////////////////////////////////

        scope.exportToDXF = () => {
          gaDomUtils.showGlobalLoader();
          LongitudinalProfileFactory.exportProfilToDXF(scope.geojson)
            .then((res) => {
              const resultFileName = res.data;
              const downloadurl =
                '/services/{portalid}/profile/downloadexportedfile?f=json' +
                '&exportedFileId=' +
                resultFileName;

              window.open(downloadurl);
            })
            .catch((error) =>
              require('toastr').error("L'export DXF a échoué : ", error)
            )
            .finally(gaDomUtils.hideGlobalLoader());
        };

        //// RAPPORT JASPER //////////////////////////////////////////////////////////////

        scope.exportToJasper = () => {
          gaDomUtils.showGlobalLoader();
          const nodesList = [];
          if (
            scope.geojson &&
            scope.geojson.features &&
            scope.geojson.features.length > 0
          ) {
            const nodes = scope.geojson.features.filter((feat) =>
              feat.id.includes('vertex')
            );
            const pipes = scope.geojson.features.filter((feat) =>
              feat.id.includes('edge')
            );

            if (nodes && nodes.length > 0) {
              // tri selon l'ordre des noeuds dans le sens du parcours (ex. id = vertex.1)
              nodes.sort((a, b) => a.id.localeCompare(b.id));
              let cumulatedDistance = 0;

              for (let i = 0; i < nodes.length; i++) {
                const node = {
                  junctionID: nodes[i].properties.label.toString(),
                  junctionElevation: nodes[i].properties.coteTampon.toFixed(2).toString(),
                  junctionZt: nodes[i].properties.coteTampon
                    .toFixed(2)
                    .toString(),
                  junctionZr: nodes[i].properties.coteRadier
                    .toFixed(2)
                    .toString(),
                };

                if (i == 0) {
                  // 1er noeud du parcours
                  node.partialDistance = nodes[
                    i + 1
                  ].properties.distance.toString();
                  node.cumulatedDistance = '';
                  node.slope = (pipes[i].properties.pente*10).toFixed(2).toString();
                  node.section = Math.round(pipes[i].properties.diametre).toString();

                  cumulatedDistance = nodes[i + 1].properties.distance;
                } else if (i == nodes.length - 1) {
                  // dernier noeud du parcours
                  node.partialDistance = '';
                  node.cumulatedDistance = cumulatedDistance
                    .toFixed(2)
                    .toString();
                  node.slope = '';
                  node.section = '';
                } else {
                  node.partialDistance = nodes[i + 1].properties.distance
                    .toFixed(2)
                    .toString();
                  node.cumulatedDistance = cumulatedDistance
                    .toFixed(2)
                    .toString();
                  node.slope = (pipes[i].properties.pente*10).toFixed(2).toString();
                  node.section = Math.round(pipes[i].properties.diametre).toString();

                  cumulatedDistance += nodes[i + 1].properties.distance;
                }
                nodesList.push(node);
              }
            }
          }
          const senddata = {
            nodesList: nodesList,
          };
          LongitudinalProfileFactory.generateJasperReport(senddata)
            .then((res) => {
              if (res && res.data) {
                if (res.data.exportedEntry) {
                  const resultFileName = res.data.exportedEntry;
                  const portalid = res.data.portalid;
                  const downloadurl =
                    '/services/' +
                    portalid +
                    '/profile/downloadexportedfile?f=json' +
                    '&exportedFileId=' +
                    resultFileName;

                  window.open(downloadurl);
                } else {
                  require('toastr').error(
                    'Impossible de générer le rapport : erreur serveur'
                  );
                }
              }
            })
            .catch((error) =>
              require('toastr').error("L'export PDF a échoué : ", error)
            )
            .finally(gaDomUtils.hideGlobalLoader());
        };

        //// EXPORT CSV //////////////////////////////////////////////////////////////

        scope.csvSourceArray = [];
        scope.getCsvHeader = () => {
          return [
            'fid',
            coteTamponTip,
            coteRadierTip,
            diametreTip,
            penteTip,
            distanceTip,
            distanceCumulTip,
          ];
        };

        function buildCsvArray() {
          angular.forEach(features, (f, index) => {
            const position = f.get('position');
            if (position != undefined && position > 0) {
              let dataColumn = scope.csvSourceArray[position];
              if (dataColumn == undefined) {
                dataColumn = {};
                dataColumn['fid'] = f.get('fid');
                dataColumn[coteTamponTip] = '';
                dataColumn[coteRadierTip] = '';
                dataColumn[diametreTip] = '';
                dataColumn[penteTip] = '';
                dataColumn[distanceTip] = '';
                dataColumn[distanceCumulTip] = '';
                scope.csvSourceArray[position] = dataColumn;
              }

              if (f.get('categorie') == 'coteTampon') {
                dataColumn[coteTamponTip] = f.get('label');
              } else if (f.get('categorie') == 'coteRadier') {
                dataColumn[coteRadierTip] = f.get('label');
              } else if (f.get('categorie') == 'diametre') {
                dataColumn[diametreTip] = f.get('label');
              } else if (f.get('categorie') == 'pente') {
                dataColumn[penteTip] = f.get('label');
              } else if (f.get('categorie') == 'distancePartielle') {
                dataColumn[distanceTip] = f.get('label');
              } else if (f.get('categorie') == 'distanceCumulee') {
                dataColumn[distanceCumulTip] = f.get('label');
              }
            }
          });
        }
        //Appel de la méthode de préparation des données du tableau du profil à exporter en CSV
        //après que les promeses de récupération des messages internationnalisés aient été résolues.
        $q.all([p1, p2, p3, p4, p5, p6]).then((res) => {
          buildCsvArray();
        });

        //// FIN EXPORT CSV par lib ng-csv//////////////////////////////////////////////////////////////

        scope.exportToCSV = () => {
          gaDomUtils.showGlobalLoader();
          LongitudinalProfileFactory.exportProfilToCSV(scope.geojson)
            .then((res) => {
              const resultFileName = res.data;
              const downloadurl =
                '/services/'+localStorage.getItem('portal')+'/profile/downloadexportedfile?f=json' +
                '&exportedFileId=' +
                resultFileName;

              window.open(downloadurl);
            })
            .catch((error) =>
              require('toastr').error("L'export CSV a échoué : ", error)
            )
            .finally(gaDomUtils.hideGlobalLoader());
        };

        let title = 'profil';
        $translate('profil.profilViewTitle').then((res) => {
          title = res;
        });

        let viewSaved = undefined;
        scope.exportToImage = () => {
          //Génération d'une image
          map.once('postcompose', (event) => {
            const canvas = event.context.canvas;

            let context = canvas.getContext('2d');
            // draw behind existing image
            context.globalCompositeOperation = 'destination-over';
            // add background
            context.fillStyle = 'white';
            context.fillRect(0, 0, canvas.width, canvas.height);
            // reset the context
            context.globalCompositeOperation = 'source-over';

            const image = canvas.toDataURL('image/png');

            const linkElem = document.querySelector('#imgLink');
            linkElem.href = image;
            linkElem.download = title; //
            //                        window.open(image);
            //                         window.URL.revokeObjectURL();
            //                viewSaved.once('change:center',function(event){
            //                     map.setView(viewSaved);
            //                });
            //                viewSaved.once('change:resolution',function(event){
            //                     map.setView(viewSaved);
            //                });
          });
          viewSaved = map.getView();
          map.renderSync();
        };

        /// EXPORT DU PROFIL EN LONG /////////////////

        scope.openProfileForm = () => {
          // send to parent longitudinalprofilewidget
          $rootScope.$emit('openDxfPopup', { data: '$rootScope.emit' });
        };
      },
    };
  };

  profilPreview.$inject = [
    'LongitudinalProfileFactory',
    '$translate',
    '$q',
    '$rootScope',
    'gaDomUtils'
  ];
  return profilPreview;
});
