'use strict';
define(function () {
  var profilform = function (
    $filter,
    $rootScope,
    AssEditProcessServices,
    gclayers
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/longitudinalprofile/views/profilForm.html',
      restrict: 'EA',
      scope: {
        selectTool: '=',
        endsNodeIds: '=',
        diameter: '=',
      },
      link: function (scope, elt, attrs, ctrl) {

        const GEOJSON_PARSER = new ol.format.GeoJSON();
        console.log(scope.selectTool);

        scope.printFormats = [
          {
            label: 'A4',
            index: 1,
          },
          {
            label: 'A4_LONG',
            index: 2,
          },
          {
            label: 'A3',
            index: 3,
          },
        ];

        scope.longProfilInput = {
          title: 'Profil en long',
          pc: 50,
          vertScale: 100,
          horizScale: 100,
          textSize: 0.005,
          startId: scope.endsNodeIds[0],
          endId: scope.endsNodeIds[1],
          emitter: '',
          recipient: '',
          localisation: '',
          format: scope.printFormats[0],
          date: new Date(),
          diameterUnit: scope.diameter ? scope.diameter.name : 'mm',
          diameterDivider: scope.diameter ? scope.diameter.divider : 1000,
        };
        
        scope.isDate = scope.longProfilInput.date instanceof Date;
        $rootScope.$on('gcSelectChange', (event, features) => {
          scope.selectTool.res = features;
        });

        scope.open = function ($event) {
          $event.preventDefault();
          $event.stopPropagation();

          scope.opened = true;
        };

        scope.onSelectNodeId = (position) => {
          gclayers.getselectSource().clear();

          console.log(position);
          console.log(scope.selectTool.res);
          if (scope.selectTool.res.features.length > 0) {
            const selectedFeatures = GEOJSON_PARSER.readFeatures(
              scope.selectTool.res
            );
            const selectedFeature = selectedFeatures[0];
            gclayers.getselectSource().addFeature(selectedFeature);

            const featProperties = selectedFeature.getProperties();
            const idValue = featProperties['id'];

            if (position == 'start') {
              scope.longProfilInput.startId = idValue;
              document.getElementById('ass_long_profil_start_id').value =
                scope.longProfilInput.startId;
            } else if (position == 'end') {
              scope.longProfilInput.endId = idValue;
              document.getElementById('ass_long_profil_end_id').value =
                scope.longProfilInput.endId;
            }
          }
        };

        scope.validLongProfilBuild = () => {
          if (!scope.isEmpty()) {
            AssEditProcessServices.launchLongProfilBuild(scope);
          } else {
            swal({
              title: $filter('translate')('gcmap.information'),
              text: $filter('translate')(
                'networkedit.sanitation.longitudinalProfilMandatory'
              ),
              type: 'warning',
              showCancelButton: false,
              confirmButtonColor: '#5cb85c',
              confirmButtonText: $filter('translate')('common.ok'),
              closeOnConfirm: true,
            });
          }
        };

        scope.isEmpty = () => {
          return Object.values(scope.longProfilInput).some(
            (x) => x == null || x == ''
          );
        };
      },
    };
  };

  profilform.$inject = [
    '$filter',
    '$rootScope',
    'AssEditProcessServices',
    'gclayers',
  ];
  return profilform;
});
