/*global define */
define(['angular', 'widgets/mapapp/legend/services/legendService'], function(
  angular,
  legendService
) {
  'use strict';

  // Angular module
  var legendManager = angular.module('gc_legend', []);
  legendManager.service('legendService', legendService);

  // Widget directive
  legendManager.directive('galegend', function() {
    return {
      restrict: 'A',
      templateUrl: 'js/XG/widgets/mapapp/legend/views/legend.html',
      controller: [
        '$scope',
        'legendService',
        function($scope, legendService) {
          // Listener for panel changes
          function onPanelChange(event, arg) {
            if (arg.directive === 'galegend') {
              legendService.remove($scope);
              if (arg.active) {
                legendService.add($scope);
              }
            }
          }
          $scope.visible = {};
          $scope.$on('openTools_galegend', onPanelChange);
          $scope.$on('closeTools_galegend', onPanelChange);
          $scope.$on('openCloseTools_galegend', onPanelChange);
        },
      ],
      controllerAs: 'ctrl',
      scope: true, // Isolated scope inheriting from parent scope
    };
  });

  // Independent directive
  legendManager.directive('legendList', function() {
    return {
      restrict: 'E',
      templateUrl: 'js/XG/widgets/mapapp/legend/views/legend.html',
      controller: [
        '$scope',
        'legendService',
        function($scope, legendService) {
          legendService.add($scope);
          $scope.visible = {};
          $scope.$on('$destroy', function() {
            legendService.remove($scope);
          });
        },
      ],
      scope: {
        legendLayers: '=?',
        ignoreScale: '=',
        ignoreMissingObjects: '=',
      },
    };
  });

  return legendManager;
});
